/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lineage.sink;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.openlineage.server.OpenLineage;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.lineage.sink.LineageSink;
import org.apache.gravitino.listener.api.EventListenerPlugin;
import org.apache.gravitino.listener.api.event.Event;
import org.apache.gravitino.listener.api.event.EventWrapper;
import org.apache.gravitino.utils.ClassUtils;

public class LineageSinkEventListener
implements EventListenerPlugin {
    private LineageSink lineageSink;

    public void init(Map<String, String> properties) throws RuntimeException {
        String sinkClassName = properties.get("sinkClass");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)sinkClassName), (Object)"sinkClass is not set.");
        this.lineageSink = (LineageSink)ClassUtils.loadClass((String)sinkClassName);
        this.lineageSink.initialize(properties);
    }

    public void start() throws RuntimeException {
    }

    public void stop() throws RuntimeException {
        if (this.lineageSink != null) {
            this.lineageSink.close();
        }
    }

    public EventListenerPlugin.Mode mode() {
        return EventListenerPlugin.Mode.ASYNC_ISOLATED;
    }

    public void onPostEvent(Event postEvent) throws RuntimeException {
        EventWrapper wrapper = (EventWrapper)postEvent;
        this.lineageSink.sink((OpenLineage.RunEvent)wrapper.getObject());
    }

    @VisibleForTesting
    LineageSink lineageSink() {
        return this.lineageSink;
    }
}

