/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.TableCommand;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.partitions.Partition;

public class TablePartition
extends TableCommand {
    protected final String schema;
    protected final String table;

    public TablePartition(CommandContext context, String metalake, String catalog, String schema, String table) {
        super(context, metalake, catalog);
        this.schema = schema;
        this.table = table;
    }

    @Override
    public void handle() {
        Transform[] transforms = new Transform[]{};
        try {
            NameIdentifier name = NameIdentifier.of(this.schema, this.table);
            transforms = this.tableCatalog().loadTable(name).partitioning();
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        for (Transform transform : transforms) {
            Partition[] partitions = transform.assignments();
            if (partitions.length == 0) {
                this.printInformation("None");
                continue;
            }
            for (Partition partition : partitions) {
                this.printResults(partition.name() + "," + partition.properties());
            }
        }
    }
}

