/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.sql.calcite.util.datasets;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.timeline.DataSegment;

import java.io.File;

public interface TestDataSet
{
  String TIMESTAMP_COLUMN = "t";

  MapBasedTestDataset NUMFOO = new NumFoo();
  MapBasedTestDataset LARRY = new Larry();
  MapBasedTestDataset BROADCAST = new NumFoo("broadcast");
  MapBasedTestDataset RESTRICTED_BROADCAST = new NumFoo("restrictedBroadcastDatasource_m1_is_6");

  MapBasedTestDataset NUMBERS = new Numbers();

  String getName();

  QueryableIndex makeIndex(ObjectMapper jsonMapper, File tmpDir);

  DataSegment makeSegment(QueryableIndex index);
}
