/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.metadata.PasswordProvider;
import org.joda.time.Duration;

public class Pac4jCommonConfig {
    @JsonProperty
    private final boolean enableCustomSslContext;
    @JsonProperty
    private final PasswordProvider cookiePassphrase;
    @JsonProperty
    private final Duration readTimeout;

    @JsonCreator
    public Pac4jCommonConfig(@JsonProperty(value="enableCustomSslContext") boolean enableCustomSslContext, @JsonProperty(value="cookiePassphrase") PasswordProvider cookiePassphrase, @JsonProperty(value="readTimeout") Duration readTimeout) {
        this.enableCustomSslContext = enableCustomSslContext;
        this.cookiePassphrase = (PasswordProvider)Preconditions.checkNotNull((Object)cookiePassphrase, (Object)"null cookiePassphrase");
        this.readTimeout = readTimeout == null ? Duration.millis((long)5000L) : readTimeout;
    }

    @JsonProperty
    public boolean isEnableCustomSslContext() {
        return this.enableCustomSslContext;
    }

    @JsonProperty
    public PasswordProvider getCookiePassphrase() {
        return this.cookiePassphrase;
    }

    @JsonProperty
    public Duration getReadTimeout() {
        return this.readTimeout;
    }
}

