/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1TopologySpreadConstraint;
import io.kubernetes.client.openapi.models.V1TopologySpreadConstraintFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1TopologySpreadConstraintFluentImpl<A extends V1TopologySpreadConstraintFluent<A>>
extends BaseFluent<A>
implements V1TopologySpreadConstraintFluent<A> {
    private V1LabelSelectorBuilder labelSelector;
    private List<String> matchLabelKeys;
    private Integer maxSkew;
    private Integer minDomains;
    private String nodeAffinityPolicy;
    private String nodeTaintsPolicy;
    private String topologyKey;
    private String whenUnsatisfiable;

    public V1TopologySpreadConstraintFluentImpl() {
    }

    public V1TopologySpreadConstraintFluentImpl(V1TopologySpreadConstraint instance) {
        if (instance != null) {
            this.withLabelSelector(instance.getLabelSelector());
            this.withMatchLabelKeys(instance.getMatchLabelKeys());
            this.withMaxSkew(instance.getMaxSkew());
            this.withMinDomains(instance.getMinDomains());
            this.withNodeAffinityPolicy(instance.getNodeAffinityPolicy());
            this.withNodeTaintsPolicy(instance.getNodeTaintsPolicy());
            this.withTopologyKey(instance.getTopologyKey());
            this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
        }
    }

    @Override
    @Deprecated
    public V1LabelSelector getLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public V1LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public A withLabelSelector(V1LabelSelector labelSelector) {
        this._visitables.get("labelSelector").remove(this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new V1LabelSelectorBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get("labelSelector").remove(this.labelSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public V1TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNestedImpl();
    }

    @Override
    public V1TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelectorLike(V1LabelSelector item) {
        return new LabelSelectorNestedImpl(item);
    }

    @Override
    public V1TopologySpreadConstraintFluent.LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector());
    }

    @Override
    public V1TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(V1LabelSelector item) {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : item);
    }

    @Override
    public A addToMatchLabelKeys(int index, String item) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        this.matchLabelKeys.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMatchLabelKeys(int index, String item) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        this.matchLabelKeys.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMatchLabelKeys(String ... items) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchLabelKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatchLabelKeys(Collection<String> items) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchLabelKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchLabelKeys(String ... items) {
        for (String item : items) {
            if (this.matchLabelKeys == null) continue;
            this.matchLabelKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatchLabelKeys(Collection<String> items) {
        for (String item : items) {
            if (this.matchLabelKeys == null) continue;
            this.matchLabelKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMatchLabelKeys() {
        return this.matchLabelKeys;
    }

    @Override
    public String getMatchLabelKey(int index) {
        return this.matchLabelKeys.get(index);
    }

    @Override
    public String getFirstMatchLabelKey() {
        return this.matchLabelKeys.get(0);
    }

    @Override
    public String getLastMatchLabelKey() {
        return this.matchLabelKeys.get(this.matchLabelKeys.size() - 1);
    }

    @Override
    public String getMatchingMatchLabelKey(Predicate<String> predicate) {
        for (String item : this.matchLabelKeys) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMatchLabelKey(Predicate<String> predicate) {
        for (String item : this.matchLabelKeys) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMatchLabelKeys(List<String> matchLabelKeys) {
        if (matchLabelKeys != null) {
            this.matchLabelKeys = new ArrayList<String>();
            for (String item : matchLabelKeys) {
                this.addToMatchLabelKeys(item);
            }
        } else {
            this.matchLabelKeys = null;
        }
        return (A)this;
    }

    @Override
    public A withMatchLabelKeys(String ... matchLabelKeys) {
        if (this.matchLabelKeys != null) {
            this.matchLabelKeys.clear();
            this._visitables.remove("matchLabelKeys");
        }
        if (matchLabelKeys != null) {
            for (String item : matchLabelKeys) {
                this.addToMatchLabelKeys(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchLabelKeys() {
        return this.matchLabelKeys != null && !this.matchLabelKeys.isEmpty();
    }

    @Override
    public Integer getMaxSkew() {
        return this.maxSkew;
    }

    @Override
    public A withMaxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
        return (A)this;
    }

    @Override
    public Boolean hasMaxSkew() {
        return this.maxSkew != null;
    }

    @Override
    public Integer getMinDomains() {
        return this.minDomains;
    }

    @Override
    public A withMinDomains(Integer minDomains) {
        this.minDomains = minDomains;
        return (A)this;
    }

    @Override
    public Boolean hasMinDomains() {
        return this.minDomains != null;
    }

    @Override
    public String getNodeAffinityPolicy() {
        return this.nodeAffinityPolicy;
    }

    @Override
    public A withNodeAffinityPolicy(String nodeAffinityPolicy) {
        this.nodeAffinityPolicy = nodeAffinityPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasNodeAffinityPolicy() {
        return this.nodeAffinityPolicy != null;
    }

    @Override
    public String getNodeTaintsPolicy() {
        return this.nodeTaintsPolicy;
    }

    @Override
    public A withNodeTaintsPolicy(String nodeTaintsPolicy) {
        this.nodeTaintsPolicy = nodeTaintsPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasNodeTaintsPolicy() {
        return this.nodeTaintsPolicy != null;
    }

    @Override
    public String getTopologyKey() {
        return this.topologyKey;
    }

    @Override
    public A withTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return (A)this;
    }

    @Override
    public Boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    @Override
    public String getWhenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    @Override
    public A withWhenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
        return (A)this;
    }

    @Override
    public Boolean hasWhenUnsatisfiable() {
        return this.whenUnsatisfiable != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1TopologySpreadConstraintFluentImpl that = (V1TopologySpreadConstraintFluentImpl)o;
        if (!Objects.equals(this.labelSelector, that.labelSelector)) {
            return false;
        }
        if (!Objects.equals(this.matchLabelKeys, that.matchLabelKeys)) {
            return false;
        }
        if (!Objects.equals(this.maxSkew, that.maxSkew)) {
            return false;
        }
        if (!Objects.equals(this.minDomains, that.minDomains)) {
            return false;
        }
        if (!Objects.equals(this.nodeAffinityPolicy, that.nodeAffinityPolicy)) {
            return false;
        }
        if (!Objects.equals(this.nodeTaintsPolicy, that.nodeTaintsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.topologyKey, that.topologyKey)) {
            return false;
        }
        return Objects.equals(this.whenUnsatisfiable, that.whenUnsatisfiable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.labelSelector, this.matchLabelKeys, this.maxSkew, this.minDomains, this.nodeAffinityPolicy, this.nodeTaintsPolicy, this.topologyKey, this.whenUnsatisfiable, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector + ",");
        }
        if (this.matchLabelKeys != null && !this.matchLabelKeys.isEmpty()) {
            sb.append("matchLabelKeys:");
            sb.append(this.matchLabelKeys + ",");
        }
        if (this.maxSkew != null) {
            sb.append("maxSkew:");
            sb.append(this.maxSkew + ",");
        }
        if (this.minDomains != null) {
            sb.append("minDomains:");
            sb.append(this.minDomains + ",");
        }
        if (this.nodeAffinityPolicy != null) {
            sb.append("nodeAffinityPolicy:");
            sb.append(this.nodeAffinityPolicy + ",");
        }
        if (this.nodeTaintsPolicy != null) {
            sb.append("nodeTaintsPolicy:");
            sb.append(this.nodeTaintsPolicy + ",");
        }
        if (this.topologyKey != null) {
            sb.append("topologyKey:");
            sb.append(this.topologyKey + ",");
        }
        if (this.whenUnsatisfiable != null) {
            sb.append("whenUnsatisfiable:");
            sb.append(this.whenUnsatisfiable);
        }
        sb.append("}");
        return sb.toString();
    }

    class LabelSelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1TopologySpreadConstraintFluent.LabelSelectorNested<N>>
    implements V1TopologySpreadConstraintFluent.LabelSelectorNested<N>,
    Nested<N> {
        V1LabelSelectorBuilder builder;

        LabelSelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        LabelSelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1TopologySpreadConstraintFluentImpl.this.withLabelSelector(this.builder.build());
        }

        @Override
        public N endLabelSelector() {
            return this.and();
        }
    }
}

