/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.jmx;

import java.util.Map;
import java.util.StringTokenizer;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarInvoker;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.util.ReferenceMap;

public class SigarInvokerJMX
extends SigarInvoker {
    public static final String DOMAIN_NAME = "sigar";
    public static final String PROP_TYPE = "Type";
    public static final String PROP_ARG = "Arg";
    private String arg = null;
    private static Map cache = ReferenceMap.synchronizedMap();

    public static SigarInvokerJMX getInstance(SigarProxy proxy, String name) {
        SigarInvokerJMX invoker;
        int ix = name.indexOf(":");
        if (ix > 0) {
            name = name.substring(ix + 1);
        }
        if ((invoker = (SigarInvokerJMX)cache.get(name)) != null) {
            invoker.setProxy(proxy);
            return invoker;
        }
        invoker = new SigarInvokerJMX();
        invoker.setProxy(proxy);
        StringTokenizer st = new StringTokenizer(name, ",");
        while (st.hasMoreTokens()) {
            String attr = st.nextToken();
            ix = attr.indexOf(61);
            String key = attr.substring(0, ix);
            String val = attr.substring(key.length() + 1);
            if (key.equals(PROP_TYPE)) {
                invoker.setType(val);
                continue;
            }
            if (!key.equals(PROP_ARG)) continue;
            invoker.setArg(SigarInvokerJMX.decode(val));
        }
        cache.put(name, invoker);
        return invoker;
    }

    public static String decode(String val) {
        StringBuffer buf = new StringBuffer(val.length());
        boolean changed = false;
        int len = val.length();
        int i = 0;
        while (i < len) {
            char c = val.charAt(i);
            if (c == '%') {
                int d;
                if (i + 2 > len) break;
                String s = val.substring(i + 1, i + 3);
                if (s.equals("3A")) {
                    d = 58;
                } else if (s.equals("3D")) {
                    d = 61;
                } else if (s.equals("2C")) {
                    d = 44;
                } else {
                    buf.append(c);
                    ++i;
                    continue;
                }
                changed = true;
                buf.append((char)d);
                i += 3;
                continue;
            }
            buf.append(c);
            ++i;
        }
        return changed ? buf.toString() : val;
    }

    private void setArg(String val) {
        this.arg = val;
    }

    public String getArg() {
        return this.arg;
    }

    public static String getObjectName(String type, String arg) {
        String s = "sigar:";
        s = s + "Type=" + type;
        if (arg != null) {
            s = s + ",Arg=" + arg;
        }
        return s;
    }

    public String getObjectName() {
        return SigarInvokerJMX.getObjectName(this.getType(), this.getArg());
    }

    public String toString() {
        return this.getObjectName();
    }

    public Object invoke(String attr) throws SigarException, SigarNotImplementedException {
        return super.invoke(this.getArg(), attr);
    }
}

