/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.query.Order;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.SingleScanTimeDimensionSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.SelectableColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.column.ValueTypes;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.nested.NestedColumnSelectorFactory;

public class QueryableIndexColumnSelectorFactory
implements ColumnSelectorFactory,
RowIdSupplier {
    private final VirtualColumns virtualColumns;
    private final Order timeOrder;
    protected final ReadableOffset offset;
    private final ColumnSelector columnSelector;
    private final Map<DimensionSpec, DimensionSelector> dimensionSelectorCache;
    private final Map<String, ColumnValueSelector<?>> valueSelectorCache;

    public QueryableIndexColumnSelectorFactory(VirtualColumns virtualColumns, Order timeOrder, ReadableOffset offset, ColumnSelector columnSelector) {
        this.virtualColumns = virtualColumns;
        this.timeOrder = timeOrder;
        this.offset = offset;
        this.columnSelector = columnSelector;
        this.dimensionSelectorCache = new HashMap<DimensionSpec, DimensionSelector>();
        this.valueSelectorCache = new HashMap();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        Function<DimensionSpec, DimensionSelector> mappingFunction = spec -> {
            if (this.virtualColumns.exists(spec.getDimension())) {
                return this.virtualColumns.makeDimensionSelector(dimensionSpec, this, this.columnSelector, this.offset);
            }
            return spec.decorate(this.makeDimensionSelectorUndecorated((DimensionSpec)spec));
        };
        DimensionSelector dimensionSelector = this.dimensionSelectorCache.get(dimensionSpec);
        if (dimensionSelector == null) {
            dimensionSelector = mappingFunction.apply(dimensionSpec);
            this.dimensionSelectorCache.put(dimensionSpec, dimensionSelector);
        }
        return dimensionSelector;
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        ColumnHolder columnHolder = this.columnSelector.getColumnHolder(dimension);
        if (columnHolder == null) {
            return DimensionSelector.constant(null, extractionFn);
        }
        if (dimension.equals("__time") && this.timeOrder != Order.NONE) {
            return new SingleScanTimeDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn, this.timeOrder);
        }
        ColumnCapabilities capabilities = columnHolder.getCapabilities();
        if (columnHolder.getCapabilities().isNumeric()) {
            return ValueTypes.makeNumericWrappingDimensionSelector((ValueType)capabilities.getType(), this.makeColumnValueSelector(dimension), extractionFn);
        }
        SelectableColumn column = columnHolder.getColumn();
        if (column instanceof DictionaryEncodedColumn) {
            return ((DictionaryEncodedColumn)column).makeDimensionSelector(this.offset, extractionFn);
        }
        NestedColumnSelectorFactory nestedColumnSelectorFactory = column.as(NestedColumnSelectorFactory.class);
        if (nestedColumnSelectorFactory != null) {
            return nestedColumnSelectorFactory.makeDimensionSelector(List.of(), extractionFn, this, this.offset);
        }
        return DimensionSelector.constant(null, extractionFn);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        ColumnValueSelector columnValueSelector = this.valueSelectorCache.get(columnName);
        if (columnValueSelector == null) {
            ColumnHolder columnHolder;
            columnValueSelector = this.virtualColumns.exists(columnName) ? this.virtualColumns.makeColumnValueSelector(columnName, this, this.columnSelector, this.offset) : ((columnHolder = this.columnSelector.getColumnHolder(columnName)) != null && columnHolder.getColumn() instanceof BaseColumn ? ((BaseColumn)columnHolder.getColumn()).makeColumnValueSelector(this.offset) : NilColumnValueSelector.instance());
            this.valueSelectorCache.put(columnName, columnValueSelector);
        }
        return columnValueSelector;
    }

    @Override
    @Nullable
    public RowIdSupplier getRowIdSupplier() {
        return this;
    }

    @Override
    public long getRowId() {
        return this.offset.getOffset();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        return this.virtualColumns.getColumnCapabilitiesWithFallback(this.columnSelector, columnName);
    }
}

