/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleSumVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;

    public DoubleSumVectorAggregator(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putDouble(position, 0.0);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        double[] vector = this.selector.getDoubleVector();
        double sum = 0.0;
        for (int i = startRow; i < endRow; ++i) {
            sum += vector[i];
        }
        buf.putDouble(position, buf.getDouble(position) + sum);
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        double[] vector = this.selector.getDoubleVector();
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            buf.putDouble(position, buf.getDouble(position) + vector[rows != null ? rows[i] : i]);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return buf.getDouble(position);
    }

    @Override
    public void close() {
    }
}

