/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.metadata.DynamicConfigProvider;

public class EnvironmentVariableDynamicConfigProvider
implements DynamicConfigProvider<String> {
    private final ImmutableMap<String, String> variables;

    @JsonCreator
    public EnvironmentVariableDynamicConfigProvider(@JsonProperty(value="variables") Map<String, String> config) {
        this.variables = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(config, (Object)"config")));
    }

    @JsonProperty(value="variables")
    public Map<String, String> getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, String> getConfig() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : this.variables.entrySet()) {
            map.put((String)entry.getKey(), this.getEnv((String)entry.getValue()));
        }
        return map;
    }

    @VisibleForTesting
    protected String getEnv(String var) {
        return System.getenv(var);
    }

    public String toString() {
        return "EnvironmentVariablePasswordProvider{variable='" + this.variables + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentVariableDynamicConfigProvider that = (EnvironmentVariableDynamicConfigProvider)o;
        return Objects.equals(this.variables, that.variables);
    }

    public int hashCode() {
        return this.variables.hashCode();
    }
}

