/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.ImmutableMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.druid.java.util.common.logger.Logger;

@Provider
public class CustomExceptionMapper
implements ExceptionMapper<JsonMappingException> {
    private static final Logger log = new Logger(CustomExceptionMapper.class);
    public static final String ERROR_KEY = "error";
    public static final String UNABLE_TO_PROCESS_ERROR = "unknown json mapping exception";

    public Response toResponse(JsonMappingException exception) {
        log.warn(exception.getMessage() == null ? UNABLE_TO_PROCESS_ERROR : exception.getMessage(), new Object[0]);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)ERROR_KEY, (Object)(exception.getMessage() == null ? UNABLE_TO_PROCESS_ERROR : exception.getMessage().split(System.lineSeparator())[0]))).type("application/json").build();
    }
}

