/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.ExponentialBackoffOptions;
import com.azure.core.http.policy.RetryOptions;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.druid.data.input.azure.AzureStorageAccountInputSourceConfig;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureClientFactory;

public class AzureIngestClientFactory
extends AzureClientFactory {
    private final AzureStorageAccountInputSourceConfig azureStorageAccountInputSourceConfig;

    public AzureIngestClientFactory(AzureAccountConfig config, @Nullable AzureStorageAccountInputSourceConfig azureStorageAccountInputSourceConfig) {
        super(config);
        this.azureStorageAccountInputSourceConfig = azureStorageAccountInputSourceConfig;
    }

    @Override
    public BlobServiceClient buildNewClient(Integer retryCount, String storageAccount) {
        BlobServiceClientBuilder clientBuilder = new BlobServiceClientBuilder().endpoint("https://" + storageAccount + "." + this.config.getBlobStorageEndpoint());
        if (this.azureStorageAccountInputSourceConfig == null) {
            return super.buildNewClient(retryCount, storageAccount);
        }
        if (this.azureStorageAccountInputSourceConfig.getKey() != null) {
            clientBuilder.credential(new StorageSharedKeyCredential(storageAccount, this.azureStorageAccountInputSourceConfig.getKey()));
        } else if (this.azureStorageAccountInputSourceConfig.getSharedAccessStorageToken() != null) {
            clientBuilder.sasToken(this.azureStorageAccountInputSourceConfig.getSharedAccessStorageToken());
        } else if (this.azureStorageAccountInputSourceConfig.getAppRegistrationClientId() != null && this.azureStorageAccountInputSourceConfig.getAppRegistrationClientSecret() != null) {
            clientBuilder.credential((TokenCredential)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientSecret(this.azureStorageAccountInputSourceConfig.getAppRegistrationClientSecret()).clientId(this.azureStorageAccountInputSourceConfig.getAppRegistrationClientId())).tenantId(this.azureStorageAccountInputSourceConfig.getTenantId())).build());
        } else {
            return super.buildNewClient(retryCount, storageAccount);
        }
        clientBuilder.retryOptions(new RetryOptions(new ExponentialBackoffOptions().setMaxRetries(Integer.valueOf(retryCount != null ? retryCount.intValue() : this.config.getMaxTries())).setBaseDelay(Duration.ofMillis(1000L)).setMaxDelay(Duration.ofMillis(60000L))));
        return clientBuilder.buildClient();
    }
}

