/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1AggregationRule;
import io.kubernetes.client.openapi.models.V1AggregationRuleBuilder;
import io.kubernetes.client.openapi.models.V1AggregationRuleFluentImpl;
import io.kubernetes.client.openapi.models.V1ClusterRole;
import io.kubernetes.client.openapi.models.V1ClusterRoleFluent;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1PolicyRule;
import io.kubernetes.client.openapi.models.V1PolicyRuleBuilder;
import io.kubernetes.client.openapi.models.V1PolicyRuleFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ClusterRoleFluentImpl<A extends V1ClusterRoleFluent<A>>
extends BaseFluent<A>
implements V1ClusterRoleFluent<A> {
    private V1AggregationRuleBuilder aggregationRule;
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private ArrayList<V1PolicyRuleBuilder> rules;

    public V1ClusterRoleFluentImpl() {
    }

    public V1ClusterRoleFluentImpl(V1ClusterRole instance) {
        if (instance != null) {
            this.withAggregationRule(instance.getAggregationRule());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRules(instance.getRules());
        }
    }

    @Override
    @Deprecated
    public V1AggregationRule getAggregationRule() {
        return this.aggregationRule != null ? this.aggregationRule.build() : null;
    }

    @Override
    public V1AggregationRule buildAggregationRule() {
        return this.aggregationRule != null ? this.aggregationRule.build() : null;
    }

    @Override
    public A withAggregationRule(V1AggregationRule aggregationRule) {
        this._visitables.get("aggregationRule").remove(this.aggregationRule);
        if (aggregationRule != null) {
            this.aggregationRule = new V1AggregationRuleBuilder(aggregationRule);
            this._visitables.get("aggregationRule").add(this.aggregationRule);
        } else {
            this.aggregationRule = null;
            this._visitables.get("aggregationRule").remove(this.aggregationRule);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAggregationRule() {
        return this.aggregationRule != null;
    }

    @Override
    public V1ClusterRoleFluent.AggregationRuleNested<A> withNewAggregationRule() {
        return new AggregationRuleNestedImpl();
    }

    @Override
    public V1ClusterRoleFluent.AggregationRuleNested<A> withNewAggregationRuleLike(V1AggregationRule item) {
        return new AggregationRuleNestedImpl(item);
    }

    @Override
    public V1ClusterRoleFluent.AggregationRuleNested<A> editAggregationRule() {
        return this.withNewAggregationRuleLike(this.getAggregationRule());
    }

    @Override
    public V1ClusterRoleFluent.AggregationRuleNested<A> editOrNewAggregationRule() {
        return this.withNewAggregationRuleLike(this.getAggregationRule() != null ? this.getAggregationRule() : new V1AggregationRuleBuilder().build());
    }

    @Override
    public V1ClusterRoleFluent.AggregationRuleNested<A> editOrNewAggregationRuleLike(V1AggregationRule item) {
        return this.withNewAggregationRuleLike(this.getAggregationRule() != null ? this.getAggregationRule() : item);
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1ClusterRoleFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1ClusterRoleFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1ClusterRoleFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1ClusterRoleFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1ClusterRoleFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRules(int index, V1PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1PolicyRuleBuilder builder = new V1PolicyRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToRules(int index, V1PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1PolicyRuleBuilder builder = new V1PolicyRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(V1PolicyRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1PolicyRule item : items) {
            V1PolicyRuleBuilder builder = new V1PolicyRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<V1PolicyRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1PolicyRule item : items) {
            V1PolicyRuleBuilder builder = new V1PolicyRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(V1PolicyRule ... items) {
        for (V1PolicyRule item : items) {
            V1PolicyRuleBuilder builder = new V1PolicyRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<V1PolicyRule> items) {
        for (V1PolicyRule item : items) {
            V1PolicyRuleBuilder builder = new V1PolicyRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<V1PolicyRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<V1PolicyRuleBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            V1PolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1PolicyRule> getRules() {
        return this.rules != null ? V1ClusterRoleFluentImpl.build(this.rules) : null;
    }

    @Override
    public List<V1PolicyRule> buildRules() {
        return this.rules != null ? V1ClusterRoleFluentImpl.build(this.rules) : null;
    }

    @Override
    public V1PolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public V1PolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public V1PolicyRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public V1PolicyRule buildMatchingRule(Predicate<V1PolicyRuleBuilder> predicate) {
        for (V1PolicyRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<V1PolicyRuleBuilder> predicate) {
        for (V1PolicyRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<V1PolicyRule> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (V1PolicyRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(V1PolicyRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove("rules");
        }
        if (rules != null) {
            for (V1PolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public V1ClusterRoleFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public V1ClusterRoleFluent.RulesNested<A> addNewRuleLike(V1PolicyRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public V1ClusterRoleFluent.RulesNested<A> setNewRuleLike(int index, V1PolicyRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public V1ClusterRoleFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1ClusterRoleFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public V1ClusterRoleFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1ClusterRoleFluent.RulesNested<A> editMatchingRule(Predicate<V1PolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ClusterRoleFluentImpl that = (V1ClusterRoleFluentImpl)o;
        if (!Objects.equals(this.aggregationRule, that.aggregationRule)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.rules, that.rules);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aggregationRule, this.apiVersion, this.kind, this.metadata, this.rules, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aggregationRule != null) {
            sb.append("aggregationRule:");
            sb.append(this.aggregationRule + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.rules != null) {
            sb.append("rules:");
            sb.append(this.rules);
        }
        sb.append("}");
        return sb.toString();
    }

    class AggregationRuleNestedImpl<N>
    extends V1AggregationRuleFluentImpl<V1ClusterRoleFluent.AggregationRuleNested<N>>
    implements V1ClusterRoleFluent.AggregationRuleNested<N>,
    Nested<N> {
        V1AggregationRuleBuilder builder;

        AggregationRuleNestedImpl(V1AggregationRule item) {
            this.builder = new V1AggregationRuleBuilder(this, item);
        }

        AggregationRuleNestedImpl() {
            this.builder = new V1AggregationRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ClusterRoleFluentImpl.this.withAggregationRule(this.builder.build());
        }

        @Override
        public N endAggregationRule() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1ClusterRoleFluent.MetadataNested<N>>
    implements V1ClusterRoleFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ClusterRoleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class RulesNestedImpl<N>
    extends V1PolicyRuleFluentImpl<V1ClusterRoleFluent.RulesNested<N>>
    implements V1ClusterRoleFluent.RulesNested<N>,
    Nested<N> {
        V1PolicyRuleBuilder builder;
        int index;

        RulesNestedImpl(int index, V1PolicyRule item) {
            this.index = index;
            this.builder = new V1PolicyRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new V1PolicyRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ClusterRoleFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }
}

