/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import io.fabric8.kubernetes.api.model.PodTemplate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.k8s.overlord.execution.PodTemplateSelectStrategy;
import org.apache.druid.k8s.overlord.execution.Selector;
import org.apache.druid.k8s.overlord.taskadapter.PodTemplateWithName;

public class SelectorBasedPodTemplateSelectStrategy
implements PodTemplateSelectStrategy {
    private final List<Selector> selectors;

    @JsonCreator
    public SelectorBasedPodTemplateSelectStrategy(@JsonProperty(value="selectors") List<Selector> selectors) {
        Preconditions.checkNotNull(selectors, (Object)"selectors");
        this.selectors = selectors;
    }

    @Override
    public PodTemplateWithName getPodTemplateForTask(Task task, Map<String, Supplier<PodTemplate>> templates) {
        String templateKey = this.selectors.stream().filter(selector -> selector.evaluate(task)).findFirst().map(Selector::getSelectionKey).orElse("base");
        if (!templates.containsKey(templateKey)) {
            templateKey = "base";
        }
        Supplier<PodTemplate> podTemplateSupplier = templates.get(templateKey);
        return new PodTemplateWithName(templateKey, (PodTemplate)podTemplateSupplier.get());
    }

    @JsonProperty
    public List<Selector> getSelectors() {
        return this.selectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorBasedPodTemplateSelectStrategy that = (SelectorBasedPodTemplateSelectStrategy)o;
        return Objects.equals(this.selectors, that.selectors);
    }

    public int hashCode() {
        return Objects.hash(this.selectors);
    }

    public String toString() {
        return "SelectorBasedPodTemplateSelectStrategy{selectors=" + this.selectors + "}";
    }
}

