/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchMergeBufferAggregatorHelper;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class KllFloatsSketchMergeVectorAggregator
implements VectorAggregator {
    private final VectorObjectSelector selector;
    private final KllFloatsSketchMergeBufferAggregatorHelper helper;

    public KllFloatsSketchMergeVectorAggregator(VectorObjectSelector selector, int k, int maxIntermediateSize) {
        this.selector = selector;
        this.helper = new KllFloatsSketchMergeBufferAggregatorHelper(k, maxIntermediateSize);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        Object[] vector = this.selector.getObjectVector();
        KllFloatsSketch union = (KllFloatsSketch)this.helper.getSketchAtPosition(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            KllFloatsSketch sketch = (KllFloatsSketch)vector[i];
            if (sketch == null) continue;
            union.merge((KllSketch)sketch);
        }
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        Object[] vector = this.selector.getObjectVector();
        for (int i = 0; i < numRows; ++i) {
            KllFloatsSketch sketch = (KllFloatsSketch)vector[rows != null ? rows[i] : i];
            if (sketch == null) continue;
            int position = positions[i] + positionOffset;
            KllFloatsSketch union = (KllFloatsSketch)this.helper.getSketchAtPosition(buf, position);
            union.merge((KllSketch)sketch);
        }
    }

    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public void close() {
        this.helper.clear();
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.helper.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
    }
}

