/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.SaxHelper;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.outlet.OutletConfigurationXmlParser;
import org.apache.torque.generator.configuration.outlet.OutletSaxHandler;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.template.groovy.GroovyOutlet;
import org.apache.torque.generator.template.groovy.GroovyScriptOutlet;
import org.apache.torque.generator.template.groovy.GroovyTemplateOutlet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class GroovyOutletSaxHandler
extends OutletSaxHandler {
    public static final String GROOVY_SCRIPT_FILE_SUFFIX = ".groovy";

    public GroovyOutletSaxHandler(QualifiedName outletName, ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) throws SAXException {
        super(outletName, configurationProvider, unitDescriptor, configurationHandlers);
    }

    @Override
    protected GroovyOutlet createOutlet(QualifiedName outletName, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        String path = attributes.getValue("path");
        if (path == null) {
            throw new SAXException("The attribute path must be set on the element " + rawName + " for Groovy Outlets");
        }
        if (outletName == null) {
            String nameAttribute = attributes.getValue("name");
            outletName = nameAttribute != null ? new QualifiedName(nameAttribute) : OutletConfigurationXmlParser.getOutletNameForFilename(path);
        }
        String encoding = attributes.getValue("encoding");
        String template = attributes.getValue("template");
        try {
            Boolean variablesInContext;
            Boolean sourceElementAttributesInContext;
            boolean isScript = false;
            if ("true".equals(template)) {
                isScript = false;
            } else if ("false".equals(template)) {
                isScript = true;
            } else if (path.endsWith(GROOVY_SCRIPT_FILE_SUFFIX)) {
                isScript = true;
            }
            GroovyOutlet result = isScript ? new GroovyScriptOutlet(outletName, this.getConfigurationProvider(), path, encoding) : new GroovyTemplateOutlet(outletName, this.getConfigurationProvider(), path, encoding);
            Boolean optionsInContext = SaxHelper.getBooleanAttribute("optionsInBinding", attributes, "the groovyOutlet" + String.valueOf(outletName));
            if (optionsInContext != null) {
                result.setOptionsInBinding(optionsInContext);
            }
            if ((sourceElementAttributesInContext = SaxHelper.getBooleanAttribute("sourceAttributesInBinding", attributes, "the groovyOutlet" + String.valueOf(outletName))) != null) {
                result.setSourceAttributesInBinding(sourceElementAttributesInContext);
            }
            if ((variablesInContext = SaxHelper.getBooleanAttribute("variablesInBinding", attributes, "the groovyOutlet" + String.valueOf(outletName))) != null) {
                result.setVariablesInContext(variablesInContext);
            }
            return result;
        }
        catch (ConfigurationException e) {
            throw new SAXException(e);
        }
    }
}

