/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public class ReversedType<T>
extends AbstractType<T> {
    private static final Map<AbstractType<?>, ReversedType> instances = new ConcurrentHashMap();
    public final AbstractType<T> baseType;

    public static <T> ReversedType<T> getInstance(TypeParser parser) {
        List<AbstractType<?>> types = parser.getTypeParameters();
        if (types.size() != 1) {
            throw new ConfigurationException("ReversedType takes exactly one argument, " + types.size() + " given");
        }
        return ReversedType.getInstance(types.get(0));
    }

    public static <T> ReversedType<T> getInstance(AbstractType<T> baseType) {
        ReversedType t = instances.get(baseType);
        return null == t ? instances.computeIfAbsent(baseType, ReversedType::new) : t;
    }

    private ReversedType(AbstractType<T> baseType) {
        super(AbstractType.ComparisonType.CUSTOM);
        this.baseType = baseType;
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return this.baseType.isEmptyValueMeaningless();
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        ByteSource src = this.baseType.asComparableBytes(accessor, data, version);
        if (src == null) {
            return null;
        }
        return () -> {
            int v = src.next();
            if (v == -1) {
                return v;
            }
            return v ^ 0xFF;
        };
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        return this.baseType.fromComparableBytes(accessor, ReversedPeekableByteSource.of(comparableBytes), version);
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return this.baseType.compare(right, accessorR, left, accessorL);
    }

    @Override
    public int compareForCQL(ByteBuffer v1, ByteBuffer v2) {
        return this.baseType.compare(v1, v2);
    }

    @Override
    public <V> String getString(V value, ValueAccessor<V> accessor) {
        return this.baseType.getString(value, accessor);
    }

    @Override
    public ByteBuffer fromString(String source) {
        return this.baseType.fromString(source);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        return this.baseType.fromJSONObject(parsed);
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return this.baseType.toJSONString(buffer, protocolVersion);
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> otherType) {
        if (!(otherType instanceof ReversedType)) {
            return false;
        }
        return this.baseType.isCompatibleWith(((ReversedType)otherType).baseType);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return this.baseType.asCQL3Type();
    }

    @Override
    public TypeSerializer<T> getSerializer() {
        return this.baseType.getSerializer();
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return this.baseType.getArgumentDeserializer();
    }

    @Override
    public <V> boolean referencesUserType(V name, ValueAccessor<V> accessor) {
        return this.baseType.referencesUserType(name, accessor);
    }

    @Override
    public AbstractType<?> expandUserTypes() {
        return ReversedType.getInstance(this.baseType.expandUserTypes());
    }

    @Override
    public ReversedType<?> withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        instances.remove(this.baseType);
        return ReversedType.getInstance(this.baseType.withUpdatedUserType(udt));
    }

    @Override
    public int valueLengthIfFixed() {
        return this.baseType.valueLengthIfFixed();
    }

    @Override
    public boolean isReversed() {
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.baseType + ")";
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return this.baseType.getMaskedValue();
    }

    private static final class ReversedPeekableByteSource
    extends ByteSource.Peekable {
        private final ByteSource.Peekable original;

        static ByteSource.Peekable of(ByteSource.Peekable original) {
            return original != null ? new ReversedPeekableByteSource(original) : null;
        }

        private ReversedPeekableByteSource(ByteSource.Peekable original) {
            super(null);
            this.original = original;
        }

        @Override
        public int next() {
            int v = this.original.next();
            if (v != -1) {
                return v ^ 0xFF;
            }
            return -1;
        }

        @Override
        public int peek() {
            int v = this.original.peek();
            if (v != -1) {
                return v ^ 0xFF;
            }
            return -1;
        }
    }
}

