# $NetBSD: t_create.sh,v 1.5 2024/04/28 07:27:42 rillig Exp $
#
# Copyright (c) 2012 The NetBSD Foundation, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
# ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

atf_test_case validfat32
validfat32_head() {
	atf_set "descr" "Verifies that fat32 created filesystems are valid"
}
validfat32_body() {

	AVAIL=$( df -m ${TMPDIR} | awk '{if (int($4) > 0) print $4}' )
	if [ $AVAIL -lt 34 ]; then
		atf_skip "not enough free space in working directory"
	fi

	atf_check -s exit:0 -o ignore -e ignore \
	    newfs_msdos -b 512 -C 33m -F 32 msdos.img
#	fsck_msdos/newfs_msdos have been fixed
#	atf_expect_fail "PR bin/46743"
	atf_check -s exit:0 -o not-match:FIXED -e empty fsck_msdos -p msdos.img
	atf_expect_pass
}


atf_init_test_cases() {
	atf_add_test_case validfat32
}
