/*	$NetBSD: r8a779g0-sysc.h,v 1.1.1.1 2026/01/18 05:21:54 skrll Exp $	*/

/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright (C) 2022 Renesas Electronics Corp.
 */
#ifndef __DT_BINDINGS_POWER_R8A779G0_SYSC_H__
#define __DT_BINDINGS_POWER_R8A779G0_SYSC_H__

/*
 * These power domain indices match the Power Domain Register Numbers (PDR)
 */

#define R8A779G0_PD_A1E0D0C0		0
#define R8A779G0_PD_A1E0D0C1		1
#define R8A779G0_PD_A1E0D1C0		2
#define R8A779G0_PD_A1E0D1C1		3
#define R8A779G0_PD_A2E0D0		16
#define R8A779G0_PD_A2E0D1		17
#define R8A779G0_PD_A3E0		20
#define R8A779G0_PD_A33DGA		24
#define R8A779G0_PD_A23DGB		25
#define R8A779G0_PD_A1DSP0		33
#define R8A779G0_PD_A2IMP01		34
#define R8A779G0_PD_A2PSC		35
#define R8A779G0_PD_A2CV0		36
#define R8A779G0_PD_A2CV1		37
#define R8A779G0_PD_A1CNN0		41
#define R8A779G0_PD_A2CN0		42
#define R8A779G0_PD_A3IR		43
#define R8A779G0_PD_A1DSP1		45
#define R8A779G0_PD_A2IMP23		46
#define R8A779G0_PD_A2DMA		47
#define R8A779G0_PD_A2CV2		48
#define R8A779G0_PD_A2CV3		49
#define R8A779G0_PD_A1DSP2		53
#define R8A779G0_PD_A1DSP3		54
#define R8A779G0_PD_A3VIP0		56
#define R8A779G0_PD_A3VIP1		57
#define R8A779G0_PD_A3VIP2		58
#define R8A779G0_PD_A3ISP0		60
#define R8A779G0_PD_A3ISP1		61
#define R8A779G0_PD_A3DUL		62

/* Always-on power area */
#define R8A779G0_PD_ALWAYS_ON		64

#endif /* __DT_BINDINGS_POWER_R8A779G0_SYSC_H__*/
