/*	$NetBSD: qcom,sdm670-rpmh.h,v 1.1.1.1 2026/01/18 05:21:46 skrll Exp $	*/

/* SPDX-License-Identifier: GPL-2.0-only OR BSD-2-Clause */
/*
 * Qualcomm SDM670 interconnect IDs
 *
 * Copyright (c) 2022, The Linux Foundation. All rights reserved.
 */

#ifndef __DT_BINDINGS_INTERCONNECT_QCOM_SDM670_H
#define __DT_BINDINGS_INTERCONNECT_QCOM_SDM670_H

#define MASTER_A1NOC_CFG		0
#define MASTER_BLSP_1			1
#define MASTER_TSIF			2
#define MASTER_EMMC			3
#define MASTER_SDCC_2			4
#define MASTER_SDCC_4			5
#define MASTER_UFS_MEM			6
#define SLAVE_A1NOC_SNOC		7
#define SLAVE_SERVICE_A1NOC		8

#define MASTER_A2NOC_CFG		0
#define MASTER_QDSS_BAM			1
#define MASTER_BLSP_2			2
#define MASTER_CNOC_A2NOC		3
#define MASTER_CRYPTO_CORE_0		4
#define MASTER_IPA			5
#define MASTER_QDSS_ETR			6
#define MASTER_USB3			7
#define SLAVE_A2NOC_SNOC		8
#define SLAVE_SERVICE_A2NOC		9


#define MASTER_SPDM			0
#define MASTER_SNOC_CNOC		1
#define SLAVE_A1NOC_CFG			2
#define SLAVE_A2NOC_CFG			3
#define SLAVE_AOP			4
#define SLAVE_AOSS			5
#define SLAVE_CAMERA_CFG		6
#define SLAVE_CLK_CTL			7
#define SLAVE_CDSP_CFG			8
#define SLAVE_RBCPR_CX_CFG		9
#define SLAVE_CRYPTO_0_CFG		10
#define SLAVE_DCC_CFG			11
#define SLAVE_CNOC_DDRSS		12
#define SLAVE_DISPLAY_CFG		13
#define SLAVE_EMMC_CFG			14
#define SLAVE_GLM			15
#define SLAVE_GRAPHICS_3D_CFG		16
#define SLAVE_IMEM_CFG			17
#define SLAVE_IPA_CFG			18
#define SLAVE_CNOC_MNOC_CFG		19
#define SLAVE_PDM			20
#define SLAVE_SOUTH_PHY_CFG		21
#define SLAVE_PIMEM_CFG			22
#define SLAVE_PRNG			23
#define SLAVE_QDSS_CFG			24
#define SLAVE_BLSP_2			25
#define SLAVE_BLSP_1			26
#define SLAVE_SDCC_2			27
#define SLAVE_SDCC_4			28
#define SLAVE_SNOC_CFG			29
#define SLAVE_SPDM_WRAPPER		30
#define SLAVE_TCSR			31
#define SLAVE_TLMM_NORTH		32
#define SLAVE_TLMM_SOUTH		33
#define SLAVE_TSIF			34
#define SLAVE_UFS_MEM_CFG		35
#define SLAVE_USB3			36
#define SLAVE_VENUS_CFG			37
#define SLAVE_VSENSE_CTRL_CFG		38
#define SLAVE_CNOC_A2NOC		39
#define SLAVE_SERVICE_CNOC		40

#define MASTER_CNOC_DC_NOC		0
#define SLAVE_LLCC_CFG			1
#define SLAVE_MEM_NOC_CFG		2

#define MASTER_AMPSS_M0			0
#define MASTER_GNOC_CFG			1
#define SLAVE_GNOC_SNOC			2
#define SLAVE_GNOC_MEM_NOC		3
#define SLAVE_SERVICE_GNOC		4

#define MASTER_TCU_0			0
#define MASTER_MEM_NOC_CFG		1
#define MASTER_GNOC_MEM_NOC		2
#define MASTER_MNOC_HF_MEM_NOC		3
#define MASTER_MNOC_SF_MEM_NOC		4
#define MASTER_SNOC_GC_MEM_NOC		5
#define MASTER_SNOC_SF_MEM_NOC		6
#define MASTER_GRAPHICS_3D		7
#define SLAVE_MSS_PROC_MS_MPU_CFG	8
#define SLAVE_MEM_NOC_GNOC		9
#define SLAVE_LLCC			10
#define SLAVE_MEM_NOC_SNOC		11
#define SLAVE_SERVICE_MEM_NOC		12
#define MASTER_LLCC			13
#define SLAVE_EBI_CH0			14

#define MASTER_CNOC_MNOC_CFG		0
#define MASTER_CAMNOC_HF0		1
#define MASTER_CAMNOC_HF1		2
#define MASTER_CAMNOC_SF		3
#define MASTER_MDP_PORT0		4
#define MASTER_MDP_PORT1		5
#define MASTER_ROTATOR			6
#define MASTER_VIDEO_P0			7
#define MASTER_VIDEO_P1			8
#define MASTER_VIDEO_PROC		9
#define SLAVE_MNOC_SF_MEM_NOC		10
#define SLAVE_MNOC_HF_MEM_NOC		11
#define SLAVE_SERVICE_MNOC		12

#define MASTER_SNOC_CFG			0
#define MASTER_A1NOC_SNOC		1
#define MASTER_A2NOC_SNOC		2
#define MASTER_GNOC_SNOC		3
#define MASTER_MEM_NOC_SNOC		4
#define MASTER_PIMEM			5
#define MASTER_GIC			6
#define SLAVE_APPSS			7
#define SLAVE_SNOC_CNOC			8
#define SLAVE_SNOC_MEM_NOC_GC		9
#define SLAVE_SNOC_MEM_NOC_SF		10
#define SLAVE_OCIMEM			11
#define SLAVE_PIMEM			12
#define SLAVE_SERVICE_SNOC		13
#define SLAVE_QDSS_STM			14
#define SLAVE_TCU			15
#define MASTER_CAMNOC_HF0_UNCOMP	16
#define MASTER_CAMNOC_HF1_UNCOMP	17
#define MASTER_CAMNOC_SF_UNCOMP		18
#define SLAVE_CAMNOC_UNCOMP		19

#endif
