/*	$NetBSD: qcom,msm8996.h,v 1.1.1.1 2026/01/18 05:21:45 skrll Exp $	*/

/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-3-Clause) */
/*
 * Qualcomm MSM8996 interconnect IDs
 *
 * Copyright (c) 2021 Yassine Oudjana <y.oudjana@protonmail.com>
 */

#ifndef __DT_BINDINGS_INTERCONNECT_QCOM_MSM8996_H
#define __DT_BINDINGS_INTERCONNECT_QCOM_MSM8996_H

/* A0NOC */
#define MASTER_PCIE_0			0
#define MASTER_PCIE_1			1
#define MASTER_PCIE_2			2

/* A1NOC */
#define MASTER_CNOC_A1NOC		0
#define MASTER_CRYPTO_CORE0		1
#define MASTER_PNOC_A1NOC		2

/* A2NOC */
#define MASTER_USB3			0
#define MASTER_IPA			1
#define MASTER_UFS			2

/* BIMC */
#define MASTER_AMPSS_M0			0
#define MASTER_GRAPHICS_3D		1
#define MASTER_MNOC_BIMC		2
#define MASTER_SNOC_BIMC		3
#define SLAVE_EBI_CH0			4
#define SLAVE_HMSS_L3			5
#define SLAVE_BIMC_SNOC_0		6
#define SLAVE_BIMC_SNOC_1		7

/* CNOC */
#define MASTER_SNOC_CNOC		0
#define MASTER_QDSS_DAP			1
#define SLAVE_CNOC_A1NOC		2
#define SLAVE_CLK_CTL			3
#define SLAVE_TCSR			4
#define SLAVE_TLMM			5
#define SLAVE_CRYPTO_0_CFG		6
#define SLAVE_MPM			7
#define SLAVE_PIMEM_CFG			8
#define SLAVE_IMEM_CFG			9
#define SLAVE_MESSAGE_RAM		10
#define SLAVE_BIMC_CFG			11
#define SLAVE_PMIC_ARB			12
#define SLAVE_PRNG			13
#define SLAVE_DCC_CFG			14
#define SLAVE_RBCPR_MX			15
#define SLAVE_QDSS_CFG			16
#define SLAVE_RBCPR_CX			17
#define SLAVE_QDSS_RBCPR_APU		18
#define SLAVE_CNOC_MNOC_CFG		19
#define SLAVE_SNOC_CFG			20
#define SLAVE_SNOC_MPU_CFG		21
#define SLAVE_EBI1_PHY_CFG		22
#define SLAVE_A0NOC_CFG			23
#define SLAVE_PCIE_1_CFG		24
#define SLAVE_PCIE_2_CFG		25
#define SLAVE_PCIE_0_CFG		26
#define SLAVE_PCIE20_AHB2PHY		27
#define SLAVE_A0NOC_MPU_CFG		28
#define SLAVE_UFS_CFG			29
#define SLAVE_A1NOC_CFG			30
#define SLAVE_A1NOC_MPU_CFG		31
#define SLAVE_A2NOC_CFG			32
#define SLAVE_A2NOC_MPU_CFG		33
#define SLAVE_SSC_CFG			34
#define SLAVE_A0NOC_SMMU_CFG		35
#define SLAVE_A1NOC_SMMU_CFG		36
#define SLAVE_A2NOC_SMMU_CFG		37
#define SLAVE_LPASS_SMMU_CFG		38
#define SLAVE_CNOC_MNOC_MMSS_CFG	39

/* MNOC */
#define MASTER_CNOC_MNOC_CFG		0
#define MASTER_CPP			1
#define MASTER_JPEG			2
#define MASTER_MDP_PORT0		3
#define MASTER_MDP_PORT1		4
#define MASTER_ROTATOR			5
#define MASTER_VIDEO_P0			6
#define MASTER_VFE			7
#define MASTER_SNOC_VMEM		8
#define MASTER_VIDEO_P0_OCMEM		9
#define MASTER_CNOC_MNOC_MMSS_CFG	10
#define SLAVE_MNOC_BIMC			11
#define SLAVE_VMEM			12
#define SLAVE_SERVICE_MNOC		13
#define SLAVE_MMAGIC_CFG		14
#define SLAVE_CPR_CFG			15
#define SLAVE_MISC_CFG			16
#define SLAVE_VENUS_THROTTLE_CFG	17
#define SLAVE_VENUS_CFG			18
#define SLAVE_VMEM_CFG			19
#define SLAVE_DSA_CFG			20
#define SLAVE_MMSS_CLK_CFG		21
#define SLAVE_DSA_MPU_CFG		22
#define SLAVE_MNOC_MPU_CFG		23
#define SLAVE_DISPLAY_CFG		24
#define SLAVE_DISPLAY_THROTTLE_CFG	25
#define SLAVE_CAMERA_CFG		26
#define SLAVE_CAMERA_THROTTLE_CFG	27
#define SLAVE_GRAPHICS_3D_CFG		28
#define SLAVE_SMMU_MDP_CFG		29
#define SLAVE_SMMU_ROT_CFG		30
#define SLAVE_SMMU_VENUS_CFG		31
#define SLAVE_SMMU_CPP_CFG		32
#define SLAVE_SMMU_JPEG_CFG		33
#define SLAVE_SMMU_VFE_CFG		34

/* PNOC */
#define MASTER_SNOC_PNOC		0
#define MASTER_SDCC_1			1
#define MASTER_SDCC_2			2
#define MASTER_SDCC_4			3
#define MASTER_USB_HS			4
#define MASTER_BLSP_1			5
#define MASTER_BLSP_2			6
#define MASTER_TSIF			7
#define SLAVE_PNOC_A1NOC		8
#define SLAVE_USB_HS			9
#define SLAVE_SDCC_2			10
#define SLAVE_SDCC_4			11
#define SLAVE_TSIF			12
#define SLAVE_BLSP_2			13
#define SLAVE_SDCC_1			14
#define SLAVE_BLSP_1			15
#define SLAVE_PDM			16
#define SLAVE_AHB2PHY			17

/* SNOC */
#define MASTER_HMSS			0
#define MASTER_QDSS_BAM			1
#define MASTER_SNOC_CFG			2
#define MASTER_BIMC_SNOC_0		3
#define MASTER_BIMC_SNOC_1		4
#define MASTER_A0NOC_SNOC		5
#define MASTER_A1NOC_SNOC		6
#define MASTER_A2NOC_SNOC		7
#define MASTER_QDSS_ETR			8
#define SLAVE_A0NOC_SNOC		9
#define SLAVE_A1NOC_SNOC		10
#define SLAVE_A2NOC_SNOC		11
#define SLAVE_HMSS			12
#define SLAVE_LPASS			13
#define SLAVE_USB3			14
#define SLAVE_SNOC_BIMC			15
#define SLAVE_SNOC_CNOC			16
#define SLAVE_IMEM			17
#define SLAVE_PIMEM			18
#define SLAVE_SNOC_VMEM			19
#define SLAVE_SNOC_PNOC			20
#define SLAVE_QDSS_STM			21
#define SLAVE_PCIE_0			22
#define SLAVE_PCIE_1			23
#define SLAVE_PCIE_2			24
#define SLAVE_SERVICE_SNOC		25

#endif
