/*	$NetBSD: fsl,imx8mp.h,v 1.1.1.1 2026/01/18 05:21:45 skrll Exp $	*/

/* SPDX-License-Identifier: GPL-2.0 OR MIT */
/*
 * Interconnect framework driver for i.MX SoC
 *
 * Copyright 2022 NXP
 * Peng Fan <peng.fan@nxp.com>
 */

#ifndef __DT_BINDINGS_INTERCONNECT_IMX8MP_H
#define __DT_BINDINGS_INTERCONNECT_IMX8MP_H

#define IMX8MP_ICN_NOC		0
#define IMX8MP_ICN_MAIN		1
#define IMX8MP_ICS_DRAM		2
#define IMX8MP_ICS_OCRAM	3
#define IMX8MP_ICM_A53		4
#define IMX8MP_ICM_SUPERMIX	5
#define IMX8MP_ICM_GIC		6
#define IMX8MP_ICM_MLMIX	7

#define IMX8MP_ICN_AUDIO	8
#define IMX8MP_ICM_DSP		9
#define IMX8MP_ICM_SDMA2PER	10
#define IMX8MP_ICM_SDMA2BURST	11
#define IMX8MP_ICM_SDMA3PER	12
#define IMX8MP_ICM_SDMA3BURST	13
#define IMX8MP_ICM_EDMA		14

#define IMX8MP_ICN_GPU		15
#define IMX8MP_ICM_GPU2D	16
#define IMX8MP_ICM_GPU3D	17

#define IMX8MP_ICN_HDMI		18
#define IMX8MP_ICM_HRV		19
#define IMX8MP_ICM_LCDIF_HDMI	20
#define IMX8MP_ICM_HDCP		21

#define IMX8MP_ICN_HSIO		22
#define IMX8MP_ICM_NOC_PCIE	23
#define IMX8MP_ICM_USB1		24
#define IMX8MP_ICM_USB2		25
#define IMX8MP_ICM_PCIE		26

#define IMX8MP_ICN_MEDIA	27
#define IMX8MP_ICM_LCDIF_RD	28
#define IMX8MP_ICM_LCDIF_WR	29
#define IMX8MP_ICM_ISI0		30
#define IMX8MP_ICM_ISI1		31
#define IMX8MP_ICM_ISI2		32
#define IMX8MP_ICM_ISP0		33
#define IMX8MP_ICM_ISP1		34
#define IMX8MP_ICM_DWE		35

#define IMX8MP_ICN_VIDEO	36
#define IMX8MP_ICM_VPU_G1	37
#define IMX8MP_ICM_VPU_G2	38
#define IMX8MP_ICM_VPU_H1	39

#endif /* __DT_BINDINGS_INTERCONNECT_IMX8MP_H */
