/*	$NetBSD: cros-ec-keyboard.h,v 1.1.1.2 2026/01/18 05:21:44 skrll Exp $	*/

/* SPDX-License-Identifier: GPL-2.0 */
/*
 * This header provides the constants of the standard Chrome OS key matrix
 * for cros-ec keyboard-controller bindings.
 *
 * Copyright (c) 2021 Google, Inc
 */

#ifndef _CROS_EC_KEYBOARD_H
#define _CROS_EC_KEYBOARD_H

#define CROS_STD_TOP_ROW_KEYMAP	\
	MATRIX_KEY(0x00, 0x02, KEY_F1)	\
	MATRIX_KEY(0x03, 0x02, KEY_F2)	\
	MATRIX_KEY(0x02, 0x02, KEY_F3)	\
	MATRIX_KEY(0x01, 0x02, KEY_F4)	\
	MATRIX_KEY(0x03, 0x04, KEY_F5)	\
	MATRIX_KEY(0x02, 0x04, KEY_F6)	\
	MATRIX_KEY(0x01, 0x04, KEY_F7)	\
	MATRIX_KEY(0x02, 0x09, KEY_F8)	\
	MATRIX_KEY(0x01, 0x09, KEY_F9)	\
	MATRIX_KEY(0x00, 0x04, KEY_F10)

#define CROS_STD_MAIN_KEYMAP	\
	MATRIX_KEY(0x00, 0x01, KEY_LEFTMETA)	\
	MATRIX_KEY(0x00, 0x03, KEY_B)		\
	MATRIX_KEY(0x00, 0x05, KEY_RO)		\
	MATRIX_KEY(0x00, 0x06, KEY_N)		\
	MATRIX_KEY(0x00, 0x08, KEY_EQUAL)	\
	MATRIX_KEY(0x00, 0x0a, KEY_RIGHTALT)	\
	MATRIX_KEY(0x01, 0x01, KEY_ESC)		\
	MATRIX_KEY(0x01, 0x03, KEY_G)		\
	MATRIX_KEY(0x01, 0x06, KEY_H)		\
	MATRIX_KEY(0x01, 0x08, KEY_APOSTROPHE)	\
	MATRIX_KEY(0x01, 0x0b, KEY_BACKSPACE)	\
	MATRIX_KEY(0x01, 0x0c, KEY_HENKAN)	\
						\
	MATRIX_KEY(0x02, 0x00, KEY_LEFTCTRL)	\
	MATRIX_KEY(0x02, 0x01, KEY_TAB)		\
	MATRIX_KEY(0x02, 0x03, KEY_T)		\
	MATRIX_KEY(0x02, 0x05, KEY_RIGHTBRACE)	\
	MATRIX_KEY(0x02, 0x06, KEY_Y)		\
	MATRIX_KEY(0x02, 0x07, KEY_102ND)	\
	MATRIX_KEY(0x02, 0x08, KEY_LEFTBRACE)	\
	MATRIX_KEY(0x02, 0x0a, KEY_YEN)		\
						\
	MATRIX_KEY(0x03, 0x00, KEY_LEFTMETA)	\
	MATRIX_KEY(0x03, 0x01, KEY_GRAVE)	\
	MATRIX_KEY(0x03, 0x03, KEY_5)		\
	MATRIX_KEY(0x03, 0x06, KEY_6)		\
	MATRIX_KEY(0x03, 0x08, KEY_MINUS)	\
	MATRIX_KEY(0x03, 0x09, KEY_SLEEP)	\
	MATRIX_KEY(0x03, 0x0b, KEY_BACKSLASH)	\
	MATRIX_KEY(0x03, 0x0c, KEY_MUHENKAN)	\
						\
	MATRIX_KEY(0x04, 0x00, KEY_RIGHTCTRL)	\
	MATRIX_KEY(0x04, 0x01, KEY_A)		\
	MATRIX_KEY(0x04, 0x02, KEY_D)		\
	MATRIX_KEY(0x04, 0x03, KEY_F)		\
	MATRIX_KEY(0x04, 0x04, KEY_S)		\
	MATRIX_KEY(0x04, 0x05, KEY_K)		\
	MATRIX_KEY(0x04, 0x06, KEY_J)		\
	MATRIX_KEY(0x04, 0x08, KEY_SEMICOLON)	\
	MATRIX_KEY(0x04, 0x09, KEY_L)		\
	MATRIX_KEY(0x04, 0x0a, KEY_BACKSLASH)	\
	MATRIX_KEY(0x04, 0x0b, KEY_ENTER)	\
						\
	MATRIX_KEY(0x05, 0x01, KEY_Z)		\
	MATRIX_KEY(0x05, 0x02, KEY_C)		\
	MATRIX_KEY(0x05, 0x03, KEY_V)		\
	MATRIX_KEY(0x05, 0x04, KEY_X)		\
	MATRIX_KEY(0x05, 0x05, KEY_COMMA)	\
	MATRIX_KEY(0x05, 0x06, KEY_M)		\
	MATRIX_KEY(0x05, 0x07, KEY_LEFTSHIFT)	\
	MATRIX_KEY(0x05, 0x08, KEY_SLASH)	\
	MATRIX_KEY(0x05, 0x09, KEY_DOT)		\
	MATRIX_KEY(0x05, 0x0b, KEY_SPACE)	\
						\
	MATRIX_KEY(0x06, 0x01, KEY_1)		\
	MATRIX_KEY(0x06, 0x02, KEY_3)		\
	MATRIX_KEY(0x06, 0x03, KEY_4)		\
	MATRIX_KEY(0x06, 0x04, KEY_2)		\
	MATRIX_KEY(0x06, 0x05, KEY_8)		\
	MATRIX_KEY(0x06, 0x06, KEY_7)		\
	MATRIX_KEY(0x06, 0x08, KEY_0)		\
	MATRIX_KEY(0x06, 0x09, KEY_9)		\
	MATRIX_KEY(0x06, 0x0a, KEY_LEFTALT)	\
	MATRIX_KEY(0x06, 0x0b, KEY_DOWN)	\
	MATRIX_KEY(0x06, 0x0c, KEY_RIGHT)	\
						\
	MATRIX_KEY(0x07, 0x01, KEY_Q)		\
	MATRIX_KEY(0x07, 0x02, KEY_E)		\
	MATRIX_KEY(0x07, 0x03, KEY_R)		\
	MATRIX_KEY(0x07, 0x04, KEY_W)		\
	MATRIX_KEY(0x07, 0x05, KEY_I)		\
	MATRIX_KEY(0x07, 0x06, KEY_U)		\
	MATRIX_KEY(0x07, 0x07, KEY_RIGHTSHIFT)	\
	MATRIX_KEY(0x07, 0x08, KEY_P)		\
	MATRIX_KEY(0x07, 0x09, KEY_O)		\
	MATRIX_KEY(0x07, 0x0b, KEY_UP)		\
	MATRIX_KEY(0x07, 0x0c, KEY_LEFT)

/* No numpad */
#define CROS_TOP_ROW_KEYMAP_V30 \
	MATRIX_KEY(0x00, 0x01, KEY_F11)		/* T11 */	\
	MATRIX_KEY(0x00, 0x02, KEY_F1)		/* T1 */	\
	MATRIX_KEY(0x00, 0x04, KEY_F10)		/* T10 */	\
	MATRIX_KEY(0x00, 0x0b, KEY_F14)		/* T14 */	\
	MATRIX_KEY(0x00, 0x0c, KEY_F15)		/* T15 */	\
	MATRIX_KEY(0x01, 0x02, KEY_F4)		/* T4 */	\
	MATRIX_KEY(0x01, 0x04, KEY_F7)		/* T7 */	\
	MATRIX_KEY(0x01, 0x05, KEY_F12)		/* T12 */	\
	MATRIX_KEY(0x01, 0x09, KEY_F9)		/* T9 */	\
	MATRIX_KEY(0x02, 0x02, KEY_F3)		/* T3 */	\
	MATRIX_KEY(0x02, 0x04, KEY_F6)		/* T6 */	\
	MATRIX_KEY(0x02, 0x0b, KEY_F8)		/* T8 */	\
	MATRIX_KEY(0x03, 0x02, KEY_F2)		/* T2 */	\
	MATRIX_KEY(0x03, 0x05, KEY_F13)		/* T13 */	\
	MATRIX_KEY(0x04, 0x04, KEY_F5)		/* T5 */

#define CROS_MAIN_KEYMAP_V30			/* Keycode */	\
	MATRIX_KEY(0x00, 0x03, KEY_B)		/* 50 */	\
	MATRIX_KEY(0x00, 0x05, KEY_N)		/* 51 */	\
	MATRIX_KEY(0x00, 0x06, KEY_RO)		/* 56 (JIS) */	\
	MATRIX_KEY(0x00, 0x08, KEY_EQUAL)	/* 13 */	\
	MATRIX_KEY(0x00, 0x09, KEY_HOME)	/* 80 (Numpad) */	\
	MATRIX_KEY(0x00, 0x0a, KEY_RIGHTALT)	/* 62 */	\
	MATRIX_KEY(0x00, 0x10, KEY_FN)		/* 127 */	\
								\
	MATRIX_KEY(0x01, 0x01, KEY_ESC)		/* 110 */	\
	MATRIX_KEY(0x01, 0x03, KEY_G)		/* 35 */	\
	MATRIX_KEY(0x01, 0x06, KEY_H)		/* 36 */	\
	MATRIX_KEY(0x01, 0x08, KEY_APOSTROPHE)	/* 41 */	\
	MATRIX_KEY(0x01, 0x0b, KEY_BACKSPACE)	/* 15 */	\
	MATRIX_KEY(0x01, 0x0c, KEY_HENKAN)	/* 65 (JIS) */	\
	MATRIX_KEY(0x01, 0x0e, KEY_LEFTCTRL)	/* 58 */	\
								\
	MATRIX_KEY(0x02, 0x01, KEY_TAB)		/* 16 */	\
	MATRIX_KEY(0x02, 0x03, KEY_T)		/* 21 */	\
	MATRIX_KEY(0x02, 0x05, KEY_RIGHTBRACE)	/* 28 */	\
	MATRIX_KEY(0x02, 0x06, KEY_Y)		/* 22 */	\
	MATRIX_KEY(0x02, 0x08, KEY_LEFTBRACE)	/* 27 */	\
	MATRIX_KEY(0x02, 0x09, KEY_DELETE)	/* 76 (Numpad) */	\
	MATRIX_KEY(0x02, 0x0c, KEY_PAGEUP)	/* 85 (Numpad) */	\
	MATRIX_KEY(0x02, 0x011, KEY_YEN)	/* 14 (JIS) */	\
								\
	MATRIX_KEY(0x03, 0x00, KEY_LEFTMETA)	/* Launcher */	\
	MATRIX_KEY(0x03, 0x01, KEY_GRAVE)	/* 1 */	\
	MATRIX_KEY(0x03, 0x03, KEY_5)		/* 6 */	\
	MATRIX_KEY(0x03, 0x04, KEY_S)		/* 32 */	\
	MATRIX_KEY(0x03, 0x06, KEY_MINUS)	/* 12 */	\
	MATRIX_KEY(0x03, 0x08, KEY_6)		/* 7 */		\
	MATRIX_KEY(0x03, 0x09, KEY_SLEEP)	/* Lock */	\
	MATRIX_KEY(0x03, 0x0b, KEY_BACKSLASH)	/* 29 */	\
	MATRIX_KEY(0x03, 0x0c, KEY_MUHENKAN)	/* 63 (JIS) */	\
	MATRIX_KEY(0x03, 0x0e, KEY_RIGHTCTRL)	/* 64 */	\
								\
	MATRIX_KEY(0x04, 0x01, KEY_A)		/* 31 */	\
	MATRIX_KEY(0x04, 0x02, KEY_D)		/* 33 */	\
	MATRIX_KEY(0x04, 0x03, KEY_F)		/* 34 */	\
	MATRIX_KEY(0x04, 0x05, KEY_K)		/* 38 */	\
	MATRIX_KEY(0x04, 0x06, KEY_J)		/* 37 */	\
	MATRIX_KEY(0x04, 0x08, KEY_SEMICOLON)	/* 40 */	\
	MATRIX_KEY(0x04, 0x09, KEY_L)		/* 39 */	\
	MATRIX_KEY(0x04, 0x0b, KEY_ENTER)	/* 43 */	\
	MATRIX_KEY(0x04, 0x0c, KEY_END)		/* 81 (Numpad) */	\
								\
	MATRIX_KEY(0x05, 0x01, KEY_1)		/* 2 */	\
	MATRIX_KEY(0x05, 0x02, KEY_COMMA)	/* 53 */	\
	MATRIX_KEY(0x05, 0x03, KEY_DOT)		/* 54 */	\
	MATRIX_KEY(0x05, 0x04, KEY_SLASH)	/* 55 */	\
	MATRIX_KEY(0x05, 0x05, KEY_C)		/* 48 */	\
	MATRIX_KEY(0x05, 0x06, KEY_SPACE)	/* 61 */	\
	MATRIX_KEY(0x05, 0x07, KEY_LEFTSHIFT)	/* 44 */	\
	MATRIX_KEY(0x05, 0x08, KEY_X)		/* 47 */	\
	MATRIX_KEY(0x05, 0x09, KEY_V)		/* 49 */	\
	MATRIX_KEY(0x05, 0x0b, KEY_M)		/* 52 */	\
	MATRIX_KEY(0x05, 0x0c, KEY_PAGEDOWN)	/* 86 (Numpad) */	\
								\
	MATRIX_KEY(0x06, 0x01, KEY_Z)		/* 46 */	\
	MATRIX_KEY(0x06, 0x02, KEY_3)		/* 4 */		\
	MATRIX_KEY(0x06, 0x03, KEY_4)		/* 5 */		\
	MATRIX_KEY(0x06, 0x04, KEY_2)		/* 3 */		\
	MATRIX_KEY(0x06, 0x05, KEY_8)		/* 9 */		\
	MATRIX_KEY(0x06, 0x06, KEY_0)		/* 11 */	\
	MATRIX_KEY(0x06, 0x08, KEY_7)		/* 8 */		\
	MATRIX_KEY(0x06, 0x09, KEY_9)		/* 10 */	\
	MATRIX_KEY(0x06, 0x0b, KEY_DOWN)	/* 84 */	\
	MATRIX_KEY(0x06, 0x0c, KEY_RIGHT)	/* 89 */	\
	MATRIX_KEY(0x06, 0x0d, KEY_LEFTALT)	/* 60 */	\
	MATRIX_KEY(0x06, 0x0f, KEY_ASSISTANT)	/* 128 */	\
	MATRIX_KEY(0x06, 0x11, KEY_BACKSLASH)	/* 42 (JIS, ISO) */	\
								\
	MATRIX_KEY(0x07, 0x01, KEY_U)		/* 23 */	\
	MATRIX_KEY(0x07, 0x02, KEY_I)		/* 24 */	\
	MATRIX_KEY(0x07, 0x03, KEY_O)		/* 25 */	\
	MATRIX_KEY(0x07, 0x04, KEY_P)		/* 26 */	\
	MATRIX_KEY(0x07, 0x05, KEY_Q)		/* 17 */	\
	MATRIX_KEY(0x07, 0x06, KEY_W)		/* 18 */	\
	MATRIX_KEY(0x07, 0x07, KEY_RIGHTSHIFT)	/* 57 */	\
	MATRIX_KEY(0x07, 0x08, KEY_E)		/* 19 */	\
	MATRIX_KEY(0x07, 0x09, KEY_R)		/* 20 */	\
	MATRIX_KEY(0x07, 0x0b, KEY_UP)		/* 83 */	\
	MATRIX_KEY(0x07, 0x0c, KEY_LEFT)	/* 79 */	\
	MATRIX_KEY(0x07, 0x11, KEY_102ND)	/* 45 (ISO) */

#endif /* _CROS_EC_KEYBOARD_H */
