/*	$NetBSD: qcom,sc8280xp-camcc.h,v 1.1.1.1 2026/01/18 05:21:36 skrll Exp $	*/

/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright (c) 2021, The Linux Foundation. All rights reserved.
 * Copyright (c) 2023, Linaro Ltd.
 */

#ifndef __DT_BINDINGS_CLK_QCOM_CAMCC_SC8280XP_H__
#define __DT_BINDINGS_CLK_QCOM_CAMCC_SC8280XP_H__

/* CAMCC clocks */
#define CAMCC_PLL0					0
#define CAMCC_PLL0_OUT_EVEN				1
#define CAMCC_PLL0_OUT_ODD				2
#define CAMCC_PLL1					3
#define CAMCC_PLL1_OUT_EVEN				4
#define CAMCC_PLL2					5
#define CAMCC_PLL3					6
#define CAMCC_PLL3_OUT_EVEN				7
#define CAMCC_PLL4					8
#define CAMCC_PLL4_OUT_EVEN				9
#define CAMCC_PLL5					10
#define CAMCC_PLL5_OUT_EVEN				11
#define CAMCC_PLL6					12
#define CAMCC_PLL6_OUT_EVEN				13
#define CAMCC_PLL7					14
#define CAMCC_PLL7_OUT_EVEN				15
#define CAMCC_PLL7_OUT_ODD				16
#define CAMCC_BPS_AHB_CLK				17
#define CAMCC_BPS_AREG_CLK				18
#define CAMCC_BPS_AXI_CLK				19
#define CAMCC_BPS_CLK					20
#define CAMCC_BPS_CLK_SRC				21
#define CAMCC_CAMNOC_AXI_CLK				22
#define CAMCC_CAMNOC_AXI_CLK_SRC			23
#define CAMCC_CAMNOC_DCD_XO_CLK				24
#define CAMCC_CCI_0_CLK					25
#define CAMCC_CCI_0_CLK_SRC				26
#define CAMCC_CCI_1_CLK					27
#define CAMCC_CCI_1_CLK_SRC				28
#define CAMCC_CCI_2_CLK					29
#define CAMCC_CCI_2_CLK_SRC				30
#define CAMCC_CCI_3_CLK					31
#define CAMCC_CCI_3_CLK_SRC				32
#define CAMCC_CORE_AHB_CLK				33
#define CAMCC_CPAS_AHB_CLK				34
#define CAMCC_CPHY_RX_CLK_SRC				35
#define CAMCC_CSI0PHYTIMER_CLK				36
#define CAMCC_CSI0PHYTIMER_CLK_SRC			37
#define CAMCC_CSI1PHYTIMER_CLK				38
#define CAMCC_CSI1PHYTIMER_CLK_SRC			39
#define CAMCC_CSI2PHYTIMER_CLK				40
#define CAMCC_CSI2PHYTIMER_CLK_SRC			41
#define CAMCC_CSI3PHYTIMER_CLK				42
#define CAMCC_CSI3PHYTIMER_CLK_SRC			43
#define CAMCC_CSIPHY0_CLK				44
#define CAMCC_CSIPHY1_CLK				45
#define CAMCC_CSIPHY2_CLK				46
#define CAMCC_CSIPHY3_CLK				47
#define CAMCC_FAST_AHB_CLK_SRC				48
#define CAMCC_GDSC_CLK					49
#define CAMCC_ICP_AHB_CLK				50
#define CAMCC_ICP_CLK					51
#define CAMCC_ICP_CLK_SRC				52
#define CAMCC_IFE_0_AXI_CLK				53
#define CAMCC_IFE_0_CLK					54
#define CAMCC_IFE_0_CLK_SRC				55
#define CAMCC_IFE_0_CPHY_RX_CLK				56
#define CAMCC_IFE_0_CSID_CLK				57
#define CAMCC_IFE_0_CSID_CLK_SRC			58
#define CAMCC_IFE_0_DSP_CLK				59
#define CAMCC_IFE_1_AXI_CLK				60
#define CAMCC_IFE_1_CLK					61
#define CAMCC_IFE_1_CLK_SRC				62
#define CAMCC_IFE_1_CPHY_RX_CLK				63
#define CAMCC_IFE_1_CSID_CLK				64
#define CAMCC_IFE_1_CSID_CLK_SRC			65
#define CAMCC_IFE_1_DSP_CLK				66
#define CAMCC_IFE_2_AXI_CLK				67
#define CAMCC_IFE_2_CLK					68
#define CAMCC_IFE_2_CLK_SRC				69
#define CAMCC_IFE_2_CPHY_RX_CLK				70
#define CAMCC_IFE_2_CSID_CLK				71
#define CAMCC_IFE_2_CSID_CLK_SRC			72
#define CAMCC_IFE_2_DSP_CLK				73
#define CAMCC_IFE_3_AXI_CLK				74
#define CAMCC_IFE_3_CLK					75
#define CAMCC_IFE_3_CLK_SRC				76
#define CAMCC_IFE_3_CPHY_RX_CLK				77
#define CAMCC_IFE_3_CSID_CLK				78
#define CAMCC_IFE_3_CSID_CLK_SRC			79
#define CAMCC_IFE_3_DSP_CLK				80
#define CAMCC_IFE_LITE_0_CLK				81
#define CAMCC_IFE_LITE_0_CLK_SRC			82
#define CAMCC_IFE_LITE_0_CPHY_RX_CLK			83
#define CAMCC_IFE_LITE_0_CSID_CLK			84
#define CAMCC_IFE_LITE_0_CSID_CLK_SRC			85
#define CAMCC_IFE_LITE_1_CLK				86
#define CAMCC_IFE_LITE_1_CLK_SRC			87
#define CAMCC_IFE_LITE_1_CPHY_RX_CLK			88
#define CAMCC_IFE_LITE_1_CSID_CLK			89
#define CAMCC_IFE_LITE_1_CSID_CLK_SRC			90
#define CAMCC_IFE_LITE_2_CLK				91
#define CAMCC_IFE_LITE_2_CLK_SRC			92
#define CAMCC_IFE_LITE_2_CPHY_RX_CLK			93
#define CAMCC_IFE_LITE_2_CSID_CLK			94
#define CAMCC_IFE_LITE_2_CSID_CLK_SRC			95
#define CAMCC_IFE_LITE_3_CLK				96
#define CAMCC_IFE_LITE_3_CLK_SRC			97
#define CAMCC_IFE_LITE_3_CPHY_RX_CLK			98
#define CAMCC_IFE_LITE_3_CSID_CLK			99
#define CAMCC_IFE_LITE_3_CSID_CLK_SRC			100
#define CAMCC_IPE_0_AHB_CLK				101
#define CAMCC_IPE_0_AREG_CLK				102
#define CAMCC_IPE_0_AXI_CLK				103
#define CAMCC_IPE_0_CLK					104
#define CAMCC_IPE_0_CLK_SRC				105
#define CAMCC_IPE_1_AHB_CLK				106
#define CAMCC_IPE_1_AREG_CLK				107
#define CAMCC_IPE_1_AXI_CLK				108
#define CAMCC_IPE_1_CLK					109
#define CAMCC_JPEG_CLK					110
#define CAMCC_JPEG_CLK_SRC				111
#define CAMCC_LRME_CLK					112
#define CAMCC_LRME_CLK_SRC				113
#define CAMCC_MCLK0_CLK					114
#define CAMCC_MCLK0_CLK_SRC				115
#define CAMCC_MCLK1_CLK					116
#define CAMCC_MCLK1_CLK_SRC				117
#define CAMCC_MCLK2_CLK					118
#define CAMCC_MCLK2_CLK_SRC				119
#define CAMCC_MCLK3_CLK					120
#define CAMCC_MCLK3_CLK_SRC				121
#define CAMCC_MCLK4_CLK					122
#define CAMCC_MCLK4_CLK_SRC				123
#define CAMCC_MCLK5_CLK					124
#define CAMCC_MCLK5_CLK_SRC				125
#define CAMCC_MCLK6_CLK					126
#define CAMCC_MCLK6_CLK_SRC				127
#define CAMCC_MCLK7_CLK					128
#define CAMCC_MCLK7_CLK_SRC				129
#define CAMCC_SLEEP_CLK					130
#define CAMCC_SLEEP_CLK_SRC				131
#define CAMCC_SLOW_AHB_CLK_SRC				132
#define CAMCC_XO_CLK_SRC				133

/* CAMCC resets */
#define CAMCC_BPS_BCR					0
#define CAMCC_CAMNOC_BCR				1
#define CAMCC_CCI_BCR					2
#define CAMCC_CPAS_BCR					3
#define CAMCC_CSI0PHY_BCR				4
#define CAMCC_CSI1PHY_BCR				5
#define CAMCC_CSI2PHY_BCR				6
#define CAMCC_CSI3PHY_BCR				7
#define CAMCC_ICP_BCR					8
#define CAMCC_IFE_0_BCR					9
#define CAMCC_IFE_1_BCR					10
#define CAMCC_IFE_2_BCR					11
#define CAMCC_IFE_3_BCR					12
#define CAMCC_IFE_LITE_0_BCR				13
#define CAMCC_IFE_LITE_1_BCR				14
#define CAMCC_IFE_LITE_2_BCR				15
#define CAMCC_IFE_LITE_3_BCR				16
#define CAMCC_IPE_0_BCR					17
#define CAMCC_IPE_1_BCR					18
#define CAMCC_JPEG_BCR					19
#define CAMCC_LRME_BCR					20

/* CAMCC GDSCRs */
#define BPS_GDSC					0
#define IFE_0_GDSC					1
#define IFE_1_GDSC					2
#define IFE_2_GDSC					3
#define IFE_3_GDSC					4
#define IPE_0_GDSC					5
#define IPE_1_GDSC					6
#define TITAN_TOP_GDSC					7

#endif /* __DT_BINDINGS_CLK_QCOM_CAMCC_SC8280XP_H__ */
