/*	$NetBSD: mediatek,mt8188-clk.h,v 1.1.1.1 2026/01/18 05:21:32 skrll Exp $	*/

/* SPDX-License-Identifier: (GPL-2.0 OR BSD-2-Clause) */
/*
 * Copyright (c) 2022 MediaTek Inc.
 * Author: Garmin Chang <garmin.chang@mediatek.com>
 */

#ifndef _DT_BINDINGS_CLK_MT8188_H
#define _DT_BINDINGS_CLK_MT8188_H

/* TOPCKGEN */
#define CLK_TOP_AXI				0
#define CLK_TOP_SPM				1
#define CLK_TOP_SCP				2
#define CLK_TOP_BUS_AXIMEM			3
#define CLK_TOP_VPP				4
#define CLK_TOP_ETHDR				5
#define CLK_TOP_IPE				6
#define CLK_TOP_CAM				7
#define CLK_TOP_CCU				8
#define CLK_TOP_CCU_AHB				9
#define CLK_TOP_IMG				10
#define CLK_TOP_CAMTM				11
#define CLK_TOP_DSP				12
#define CLK_TOP_DSP1				13
#define CLK_TOP_DSP2				14
#define CLK_TOP_DSP3				15
#define CLK_TOP_DSP4				16
#define CLK_TOP_DSP5				17
#define CLK_TOP_DSP6				18
#define CLK_TOP_DSP7				19
#define CLK_TOP_MFG_CORE_TMP			20
#define CLK_TOP_CAMTG				21
#define CLK_TOP_CAMTG2				22
#define CLK_TOP_CAMTG3				23
#define CLK_TOP_UART				24
#define CLK_TOP_SPI				25
#define CLK_TOP_MSDC50_0_HCLK			26
#define CLK_TOP_MSDC50_0			27
#define CLK_TOP_MSDC30_1			28
#define CLK_TOP_MSDC30_2			29
#define CLK_TOP_INTDIR				30
#define CLK_TOP_AUD_INTBUS			31
#define CLK_TOP_AUDIO_H				32
#define CLK_TOP_PWRAP_ULPOSC			33
#define CLK_TOP_ATB				34
#define CLK_TOP_SSPM				35
#define CLK_TOP_DP				36
#define CLK_TOP_EDP				37
#define CLK_TOP_DPI				38
#define CLK_TOP_DISP_PWM0			39
#define CLK_TOP_DISP_PWM1			40
#define CLK_TOP_USB_TOP				41
#define CLK_TOP_SSUSB_XHCI			42
#define CLK_TOP_USB_TOP_2P			43
#define CLK_TOP_SSUSB_XHCI_2P			44
#define CLK_TOP_USB_TOP_3P			45
#define CLK_TOP_SSUSB_XHCI_3P			46
#define CLK_TOP_I2C				47
#define CLK_TOP_SENINF				48
#define CLK_TOP_SENINF1				49
#define CLK_TOP_GCPU				50
#define CLK_TOP_VENC				51
#define CLK_TOP_VDEC				52
#define CLK_TOP_PWM				53
#define CLK_TOP_MCUPM				54
#define CLK_TOP_SPMI_P_MST			55
#define CLK_TOP_SPMI_M_MST			56
#define CLK_TOP_DVFSRC				57
#define CLK_TOP_TL				58
#define CLK_TOP_AES_MSDCFDE			59
#define CLK_TOP_DSI_OCC				60
#define CLK_TOP_WPE_VPP				61
#define CLK_TOP_HDCP				62
#define CLK_TOP_HDCP_24M			63
#define CLK_TOP_HDMI_APB			64
#define CLK_TOP_SNPS_ETH_250M			65
#define CLK_TOP_SNPS_ETH_62P4M_PTP		66
#define CLK_TOP_SNPS_ETH_50M_RMII		67
#define CLK_TOP_ADSP				68
#define CLK_TOP_AUDIO_LOCAL_BUS			69
#define CLK_TOP_ASM_H				70
#define CLK_TOP_ASM_L				71
#define CLK_TOP_APLL1				72
#define CLK_TOP_APLL2				73
#define CLK_TOP_APLL3				74
#define CLK_TOP_APLL4				75
#define CLK_TOP_APLL5				76
#define CLK_TOP_I2SO1				77
#define CLK_TOP_I2SO2				78
#define CLK_TOP_I2SI1				79
#define CLK_TOP_I2SI2				80
#define CLK_TOP_DPTX				81
#define CLK_TOP_AUD_IEC				82
#define CLK_TOP_A1SYS_HP			83
#define CLK_TOP_A2SYS				84
#define CLK_TOP_A3SYS				85
#define CLK_TOP_A4SYS				86
#define CLK_TOP_ECC				87
#define CLK_TOP_SPINOR				88
#define CLK_TOP_ULPOSC				89
#define CLK_TOP_SRCK				90
#define CLK_TOP_MFG_CK_FAST_REF			91
#define CLK_TOP_MAINPLL_D3			92
#define CLK_TOP_MAINPLL_D4			93
#define CLK_TOP_MAINPLL_D4_D2			94
#define CLK_TOP_MAINPLL_D4_D4			95
#define CLK_TOP_MAINPLL_D4_D8			96
#define CLK_TOP_MAINPLL_D5			97
#define CLK_TOP_MAINPLL_D5_D2			98
#define CLK_TOP_MAINPLL_D5_D4			99
#define CLK_TOP_MAINPLL_D5_D8			100
#define CLK_TOP_MAINPLL_D6			101
#define CLK_TOP_MAINPLL_D6_D2			102
#define CLK_TOP_MAINPLL_D6_D4			103
#define CLK_TOP_MAINPLL_D6_D8			104
#define CLK_TOP_MAINPLL_D7			105
#define CLK_TOP_MAINPLL_D7_D2			106
#define CLK_TOP_MAINPLL_D7_D4			107
#define CLK_TOP_MAINPLL_D7_D8			108
#define CLK_TOP_MAINPLL_D9			109
#define CLK_TOP_UNIVPLL_D2			110
#define CLK_TOP_UNIVPLL_D3			111
#define CLK_TOP_UNIVPLL_D4			112
#define CLK_TOP_UNIVPLL_D4_D2			113
#define CLK_TOP_UNIVPLL_D4_D4			114
#define CLK_TOP_UNIVPLL_D4_D8			115
#define CLK_TOP_UNIVPLL_D5			116
#define CLK_TOP_UNIVPLL_D5_D2			117
#define CLK_TOP_UNIVPLL_D5_D4			118
#define CLK_TOP_UNIVPLL_D5_D8			119
#define CLK_TOP_UNIVPLL_D6			120
#define CLK_TOP_UNIVPLL_D6_D2			121
#define CLK_TOP_UNIVPLL_D6_D4			122
#define CLK_TOP_UNIVPLL_D6_D8			123
#define CLK_TOP_UNIVPLL_D7			124
#define CLK_TOP_UNIVPLL_192M			125
#define CLK_TOP_UNIVPLL_192M_D4			126
#define CLK_TOP_UNIVPLL_192M_D8			127
#define CLK_TOP_UNIVPLL_192M_D10		128
#define CLK_TOP_UNIVPLL_192M_D16		129
#define CLK_TOP_UNIVPLL_192M_D32		130
#define CLK_TOP_APLL1_D3			131
#define CLK_TOP_APLL1_D4			132
#define CLK_TOP_APLL2_D3			133
#define CLK_TOP_APLL2_D4			134
#define CLK_TOP_APLL3_D4			135
#define CLK_TOP_APLL4_D4			136
#define CLK_TOP_APLL5_D4			137
#define CLK_TOP_MMPLL_D4			138
#define CLK_TOP_MMPLL_D4_D2			139
#define CLK_TOP_MMPLL_D5			140
#define CLK_TOP_MMPLL_D5_D2			141
#define CLK_TOP_MMPLL_D5_D4			142
#define CLK_TOP_MMPLL_D6			143
#define CLK_TOP_MMPLL_D6_D2			144
#define CLK_TOP_MMPLL_D7			145
#define CLK_TOP_MMPLL_D9			146
#define CLK_TOP_TVDPLL1				147
#define CLK_TOP_TVDPLL1_D2			148
#define CLK_TOP_TVDPLL1_D4			149
#define CLK_TOP_TVDPLL1_D8			150
#define CLK_TOP_TVDPLL1_D16			151
#define CLK_TOP_TVDPLL2				152
#define CLK_TOP_TVDPLL2_D2			153
#define CLK_TOP_TVDPLL2_D4			154
#define CLK_TOP_TVDPLL2_D8			155
#define CLK_TOP_TVDPLL2_D16			156
#define CLK_TOP_MSDCPLL_D2			157
#define CLK_TOP_MSDCPLL_D16			158
#define CLK_TOP_ETHPLL				159
#define CLK_TOP_ETHPLL_D2			160
#define CLK_TOP_ETHPLL_D4			161
#define CLK_TOP_ETHPLL_D8			162
#define CLK_TOP_ETHPLL_D10			163
#define CLK_TOP_ADSPPLL_D2			164
#define CLK_TOP_ADSPPLL_D4			165
#define CLK_TOP_ADSPPLL_D8			166
#define CLK_TOP_ULPOSC1				167
#define CLK_TOP_ULPOSC1_D2			168
#define CLK_TOP_ULPOSC1_D4			169
#define CLK_TOP_ULPOSC1_D8			170
#define CLK_TOP_ULPOSC1_D7			171
#define CLK_TOP_ULPOSC1_D10			172
#define CLK_TOP_ULPOSC1_D16			173
#define CLK_TOP_MPHONE_SLAVE_BCK		174
#define CLK_TOP_PAD_FPC				175
#define CLK_TOP_466M_FMEM			176
#define CLK_TOP_PEXTP_PIPE			177
#define CLK_TOP_DSI_PHY				178
#define CLK_TOP_APLL12_CK_DIV0			179
#define CLK_TOP_APLL12_CK_DIV1			180
#define CLK_TOP_APLL12_CK_DIV2			181
#define CLK_TOP_APLL12_CK_DIV3			182
#define CLK_TOP_APLL12_CK_DIV4			183
#define CLK_TOP_APLL12_CK_DIV9			184
#define CLK_TOP_CFGREG_CLOCK_EN_VPP0		185
#define CLK_TOP_CFGREG_CLOCK_EN_VPP1		186
#define CLK_TOP_CFGREG_CLOCK_EN_VDO0		187
#define CLK_TOP_CFGREG_CLOCK_EN_VDO1		188
#define CLK_TOP_CFGREG_CLOCK_ISP_AXI_GALS	189
#define CLK_TOP_CFGREG_F26M_VPP0		190
#define CLK_TOP_CFGREG_F26M_VPP1		191
#define CLK_TOP_CFGREG_F26M_VDO0		192
#define CLK_TOP_CFGREG_F26M_VDO1		193
#define CLK_TOP_CFGREG_AUD_F26M_AUD		194
#define CLK_TOP_CFGREG_UNIPLL_SES		195
#define CLK_TOP_CFGREG_F_PCIE_PHY_REF		196
#define CLK_TOP_SSUSB_TOP_REF			197
#define CLK_TOP_SSUSB_PHY_REF			198
#define CLK_TOP_SSUSB_TOP_P1_REF		199
#define CLK_TOP_SSUSB_PHY_P1_REF		200
#define CLK_TOP_SSUSB_TOP_P2_REF		201
#define CLK_TOP_SSUSB_PHY_P2_REF		202
#define CLK_TOP_SSUSB_TOP_P3_REF		203
#define CLK_TOP_SSUSB_PHY_P3_REF		204
#define CLK_TOP_NR_CLK				205

/* INFRACFG_AO */
#define CLK_INFRA_AO_PMIC_TMR			0
#define CLK_INFRA_AO_PMIC_AP			1
#define CLK_INFRA_AO_PMIC_MD			2
#define CLK_INFRA_AO_PMIC_CONN			3
#define CLK_INFRA_AO_SEJ			4
#define CLK_INFRA_AO_APXGPT			5
#define CLK_INFRA_AO_GCE			6
#define CLK_INFRA_AO_GCE2			7
#define CLK_INFRA_AO_THERM			8
#define CLK_INFRA_AO_PWM_HCLK			9
#define CLK_INFRA_AO_PWM1			10
#define CLK_INFRA_AO_PWM2			11
#define CLK_INFRA_AO_PWM3			12
#define CLK_INFRA_AO_PWM4			13
#define CLK_INFRA_AO_PWM			14
#define CLK_INFRA_AO_UART0			15
#define CLK_INFRA_AO_UART1			16
#define CLK_INFRA_AO_UART2			17
#define CLK_INFRA_AO_UART3			18
#define CLK_INFRA_AO_UART4			19
#define CLK_INFRA_AO_GCE_26M			20
#define CLK_INFRA_AO_CQ_DMA_FPC			21
#define CLK_INFRA_AO_UART5			22
#define CLK_INFRA_AO_HDMI_26M			23
#define CLK_INFRA_AO_SPI0			24
#define CLK_INFRA_AO_MSDC0			25
#define CLK_INFRA_AO_MSDC1			26
#define CLK_INFRA_AO_MSDC2			27
#define CLK_INFRA_AO_MSDC0_SRC			28
#define CLK_INFRA_AO_DVFSRC			29
#define CLK_INFRA_AO_TRNG			30
#define CLK_INFRA_AO_AUXADC			31
#define CLK_INFRA_AO_CPUM			32
#define CLK_INFRA_AO_HDMI_32K			33
#define CLK_INFRA_AO_CEC_66M_HCLK		34
#define CLK_INFRA_AO_PCIE_TL_26M		35
#define CLK_INFRA_AO_MSDC1_SRC			36
#define CLK_INFRA_AO_CEC_66M_BCLK		37
#define CLK_INFRA_AO_PCIE_TL_96M		38
#define CLK_INFRA_AO_DEVICE_APC			39
#define CLK_INFRA_AO_ECC_66M_HCLK		40
#define CLK_INFRA_AO_DEBUGSYS			41
#define CLK_INFRA_AO_AUDIO			42
#define CLK_INFRA_AO_PCIE_TL_32K		43
#define CLK_INFRA_AO_DBG_TRACE			44
#define CLK_INFRA_AO_DRAMC_F26M			45
#define CLK_INFRA_AO_IRTX			46
#define CLK_INFRA_AO_DISP_PWM			47
#define CLK_INFRA_AO_CLDMA_BCLK			48
#define CLK_INFRA_AO_AUDIO_26M_BCLK		49
#define CLK_INFRA_AO_SPI1			50
#define CLK_INFRA_AO_SPI2			51
#define CLK_INFRA_AO_SPI3			52
#define CLK_INFRA_AO_FSSPM			53
#define CLK_INFRA_AO_SSPM_BUS_HCLK		54
#define CLK_INFRA_AO_APDMA_BCLK			55
#define CLK_INFRA_AO_SPI4			56
#define CLK_INFRA_AO_SPI5			57
#define CLK_INFRA_AO_CQ_DMA			58
#define CLK_INFRA_AO_MSDC0_SELF			59
#define CLK_INFRA_AO_MSDC1_SELF			60
#define CLK_INFRA_AO_MSDC2_SELF			61
#define CLK_INFRA_AO_I2S_DMA			62
#define CLK_INFRA_AO_AP_MSDC0			63
#define CLK_INFRA_AO_MD_MSDC0			64
#define CLK_INFRA_AO_MSDC30_2			65
#define CLK_INFRA_AO_GCPU			66
#define CLK_INFRA_AO_PCIE_PERI_26M		67
#define CLK_INFRA_AO_GCPU_66M_BCLK		68
#define CLK_INFRA_AO_GCPU_133M_BCLK		69
#define CLK_INFRA_AO_DISP_PWM1			70
#define CLK_INFRA_AO_FBIST2FPC			71
#define CLK_INFRA_AO_DEVICE_APC_SYNC		72
#define CLK_INFRA_AO_PCIE_P1_PERI_26M		73
#define CLK_INFRA_AO_133M_MCLK_CK		74
#define CLK_INFRA_AO_66M_MCLK_CK		75
#define CLK_INFRA_AO_PCIE_PL_P_250M_P0		76
#define CLK_INFRA_AO_RG_AES_MSDCFDE_CK_0P	77
#define CLK_INFRA_AO_NR_CLK			78

/* APMIXEDSYS */
#define CLK_APMIXED_ETHPLL			0
#define CLK_APMIXED_MSDCPLL			1
#define CLK_APMIXED_TVDPLL1			2
#define CLK_APMIXED_TVDPLL2			3
#define CLK_APMIXED_MMPLL			4
#define CLK_APMIXED_MAINPLL			5
#define CLK_APMIXED_IMGPLL			6
#define CLK_APMIXED_UNIVPLL			7
#define CLK_APMIXED_ADSPPLL			8
#define CLK_APMIXED_APLL1			9
#define CLK_APMIXED_APLL2			10
#define CLK_APMIXED_APLL3			11
#define CLK_APMIXED_APLL4			12
#define CLK_APMIXED_APLL5			13
#define CLK_APMIXED_MFGPLL			14
#define CLK_APMIXED_PLL_SSUSB26M_EN		15
#define CLK_APMIXED_NR_CLK			16

/* AUDIODSP */
#define CLK_AUDIODSP_AUDIO26M			0
#define CLK_AUDIODSP_NR_CLK			1

/* PERICFG_AO */
#define CLK_PERI_AO_ETHERNET			0
#define CLK_PERI_AO_ETHERNET_BUS		1
#define CLK_PERI_AO_FLASHIF_BUS			2
#define CLK_PERI_AO_FLASHIF_26M			3
#define CLK_PERI_AO_FLASHIFLASHCK		4
#define CLK_PERI_AO_SSUSB_2P_BUS		5
#define CLK_PERI_AO_SSUSB_2P_XHCI		6
#define CLK_PERI_AO_SSUSB_3P_BUS		7
#define CLK_PERI_AO_SSUSB_3P_XHCI		8
#define CLK_PERI_AO_SSUSB_BUS			9
#define CLK_PERI_AO_SSUSB_XHCI			10
#define CLK_PERI_AO_ETHERNET_MAC		11
#define CLK_PERI_AO_PCIE_P0_FMEM		12
#define CLK_PERI_AO_NR_CLK			13

/* IMP_IIC_WRAP_C */
#define CLK_IMP_IIC_WRAP_C_AP_CLOCK_I2C0	0
#define CLK_IMP_IIC_WRAP_C_AP_CLOCK_I2C2	1
#define CLK_IMP_IIC_WRAP_C_AP_CLOCK_I2C3	2
#define CLK_IMP_IIC_WRAP_C_NR_CLK		3

/* IMP_IIC_WRAP_W */
#define CLK_IMP_IIC_WRAP_W_AP_CLOCK_I2C1	0
#define CLK_IMP_IIC_WRAP_W_AP_CLOCK_I2C4	1
#define CLK_IMP_IIC_WRAP_W_NR_CLK		2

/* IMP_IIC_WRAP_EN */
#define CLK_IMP_IIC_WRAP_EN_AP_CLOCK_I2C5	0
#define CLK_IMP_IIC_WRAP_EN_AP_CLOCK_I2C6	1
#define CLK_IMP_IIC_WRAP_EN_NR_CLK		2

/* MFGCFG */
#define CLK_MFGCFG_BG3D				0
#define CLK_MFGCFG_NR_CLK			1

/* VPPSYS0 */
#define CLK_VPP0_MDP_FG				0
#define CLK_VPP0_STITCH				1
#define CLK_VPP0_PADDING			2
#define CLK_VPP0_MDP_TCC			3
#define CLK_VPP0_WARP0_ASYNC_TX			4
#define CLK_VPP0_WARP1_ASYNC_TX			5
#define CLK_VPP0_MUTEX				6
#define CLK_VPP02VPP1_RELAY			7
#define CLK_VPP0_VPP12VPP0_ASYNC		8
#define CLK_VPP0_MMSYSRAM_TOP			9
#define CLK_VPP0_MDP_AAL			10
#define CLK_VPP0_MDP_RSZ			11
#define CLK_VPP0_SMI_COMMON_MMSRAM		12
#define CLK_VPP0_GALS_VDO0_LARB0_MMSRAM		13
#define CLK_VPP0_GALS_VDO0_LARB1_MMSRAM		14
#define CLK_VPP0_GALS_VENCSYS_MMSRAM		15
#define CLK_VPP0_GALS_VENCSYS_CORE1_MMSRAM	16
#define CLK_VPP0_GALS_INFRA_MMSRAM		17
#define CLK_VPP0_GALS_CAMSYS_MMSRAM		18
#define CLK_VPP0_GALS_VPP1_LARB5_MMSRAM		19
#define CLK_VPP0_GALS_VPP1_LARB6_MMSRAM		20
#define CLK_VPP0_SMI_REORDER_MMSRAM		21
#define CLK_VPP0_SMI_IOMMU			22
#define CLK_VPP0_GALS_IMGSYS_CAMSYS		23
#define CLK_VPP0_MDP_RDMA			24
#define CLK_VPP0_MDP_WROT			25
#define CLK_VPP0_GALS_EMI0_EMI1			26
#define CLK_VPP0_SMI_SUB_COMMON_REORDER		27
#define CLK_VPP0_SMI_RSI			28
#define CLK_VPP0_SMI_COMMON_LARB4		29
#define CLK_VPP0_GALS_VDEC_VDEC_CORE1		30
#define CLK_VPP0_GALS_VPP1_WPESYS		31
#define CLK_VPP0_GALS_VDO0_VDO1_VENCSYS_CORE1	32
#define CLK_VPP0_FAKE_ENG			33
#define CLK_VPP0_MDP_HDR			34
#define CLK_VPP0_MDP_TDSHP			35
#define CLK_VPP0_MDP_COLOR			36
#define CLK_VPP0_MDP_OVL			37
#define CLK_VPP0_DSIP_RDMA			38
#define CLK_VPP0_DISP_WDMA			39
#define CLK_VPP0_MDP_HMS			40
#define CLK_VPP0_WARP0_RELAY			41
#define CLK_VPP0_WARP0_ASYNC			42
#define CLK_VPP0_WARP1_RELAY			43
#define CLK_VPP0_WARP1_ASYNC			44
#define CLK_VPP0_NR_CLK				45

/* WPESYS */
#define CLK_WPE_TOP_WPE_VPP0			0
#define CLK_WPE_TOP_SMI_LARB7			1
#define CLK_WPE_TOP_WPESYS_EVENT_TX		2
#define CLK_WPE_TOP_SMI_LARB7_PCLK_EN		3
#define CLK_WPE_TOP_NR_CLK			4

/* WPESYS_VPP0 */
#define CLK_WPE_VPP0_VECI			0
#define CLK_WPE_VPP0_VEC2I			1
#define CLK_WPE_VPP0_VEC3I			2
#define CLK_WPE_VPP0_WPEO			3
#define CLK_WPE_VPP0_MSKO			4
#define CLK_WPE_VPP0_VGEN			5
#define CLK_WPE_VPP0_EXT			6
#define CLK_WPE_VPP0_VFC			7
#define CLK_WPE_VPP0_CACH0_TOP			8
#define CLK_WPE_VPP0_CACH0_DMA			9
#define CLK_WPE_VPP0_CACH1_TOP			10
#define CLK_WPE_VPP0_CACH1_DMA			11
#define CLK_WPE_VPP0_CACH2_TOP			12
#define CLK_WPE_VPP0_CACH2_DMA			13
#define CLK_WPE_VPP0_CACH3_TOP			14
#define CLK_WPE_VPP0_CACH3_DMA			15
#define CLK_WPE_VPP0_PSP			16
#define CLK_WPE_VPP0_PSP2			17
#define CLK_WPE_VPP0_SYNC			18
#define CLK_WPE_VPP0_C24			19
#define CLK_WPE_VPP0_MDP_CROP			20
#define CLK_WPE_VPP0_ISP_CROP			21
#define CLK_WPE_VPP0_TOP			22
#define CLK_WPE_VPP0_NR_CLK			23

/* VPPSYS1 */
#define CLK_VPP1_SVPP1_MDP_OVL			0
#define CLK_VPP1_SVPP1_MDP_TCC			1
#define CLK_VPP1_SVPP1_MDP_WROT			2
#define CLK_VPP1_SVPP1_VPP_PAD			3
#define CLK_VPP1_SVPP2_MDP_WROT			4
#define CLK_VPP1_SVPP2_VPP_PAD			5
#define CLK_VPP1_SVPP3_MDP_WROT			6
#define CLK_VPP1_SVPP3_VPP_PAD			7
#define CLK_VPP1_SVPP1_MDP_RDMA			8
#define CLK_VPP1_SVPP1_MDP_FG			9
#define CLK_VPP1_SVPP2_MDP_RDMA			10
#define CLK_VPP1_SVPP2_MDP_FG			11
#define CLK_VPP1_SVPP3_MDP_RDMA			12
#define CLK_VPP1_SVPP3_MDP_FG			13
#define CLK_VPP1_VPP_SPLIT			14
#define CLK_VPP1_SVPP2_VDO0_DL_RELAY		15
#define CLK_VPP1_SVPP1_MDP_RSZ			16
#define CLK_VPP1_SVPP1_MDP_TDSHP		17
#define CLK_VPP1_SVPP1_MDP_COLOR		18
#define CLK_VPP1_SVPP3_VDO1_DL_RELAY		19
#define CLK_VPP1_SVPP2_MDP_RSZ			20
#define CLK_VPP1_SVPP2_VPP_MERGE		21
#define CLK_VPP1_SVPP2_MDP_TDSHP		22
#define CLK_VPP1_SVPP2_MDP_COLOR		23
#define CLK_VPP1_SVPP3_MDP_RSZ			24
#define CLK_VPP1_SVPP3_VPP_MERGE		25
#define CLK_VPP1_SVPP3_MDP_TDSHP		26
#define CLK_VPP1_SVPP3_MDP_COLOR		27
#define CLK_VPP1_GALS5				28
#define CLK_VPP1_GALS6				29
#define CLK_VPP1_LARB5				30
#define CLK_VPP1_LARB6				31
#define CLK_VPP1_SVPP1_MDP_HDR			32
#define CLK_VPP1_SVPP1_MDP_AAL			33
#define CLK_VPP1_SVPP2_MDP_HDR			34
#define CLK_VPP1_SVPP2_MDP_AAL			35
#define CLK_VPP1_SVPP3_MDP_HDR			36
#define CLK_VPP1_SVPP3_MDP_AAL			37
#define CLK_VPP1_DISP_MUTEX			38
#define CLK_VPP1_SVPP2_VDO1_DL_RELAY		39
#define CLK_VPP1_SVPP3_VDO0_DL_RELAY		40
#define CLK_VPP1_VPP0_DL_ASYNC			41
#define CLK_VPP1_VPP0_DL1_RELAY			42
#define CLK_VPP1_LARB5_FAKE_ENG			43
#define CLK_VPP1_LARB6_FAKE_ENG			44
#define CLK_VPP1_HDMI_META			45
#define CLK_VPP1_VPP_SPLIT_HDMI			46
#define CLK_VPP1_DGI_IN				47
#define CLK_VPP1_DGI_OUT			48
#define CLK_VPP1_VPP_SPLIT_DGI			49
#define CLK_VPP1_DL_CON_OCC			50
#define CLK_VPP1_VPP_SPLIT_26M			51
#define CLK_VPP1_NR_CLK				52

/* IMGSYS */
#define CLK_IMGSYS_MAIN_LARB9			0
#define CLK_IMGSYS_MAIN_TRAW0			1
#define CLK_IMGSYS_MAIN_TRAW1			2
#define CLK_IMGSYS_MAIN_VCORE_GALS		3
#define CLK_IMGSYS_MAIN_DIP0			4
#define CLK_IMGSYS_MAIN_WPE0			5
#define CLK_IMGSYS_MAIN_IPE			6
#define CLK_IMGSYS_MAIN_WPE1			7
#define CLK_IMGSYS_MAIN_WPE2			8
#define CLK_IMGSYS_MAIN_GALS			9
#define CLK_IMGSYS_MAIN_NR_CLK			10

/* IMGSYS1_DIP_TOP */
#define CLK_IMGSYS1_DIP_TOP_LARB10		0
#define CLK_IMGSYS1_DIP_TOP_DIP_TOP		1
#define CLK_IMGSYS1_DIP_TOP_NR_CLK		2

/* IMGSYS1_DIP_NR */
#define CLK_IMGSYS1_DIP_NR_LARB15		0
#define CLK_IMGSYS1_DIP_NR_DIP_NR		1
#define CLK_IMGSYS1_DIP_NR_NR_CLK		2

/* IMGSYS_WPE1 */
#define CLK_IMGSYS_WPE1_LARB11			0
#define CLK_IMGSYS_WPE1				1
#define CLK_IMGSYS_WPE1_NR_CLK			2

/* IPESYS */
#define CLK_IPE_DPE				0
#define CLK_IPE_FDVT				1
#define CLK_IPE_ME				2
#define CLK_IPESYS_TOP				3
#define CLK_IPE_SMI_LARB12			4
#define CLK_IPE_NR_CLK				5

/* IMGSYS_WPE2 */
#define CLK_IMGSYS_WPE2_LARB11			0
#define CLK_IMGSYS_WPE2				1
#define CLK_IMGSYS_WPE2_NR_CLK			2

/* IMGSYS_WPE3 */
#define CLK_IMGSYS_WPE3_LARB11			0
#define CLK_IMGSYS_WPE3				1
#define CLK_IMGSYS_WPE3_NR_CLK			2

/* CAMSYS */
#define CLK_CAM_MAIN_LARB13			0
#define CLK_CAM_MAIN_LARB14			1
#define CLK_CAM_MAIN_CAM			2
#define CLK_CAM_MAIN_CAM_SUBA			3
#define CLK_CAM_MAIN_CAM_SUBB			4
#define CLK_CAM_MAIN_CAMTG			5
#define CLK_CAM_MAIN_SENINF			6
#define CLK_CAM_MAIN_GCAMSVA			7
#define CLK_CAM_MAIN_GCAMSVB			8
#define CLK_CAM_MAIN_GCAMSVC			9
#define CLK_CAM_MAIN_GCAMSVD			10
#define CLK_CAM_MAIN_GCAMSVE			11
#define CLK_CAM_MAIN_GCAMSVF			12
#define CLK_CAM_MAIN_GCAMSVG			13
#define CLK_CAM_MAIN_GCAMSVH			14
#define CLK_CAM_MAIN_GCAMSVI			15
#define CLK_CAM_MAIN_GCAMSVJ			16
#define CLK_CAM_MAIN_CAMSV_TOP			17
#define CLK_CAM_MAIN_CAMSV_CQ_A			18
#define CLK_CAM_MAIN_CAMSV_CQ_B			19
#define CLK_CAM_MAIN_CAMSV_CQ_C			20
#define CLK_CAM_MAIN_FAKE_ENG			21
#define CLK_CAM_MAIN_CAM2MM0_GALS		22
#define CLK_CAM_MAIN_CAM2MM1_GALS		23
#define CLK_CAM_MAIN_CAM2SYS_GALS		24
#define CLK_CAM_MAIN_NR_CLK			25

/* CAMSYS_RAWA */
#define CLK_CAM_RAWA_LARBX			0
#define CLK_CAM_RAWA_CAM			1
#define CLK_CAM_RAWA_CAMTG			2
#define CLK_CAM_RAWA_NR_CLK			3

/* CAMSYS_YUVA */
#define CLK_CAM_YUVA_LARBX			0
#define CLK_CAM_YUVA_CAM			1
#define CLK_CAM_YUVA_CAMTG			2
#define CLK_CAM_YUVA_NR_CLK			3

/* CAMSYS_RAWB */
#define CLK_CAM_RAWB_LARBX			0
#define CLK_CAM_RAWB_CAM			1
#define CLK_CAM_RAWB_CAMTG			2
#define CLK_CAM_RAWB_NR_CLK			3

/* CAMSYS_YUVB */
#define CLK_CAM_YUVB_LARBX			0
#define CLK_CAM_YUVB_CAM			1
#define CLK_CAM_YUVB_CAMTG			2
#define CLK_CAM_YUVB_NR_CLK			3

/* CCUSYS */
#define CLK_CCU_LARB27				0
#define CLK_CCU_AHB				1
#define CLK_CCU_CCU0				2
#define CLK_CCU_NR_CLK				3

/* VDECSYS_SOC */
#define CLK_VDEC1_SOC_LARB1			0
#define CLK_VDEC1_SOC_LAT			1
#define CLK_VDEC1_SOC_LAT_ACTIVE			2
#define CLK_VDEC1_SOC_LAT_ENG			3
#define CLK_VDEC1_SOC_VDEC			4
#define CLK_VDEC1_SOC_VDEC_ACTIVE		5
#define CLK_VDEC1_SOC_VDEC_ENG			6
#define CLK_VDEC1_NR_CLK				7

/* VDECSYS */
#define CLK_VDEC2_LARB1				0
#define CLK_VDEC2_LAT				1
#define CLK_VDEC2_VDEC				2
#define CLK_VDEC2_VDEC_ACTIVE			3
#define CLK_VDEC2_VDEC_ENG			4
#define CLK_VDEC2_NR_CLK				5

/* VENCSYS */
#define CLK_VENC1_LARB			0
#define CLK_VENC1_VENC			1
#define CLK_VENC1_JPGENC			2
#define CLK_VENC1_JPGDEC			3
#define CLK_VENC1_JPGDEC_C1			4
#define CLK_VENC1_GALS			5
#define CLK_VENC1_GALS_SRAM			6
#define CLK_VENC1_NR_CLK				7

/* VDOSYS0 */
#define CLK_VDO0_DISP_OVL0			0
#define CLK_VDO0_FAKE_ENG0			1
#define CLK_VDO0_DISP_CCORR0			2
#define CLK_VDO0_DISP_MUTEX0			3
#define CLK_VDO0_DISP_GAMMA0			4
#define CLK_VDO0_DISP_DITHER0			5
#define CLK_VDO0_DISP_WDMA0			6
#define CLK_VDO0_DISP_RDMA0			7
#define CLK_VDO0_DSI0				8
#define CLK_VDO0_DSI1				9
#define CLK_VDO0_DSC_WRAP0			10
#define CLK_VDO0_VPP_MERGE0			11
#define CLK_VDO0_DP_INTF0			12
#define CLK_VDO0_DISP_AAL0			13
#define CLK_VDO0_INLINEROT0			14
#define CLK_VDO0_APB_BUS			15
#define CLK_VDO0_DISP_COLOR0			16
#define CLK_VDO0_MDP_WROT0			17
#define CLK_VDO0_DISP_RSZ0			18
#define CLK_VDO0_DISP_POSTMASK0			19
#define CLK_VDO0_FAKE_ENG1			20
#define CLK_VDO0_DL_ASYNC2			21
#define CLK_VDO0_DL_RELAY3			22
#define CLK_VDO0_DL_RELAY4			23
#define CLK_VDO0_SMI_GALS			24
#define CLK_VDO0_SMI_COMMON			25
#define CLK_VDO0_SMI_EMI			26
#define CLK_VDO0_SMI_IOMMU			27
#define CLK_VDO0_SMI_LARB			28
#define CLK_VDO0_SMI_RSI			29
#define CLK_VDO0_DSI0_DSI			30
#define CLK_VDO0_DSI1_DSI			31
#define CLK_VDO0_DP_INTF0_DP_INTF		32
#define CLK_VDO0_NR_CLK				33

/* VDOSYS1 */
#define CLK_VDO1_SMI_LARB2			0
#define CLK_VDO1_SMI_LARB3			1
#define CLK_VDO1_GALS				2
#define CLK_VDO1_FAKE_ENG0			3
#define CLK_VDO1_FAKE_ENG1			4
#define CLK_VDO1_MDP_RDMA0			5
#define CLK_VDO1_MDP_RDMA1			6
#define CLK_VDO1_MDP_RDMA2			7
#define CLK_VDO1_MDP_RDMA3			8
#define CLK_VDO1_VPP_MERGE0			9
#define CLK_VDO1_VPP_MERGE1			10
#define CLK_VDO1_VPP_MERGE2			11
#define CLK_VDO1_VPP_MERGE3			12
#define CLK_VDO1_VPP_MERGE4			13
#define CLK_VDO1_VPP2_TO_VDO1_DL_ASYNC		14
#define CLK_VDO1_VPP3_TO_VDO1_DL_ASYNC		15
#define CLK_VDO1_DISP_MUTEX			16
#define CLK_VDO1_MDP_RDMA4			17
#define CLK_VDO1_MDP_RDMA5			18
#define CLK_VDO1_MDP_RDMA6			19
#define CLK_VDO1_MDP_RDMA7			20
#define CLK_VDO1_DP_INTF0_MMCK			21
#define CLK_VDO1_DPI0_MM			22
#define CLK_VDO1_DPI1_MM			23
#define CLK_VDO1_MERGE0_DL_ASYNC		24
#define CLK_VDO1_MERGE1_DL_ASYNC		25
#define CLK_VDO1_MERGE2_DL_ASYNC		26
#define CLK_VDO1_MERGE3_DL_ASYNC		27
#define CLK_VDO1_MERGE4_DL_ASYNC		28
#define CLK_VDO1_DSC_VDO1_DL_ASYNC		29
#define CLK_VDO1_MERGE_VDO1_DL_ASYNC		30
#define CLK_VDO1_PADDING0			31
#define CLK_VDO1_PADDING1			32
#define CLK_VDO1_PADDING2			33
#define CLK_VDO1_PADDING3			34
#define CLK_VDO1_PADDING4			35
#define CLK_VDO1_PADDING5			36
#define CLK_VDO1_PADDING6			37
#define CLK_VDO1_PADDING7			38
#define CLK_VDO1_DISP_RSZ0			39
#define CLK_VDO1_DISP_RSZ1			40
#define CLK_VDO1_DISP_RSZ2			41
#define CLK_VDO1_DISP_RSZ3			42
#define CLK_VDO1_HDR_VDO_FE0			43
#define CLK_VDO1_HDR_GFX_FE0			44
#define CLK_VDO1_HDR_VDO_BE			45
#define CLK_VDO1_HDR_VDO_FE1			46
#define CLK_VDO1_HDR_GFX_FE1			47
#define CLK_VDO1_DISP_MIXER			48
#define CLK_VDO1_HDR_VDO_FE0_DL_ASYNC		49
#define CLK_VDO1_HDR_VDO_FE1_DL_ASYNC		50
#define CLK_VDO1_HDR_GFX_FE0_DL_ASYNC		51
#define CLK_VDO1_HDR_GFX_FE1_DL_ASYNC		52
#define CLK_VDO1_HDR_VDO_BE_DL_ASYNC		53
#define CLK_VDO1_DPI0				54
#define CLK_VDO1_DISP_MONITOR_DPI0		55
#define CLK_VDO1_DPI1				56
#define CLK_VDO1_DISP_MONITOR_DPI1		57
#define CLK_VDO1_DPINTF				58
#define CLK_VDO1_DISP_MONITOR_DPINTF		59
#define CLK_VDO1_26M_SLOW			60
#define CLK_VDO1_NR_CLK				61

#endif /* _DT_BINDINGS_CLK_MT8188_H */
