/*	$NetBSD: imx95-pinfunc.h,v 1.1.1.1 2026/01/18 05:24:48 skrll Exp $	*/

/* SPDX-License-Identifier: (GPL-2.0-only OR MIT) */
/*
 * Copyright 2024 NXP
 */

#ifndef __DTS_IMX95_PINFUNC_H
#define __DTS_IMX95_PINFUNC_H

/*
 * The pin function ID is a tuple of
 * <mux_reg conf_reg input_reg mux_mode input_val>
 */
#define IMX95_PAD_DAP_TDI__JTAG_MUX_TDI                               0x0000 0x0204 0x0610 0x00 0x00
#define IMX95_PAD_DAP_TDI__NETCMIX_TOP_MQS2_LEFT                      0x0000 0x0204 0x0000 0x01 0x00
#define IMX95_PAD_DAP_TDI__NETCMIX_TOP_NETC_TMR_1588_ALARM1           0x0000 0x0204 0x0000 0x02 0x00
#define IMX95_PAD_DAP_TDI__CAN2_TX                                    0x0000 0x0204 0x0000 0x03 0x00
#define IMX95_PAD_DAP_TDI__FLEXIO2_FLEXIO_BIT30                       0x0000 0x0204 0x0000 0x04 0x00
#define IMX95_PAD_DAP_TDI__GPIO3_IO_BIT28                             0x0000 0x0204 0x0000 0x05 0x00
#define IMX95_PAD_DAP_TDI__LPUART5_RX                                 0x0000 0x0204 0x0570 0x06 0x00

#define IMX95_PAD_DAP_TMS_SWDIO__JTAG_MUX_TMS                         0x0004 0x0208 0x0614 0x00 0x00
#define IMX95_PAD_DAP_TMS_SWDIO__CAN4_TX                              0x0004 0x0208 0x0000 0x02 0x00
#define IMX95_PAD_DAP_TMS_SWDIO__FLEXIO2_FLEXIO_BIT31                 0x0004 0x0208 0x0000 0x04 0x00
#define IMX95_PAD_DAP_TMS_SWDIO__GPIO3_IO_BIT29                       0x0004 0x0208 0x0000 0x05 0x00
#define IMX95_PAD_DAP_TMS_SWDIO__LPUART5_RTS_B                        0x0004 0x0208 0x0000 0x06 0x00

#define IMX95_PAD_DAP_TCLK_SWCLK__JTAG_MUX_TCK                        0x0008 0x020C 0x060C 0x00 0x00
#define IMX95_PAD_DAP_TCLK_SWCLK__CAN4_RX                             0x0008 0x020C 0x044C 0x02 0x00
#define IMX95_PAD_DAP_TCLK_SWCLK__FLEXIO1_FLEXIO_BIT30                0x0008 0x020C 0x0460 0x04 0x00
#define IMX95_PAD_DAP_TCLK_SWCLK__GPIO3_IO_BIT30                      0x0008 0x020C 0x0000 0x05 0x00
#define IMX95_PAD_DAP_TCLK_SWCLK__LPUART5_CTS_B                       0x0008 0x020C 0x056C 0x06 0x00

#define IMX95_PAD_DAP_TDO_TRACESWO__JTAG_MUX_TDO                      0x000C 0x0210 0x0000 0x00 0x00
#define IMX95_PAD_DAP_TDO_TRACESWO__NETCMIX_TOP_MQS2_RIGHT            0x000C 0x0210 0x0000 0x01 0x00
#define IMX95_PAD_DAP_TDO_TRACESWO__NETCMIX_TOP_NETC_TMR_1588_ALARM   0x000C 0x0210 0x0000 0x02 0x00
#define IMX95_PAD_DAP_TDO_TRACESWO__CAN2_RX                           0x000C 0x0210 0x0444 0x03 0x00
#define IMX95_PAD_DAP_TDO_TRACESWO__FLEXIO1_FLEXIO_BIT31              0x000C 0x0210 0x0464 0x04 0x00
#define IMX95_PAD_DAP_TDO_TRACESWO__GPIO3_IO_BIT31                    0x000C 0x0210 0x0000 0x05 0x00
#define IMX95_PAD_DAP_TDO_TRACESWO__LPUART5_TX                        0x000C 0x0210 0x0574 0x06 0x00

#define IMX95_PAD_GPIO_IO00__GPIO2_IO_BIT0                            0x0010 0x0214 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO00__LPI2C3_SDA                               0x0010 0x0214 0x0504 0x11 0x00
#define IMX95_PAD_GPIO_IO00__LPSPI6_PCS0                              0x0010 0x0214 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO00__LPUART5_TX                               0x0010 0x0214 0x0574 0x05 0x01
#define IMX95_PAD_GPIO_IO00__LPI2C5_SDA                               0x0010 0x0214 0x0514 0x16 0x00
#define IMX95_PAD_GPIO_IO00__FLEXIO1_FLEXIO_BIT0                      0x0010 0x0214 0x0468 0x07 0x00

#define IMX95_PAD_GPIO_IO01__GPIO2_IO_BIT1                            0x0014 0x0218 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO01__LPI2C3_SCL                               0x0014 0x0218 0x0500 0x11 0x00
#define IMX95_PAD_GPIO_IO01__LPSPI6_SIN                               0x0014 0x0218 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO01__LPUART5_RX                               0x0014 0x0218 0x0570 0x05 0x01
#define IMX95_PAD_GPIO_IO01__LPI2C5_SCL                               0x0014 0x0218 0x0510 0x16 0x00
#define IMX95_PAD_GPIO_IO01__FLEXIO1_FLEXIO_BIT1                      0x0014 0x0218 0x046C 0x07 0x00

#define IMX95_PAD_GPIO_IO02__GPIO2_IO_BIT2                            0x0018 0x021C 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO02__LPI2C4_SDA                               0x0018 0x021C 0x050C 0x11 0x00
#define IMX95_PAD_GPIO_IO02__LPSPI6_SOUT                              0x0018 0x021C 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO02__LPUART5_CTS_B                            0x0018 0x021C 0x056C 0x05 0x01
#define IMX95_PAD_GPIO_IO02__LPI2C6_SDA                               0x0018 0x021C 0x051C 0x16 0x00
#define IMX95_PAD_GPIO_IO02__FLEXIO1_FLEXIO_BIT2                      0x0018 0x021C 0x0470 0x07 0x00

#define IMX95_PAD_GPIO_IO03__GPIO2_IO_BIT3                            0x001C 0x0220 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO03__LPI2C4_SCL                               0x001C 0x0220 0x0508 0x11 0x00
#define IMX95_PAD_GPIO_IO03__LPSPI6_SCK                               0x001C 0x0220 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO03__LPUART5_RTS_B                            0x001C 0x0220 0x0000 0x05 0x00
#define IMX95_PAD_GPIO_IO03__LPI2C6_SCL                               0x001C 0x0220 0x0518 0x16 0x00
#define IMX95_PAD_GPIO_IO03__FLEXIO1_FLEXIO_BIT3                      0x001C 0x0220 0x0474 0x07 0x00

#define IMX95_PAD_GPIO_IO04__GPIO2_IO_BIT4                            0x0020 0x0224 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO04__TPM3_CH0                                 0x0020 0x0224 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO04__AONMIX_TOP_PDM_CLK                       0x0020 0x0224 0x0000 0x02 0x00
#define IMX95_PAD_GPIO_IO04__CAN4_TX                                  0x0020 0x0224 0x0000 0x03 0x00
#define IMX95_PAD_GPIO_IO04__LPSPI7_PCS0                              0x0020 0x0224 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO04__LPUART6_TX                               0x0020 0x0224 0x0580 0x05 0x01
#define IMX95_PAD_GPIO_IO04__LPI2C6_SDA                               0x0020 0x0224 0x051C 0x16 0x01
#define IMX95_PAD_GPIO_IO04__FLEXIO1_FLEXIO_BIT4                      0x0020 0x0224 0x0478 0x07 0x00

#define IMX95_PAD_GPIO_IO05__GPIO2_IO_BIT5                            0x0024 0x0228 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO05__TPM4_CH0                                 0x0024 0x0228 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO05__AONMIX_TOP_PDM_BIT_STREAM_BIT0           0x0024 0x0228 0x040C 0x02 0x01
#define IMX95_PAD_GPIO_IO05__CAN4_RX                                  0x0024 0x0228 0x044C 0x03 0x01
#define IMX95_PAD_GPIO_IO05__LPSPI7_SIN                               0x0024 0x0228 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO05__LPUART6_RX                               0x0024 0x0228 0x057C 0x05 0x01
#define IMX95_PAD_GPIO_IO05__LPI2C6_SCL                               0x0024 0x0228 0x0518 0x16 0x01
#define IMX95_PAD_GPIO_IO05__FLEXIO1_FLEXIO_BIT5                      0x0024 0x0228 0x047C 0x07 0x00

#define IMX95_PAD_GPIO_IO06__GPIO2_IO_BIT6                            0x0028 0x022C 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO06__TPM5_CH0                                 0x0028 0x022C 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO06__AONMIX_TOP_PDM_BIT_STREAM_BIT1           0x0028 0x022C 0x0410 0x02 0x01
#define IMX95_PAD_GPIO_IO06__LPSPI7_SOUT                              0x0028 0x022C 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO06__LPUART6_CTS_B                            0x0028 0x022C 0x0578 0x05 0x01
#define IMX95_PAD_GPIO_IO06__LPI2C7_SDA                               0x0028 0x022C 0x0524 0x16 0x00
#define IMX95_PAD_GPIO_IO06__FLEXIO1_FLEXIO_BIT6                      0x0028 0x022C 0x0480 0x07 0x00

#define IMX95_PAD_GPIO_IO07__GPIO2_IO_BIT7                            0x002C 0x0230 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO07__LPSPI3_PCS1                              0x002C 0x0230 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO07__LPSPI7_SCK                               0x002C 0x0230 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO07__LPUART6_RTS_B                            0x002C 0x0230 0x0000 0x05 0x00
#define IMX95_PAD_GPIO_IO07__LPI2C7_SCL                               0x002C 0x0230 0x0520 0x16 0x00
#define IMX95_PAD_GPIO_IO07__FLEXIO1_FLEXIO_BIT7                      0x002C 0x0230 0x0484 0x07 0x00

#define IMX95_PAD_GPIO_IO08__GPIO2_IO_BIT8                            0x0030 0x0234 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO08__LPSPI3_PCS0                              0x0030 0x0234 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO08__TPM6_CH0                                 0x0030 0x0234 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO08__LPUART7_TX                               0x0030 0x0234 0x0588 0x05 0x01
#define IMX95_PAD_GPIO_IO08__LPI2C7_SDA                               0x0030 0x0234 0x0524 0x16 0x01
#define IMX95_PAD_GPIO_IO08__FLEXIO1_FLEXIO_BIT8                      0x0030 0x0234 0x0488 0x07 0x00

#define IMX95_PAD_GPIO_IO09__GPIO2_IO_BIT9                            0x0034 0x0238 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO09__LPSPI3_SIN                               0x0034 0x0238 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO09__TPM3_EXTCLK                              0x0034 0x0238 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO09__LPUART7_RX                               0x0034 0x0238 0x0584 0x05 0x01
#define IMX95_PAD_GPIO_IO09__LPI2C7_SCL                               0x0034 0x0238 0x0520 0x16 0x01
#define IMX95_PAD_GPIO_IO09__FLEXIO1_FLEXIO_BIT9                      0x0034 0x0238 0x048C 0x07 0x00

#define IMX95_PAD_GPIO_IO10__GPIO2_IO_BIT10                           0x0038 0x023C 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO10__LPSPI3_SOUT                              0x0038 0x023C 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO10__TPM4_EXTCLK                              0x0038 0x023C 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO10__LPUART7_CTS_B                            0x0038 0x023C 0x0000 0x05 0x00
#define IMX95_PAD_GPIO_IO10__LPI2C8_SDA                               0x0038 0x023C 0x052C 0x16 0x00
#define IMX95_PAD_GPIO_IO10__FLEXIO1_FLEXIO_BIT10                     0x0038 0x023C 0x0490 0x07 0x00

#define IMX95_PAD_GPIO_IO11__GPIO2_IO_BIT11                           0x003C 0x0240 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO11__LPSPI3_SCK                               0x003C 0x0240 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO11__TPM5_EXTCLK                              0x003C 0x0240 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO11__LPUART7_RTS_B                            0x003C 0x0240 0x0000 0x05 0x00
#define IMX95_PAD_GPIO_IO11__LPI2C8_SCL                               0x003C 0x0240 0x0528 0x16 0x00
#define IMX95_PAD_GPIO_IO11__FLEXIO1_FLEXIO_BIT11                     0x003C 0x0240 0x0494 0x07 0x00

#define IMX95_PAD_GPIO_IO12__GPIO2_IO_BIT12                           0x0040 0x0244 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO12__TPM3_CH2                                 0x0040 0x0244 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO12__AONMIX_TOP_PDM_BIT_STREAM_BIT2           0x0040 0x0244 0x0414 0x02 0x00
#define IMX95_PAD_GPIO_IO12__FLEXIO1_FLEXIO_BIT12                     0x0040 0x0244 0x0498 0x03 0x00
#define IMX95_PAD_GPIO_IO12__LPSPI8_PCS0                              0x0040 0x0244 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO12__LPUART8_TX                               0x0040 0x0244 0x0000 0x05 0x00
#define IMX95_PAD_GPIO_IO12__LPI2C8_SDA                               0x0040 0x0244 0x052C 0x16 0x01
#define IMX95_PAD_GPIO_IO12__SAI3_RX_SYNC                             0x0040 0x0244 0x0590 0x07 0x00

#define IMX95_PAD_GPIO_IO13__GPIO2_IO_BIT13                           0x0044 0x0248 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO13__TPM4_CH2                                 0x0044 0x0248 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO13__AONMIX_TOP_PDM_BIT_STREAM_BIT3           0x0044 0x0248 0x0418 0x02 0x00
#define IMX95_PAD_GPIO_IO13__LPSPI8_SIN                               0x0044 0x0248 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO13__LPUART8_RX                               0x0044 0x0248 0x0000 0x05 0x00
#define IMX95_PAD_GPIO_IO13__LPI2C8_SCL                               0x0044 0x0248 0x0528 0x16 0x01
#define IMX95_PAD_GPIO_IO13__FLEXIO1_FLEXIO_BIT13                     0x0044 0x0248 0x049C 0x07 0x00

#define IMX95_PAD_GPIO_IO14__GPIO2_IO_BIT14                           0x0048 0x024C 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO14__LPUART3_TX                               0x0048 0x024C 0x055C 0x01 0x01
#define IMX95_PAD_GPIO_IO14__LPSPI8_SOUT                              0x0048 0x024C 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO14__LPUART8_CTS_B                            0x0048 0x024C 0x0000 0x05 0x00
#define IMX95_PAD_GPIO_IO14__LPUART4_TX                               0x0048 0x024C 0x0568 0x06 0x01
#define IMX95_PAD_GPIO_IO14__FLEXIO1_FLEXIO_BIT14                     0x0048 0x024C 0x04A0 0x07 0x00

#define IMX95_PAD_GPIO_IO15__GPIO2_IO_BIT15                           0x004C 0x0250 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO15__LPUART3_RX                               0x004C 0x0250 0x0558 0x01 0x01
#define IMX95_PAD_GPIO_IO15__LPSPI8_SCK                               0x004C 0x0250 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO15__LPUART8_RTS_B                            0x004C 0x0250 0x0000 0x05 0x00
#define IMX95_PAD_GPIO_IO15__LPUART4_RX                               0x004C 0x0250 0x0564 0x06 0x01
#define IMX95_PAD_GPIO_IO15__FLEXIO1_FLEXIO_BIT15                     0x004C 0x0250 0x04A4 0x07 0x00

#define IMX95_PAD_GPIO_IO16__GPIO2_IO_BIT16                           0x0050 0x0254 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO16__SAI3_TX_BCLK                             0x0050 0x0254 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO16__AONMIX_TOP_PDM_BIT_STREAM_BIT2           0x0050 0x0254 0x0414 0x02 0x01
#define IMX95_PAD_GPIO_IO16__LPUART3_CTS_B                            0x0050 0x0254 0x0554 0x04 0x01
#define IMX95_PAD_GPIO_IO16__LPSPI4_PCS2                              0x0050 0x0254 0x0538 0x05 0x01
#define IMX95_PAD_GPIO_IO16__LPUART4_CTS_B                            0x0050 0x0254 0x0560 0x06 0x01
#define IMX95_PAD_GPIO_IO16__FLEXIO1_FLEXIO_BIT16                     0x0050 0x0254 0x04A8 0x07 0x00

#define IMX95_PAD_GPIO_IO17__GPIO2_IO_BIT17                           0x0054 0x0258 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO17__SAI3_MCLK                                0x0054 0x0258 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO17__LPUART3_RTS_B                            0x0054 0x0258 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO17__LPSPI4_PCS1                              0x0054 0x0258 0x0534 0x05 0x01
#define IMX95_PAD_GPIO_IO17__LPUART4_RTS_B                            0x0054 0x0258 0x0000 0x06 0x00
#define IMX95_PAD_GPIO_IO17__FLEXIO1_FLEXIO_BIT17                     0x0054 0x0258 0x04AC 0x07 0x00

#define IMX95_PAD_GPIO_IO18__GPIO2_IO_BIT18                           0x0058 0x025C 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO18__SAI3_RX_BCLK                             0x0058 0x025C 0x058C 0x01 0x00
#define IMX95_PAD_GPIO_IO18__LPSPI5_PCS0                              0x0058 0x025C 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO18__LPSPI4_PCS0                              0x0058 0x025C 0x0530 0x05 0x01
#define IMX95_PAD_GPIO_IO18__TPM5_CH2                                 0x0058 0x025C 0x0000 0x06 0x00
#define IMX95_PAD_GPIO_IO18__FLEXIO1_FLEXIO_BIT18                     0x0058 0x025C 0x04B0 0x07 0x00

#define IMX95_PAD_GPIO_IO19__GPIO2_IO_BIT19                           0x005C 0x0260 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO19__SAI3_RX_SYNC                             0x005C 0x0260 0x0590 0x01 0x01
#define IMX95_PAD_GPIO_IO19__AONMIX_TOP_PDM_BIT_STREAM_BIT3           0x005C 0x0260 0x0418 0x02 0x01
#define IMX95_PAD_GPIO_IO19__FLEXIO1_FLEXIO_BIT19                     0x005C 0x0260 0x04B4 0x03 0x00
#define IMX95_PAD_GPIO_IO19__LPSPI5_SIN                               0x005C 0x0260 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO19__LPSPI4_SIN                               0x005C 0x0260 0x0540 0x05 0x01
#define IMX95_PAD_GPIO_IO19__TPM6_CH2                                 0x005C 0x0260 0x0000 0x06 0x00
#define IMX95_PAD_GPIO_IO19__SAI3_TX_DATA_BIT0                        0x005C 0x0260 0x0000 0x07 0x00

#define IMX95_PAD_GPIO_IO20__GPIO2_IO_BIT20                           0x0060 0x0264 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO20__SAI3_RX_DATA_BIT0                        0x0060 0x0264 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO20__AONMIX_TOP_PDM_BIT_STREAM_BIT0           0x0060 0x0264 0x040C 0x02 0x02
#define IMX95_PAD_GPIO_IO20__LPSPI5_SOUT                              0x0060 0x0264 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO20__LPSPI4_SOUT                              0x0060 0x0264 0x0544 0x05 0x01
#define IMX95_PAD_GPIO_IO20__TPM3_CH1                                 0x0060 0x0264 0x0000 0x06 0x00
#define IMX95_PAD_GPIO_IO20__FLEXIO1_FLEXIO_BIT20                     0x0060 0x0264 0x04B8 0x07 0x00

#define IMX95_PAD_GPIO_IO21__GPIO2_IO_BIT21                           0x0064 0x0268 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO21__SAI3_TX_DATA_BIT0                        0x0064 0x0268 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO21__AONMIX_TOP_PDM_CLK                       0x0064 0x0268 0x0000 0x02 0x00
#define IMX95_PAD_GPIO_IO21__FLEXIO1_FLEXIO_BIT21                     0x0064 0x0268 0x04BC 0x03 0x00
#define IMX95_PAD_GPIO_IO21__LPSPI5_SCK                               0x0064 0x0268 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO21__LPSPI4_SCK                               0x0064 0x0268 0x053C 0x05 0x01
#define IMX95_PAD_GPIO_IO21__TPM4_CH1                                 0x0064 0x0268 0x0000 0x06 0x00
#define IMX95_PAD_GPIO_IO21__SAI3_RX_BCLK                             0x0064 0x0268 0x058C 0x07 0x01

#define IMX95_PAD_GPIO_IO22__GPIO2_IO_BIT22                           0x0068 0x026C 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO22__USDHC3_CLK                               0x0068 0x026C 0x05C8 0x01 0x00
#define IMX95_PAD_GPIO_IO22__SPDIF_IN                                 0x0068 0x026C 0x0454 0x02 0x02
#define IMX95_PAD_GPIO_IO22__CAN5_TX                                  0x0068 0x026C 0x0000 0x03 0x00
#define IMX95_PAD_GPIO_IO22__TPM5_CH1                                 0x0068 0x026C 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO22__TPM6_EXTCLK                              0x0068 0x026C 0x0000 0x05 0x00
#define IMX95_PAD_GPIO_IO22__LPI2C5_SDA                               0x0068 0x026C 0x0514 0x16 0x01
#define IMX95_PAD_GPIO_IO22__FLEXIO1_FLEXIO_BIT22                     0x0068 0x026C 0x04C0 0x07 0x00

#define IMX95_PAD_GPIO_IO23__GPIO2_IO_BIT23                           0x006C 0x0270 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO23__USDHC3_CMD                               0x006C 0x0270 0x05CC 0x01 0x00
#define IMX95_PAD_GPIO_IO23__SPDIF_OUT                                0x006C 0x0270 0x0000 0x02 0x00
#define IMX95_PAD_GPIO_IO23__CAN5_RX                                  0x006C 0x0270 0x0450 0x03 0x00
#define IMX95_PAD_GPIO_IO23__TPM6_CH1                                 0x006C 0x0270 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO23__LPI2C5_SCL                               0x006C 0x0270 0x0510 0x16 0x01
#define IMX95_PAD_GPIO_IO23__FLEXIO1_FLEXIO_BIT23                     0x006C 0x0270 0x04C4 0x07 0x00

#define IMX95_PAD_GPIO_IO24__GPIO2_IO_BIT24                           0x0070 0x0274 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO24__USDHC3_DATA0                             0x0070 0x0274 0x05D0 0x01 0x00
#define IMX95_PAD_GPIO_IO24__TPM3_CH3                                 0x0070 0x0274 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO24__JTAG_MUX_TDO                             0x0070 0x0274 0x0000 0x05 0x00
#define IMX95_PAD_GPIO_IO24__LPSPI6_PCS1                              0x0070 0x0274 0x0000 0x06 0x00
#define IMX95_PAD_GPIO_IO24__FLEXIO1_FLEXIO_BIT24                     0x0070 0x0274 0x04C8 0x07 0x00

#define IMX95_PAD_GPIO_IO25__GPIO2_IO_BIT25                           0x0074 0x0278 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO25__USDHC3_DATA1                             0x0074 0x0278 0x05D4 0x01 0x00
#define IMX95_PAD_GPIO_IO25__CAN2_TX                                  0x0074 0x0278 0x0000 0x02 0x00
#define IMX95_PAD_GPIO_IO25__TPM4_CH3                                 0x0074 0x0278 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO25__JTAG_MUX_TCK                             0x0074 0x0278 0x060C 0x05 0x01
#define IMX95_PAD_GPIO_IO25__LPSPI7_PCS1                              0x0074 0x0278 0x0000 0x06 0x00
#define IMX95_PAD_GPIO_IO25__FLEXIO1_FLEXIO_BIT25                     0x0074 0x0278 0x04CC 0x07 0x00

#define IMX95_PAD_GPIO_IO26__GPIO2_IO_BIT26                           0x0078 0x027C 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO26__USDHC3_DATA2                             0x0078 0x027C 0x05D8 0x01 0x00
#define IMX95_PAD_GPIO_IO26__AONMIX_TOP_PDM_BIT_STREAM_BIT1           0x0078 0x027C 0x0410 0x02 0x02
#define IMX95_PAD_GPIO_IO26__FLEXIO1_FLEXIO_BIT26                     0x0078 0x027C 0x0458 0x03 0x01
#define IMX95_PAD_GPIO_IO26__TPM5_CH3                                 0x0078 0x027C 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO26__JTAG_MUX_TDI                             0x0078 0x027C 0x0610 0x05 0x01
#define IMX95_PAD_GPIO_IO26__LPSPI8_PCS1                              0x0078 0x027C 0x0000 0x06 0x00
#define IMX95_PAD_GPIO_IO26__SAI3_TX_SYNC                             0x0078 0x027C 0x0000 0x07 0x00

#define IMX95_PAD_GPIO_IO27__GPIO2_IO_BIT27                           0x007C 0x0280 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO27__USDHC3_DATA3                             0x007C 0x0280 0x05DC 0x01 0x00
#define IMX95_PAD_GPIO_IO27__CAN2_RX                                  0x007C 0x0280 0x0444 0x02 0x02
#define IMX95_PAD_GPIO_IO27__TPM6_CH3                                 0x007C 0x0280 0x0000 0x04 0x00
#define IMX95_PAD_GPIO_IO27__JTAG_MUX_TMS                             0x007C 0x0280 0x0614 0x05 0x01
#define IMX95_PAD_GPIO_IO27__LPSPI5_PCS1                              0x007C 0x0280 0x0000 0x06 0x00
#define IMX95_PAD_GPIO_IO27__FLEXIO1_FLEXIO_BIT27                     0x007C 0x0280 0x045C 0x07 0x01

#define IMX95_PAD_GPIO_IO28__GPIO2_IO_BIT28                           0x0080 0x0284 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO28__LPI2C3_SDA                               0x0080 0x0284 0x0504 0x11 0x01
#define IMX95_PAD_GPIO_IO28__CAN3_TX                                  0x0080 0x0284 0x0000 0x02 0x00
#define IMX95_PAD_GPIO_IO28__FLEXIO1_FLEXIO_BIT28                     0x0080 0x0284 0x0000 0x07 0x00

#define IMX95_PAD_GPIO_IO29__GPIO2_IO_BIT29                           0x0084 0x0288 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO29__LPI2C3_SCL                               0x0084 0x0288 0x0500 0x11 0x01
#define IMX95_PAD_GPIO_IO29__CAN3_RX                                  0x0084 0x0288 0x0448 0x02 0x01
#define IMX95_PAD_GPIO_IO29__FLEXIO1_FLEXIO_BIT29                     0x0084 0x0288 0x0000 0x07 0x00

#define IMX95_PAD_GPIO_IO30__GPIO2_IO_BIT30                           0x0088 0x028C 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO30__LPI2C4_SDA                               0x0088 0x028C 0x050C 0x11 0x01
#define IMX95_PAD_GPIO_IO30__CAN5_TX                                  0x0088 0x028C 0x0000 0x02 0x00
#define IMX95_PAD_GPIO_IO30__FLEXIO1_FLEXIO_BIT30                     0x0088 0x028C 0x0460 0x07 0x01

#define IMX95_PAD_GPIO_IO31__GPIO2_IO_BIT31                           0x008C 0x0290 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO31__LPI2C4_SCL                               0x008C 0x0290 0x0508 0x11 0x01
#define IMX95_PAD_GPIO_IO31__CAN5_RX                                  0x008C 0x0290 0x0450 0x02 0x01
#define IMX95_PAD_GPIO_IO31__FLEXIO1_FLEXIO_BIT31                     0x008C 0x0290 0x0464 0x07 0x01

#define IMX95_PAD_GPIO_IO32__GPIO5_IO_BIT12                           0x0090 0x0294 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO32__HSIOMIX_TOP_PCIE1_CLKREQ_B               0x0090 0x0294 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO32__LPUART6_TX                               0x0090 0x0294 0x0580 0x02 0x00
#define IMX95_PAD_GPIO_IO32__LPSPI4_PCS2                              0x0090 0x0294 0x0538 0x04 0x00

#define IMX95_PAD_GPIO_IO33__GPIO5_IO_BIT13                           0x0094 0x0298 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO33__LPUART6_RX                               0x0094 0x0298 0x057C 0x02 0x00
#define IMX95_PAD_GPIO_IO33__LPSPI4_PCS1                              0x0094 0x0298 0x0534 0x04 0x00

#define IMX95_PAD_GPIO_IO34__GPIO5_IO_BIT14                           0x0098 0x029C 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO34__LPUART6_CTS_B                            0x0098 0x029C 0x0578 0x02 0x00
#define IMX95_PAD_GPIO_IO34__LPSPI4_PCS0                              0x0098 0x029C 0x0530 0x04 0x00

#define IMX95_PAD_GPIO_IO35__GPIO5_IO_BIT15                           0x009C 0x02A0 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO35__HSIOMIX_TOP_PCIE2_CLKREQ_B               0x009C 0x02A0 0x0000 0x01 0x00
#define IMX95_PAD_GPIO_IO35__LPUART6_RTS_B                            0x009C 0x02A0 0x0000 0x02 0x00
#define IMX95_PAD_GPIO_IO35__LPSPI4_SIN                               0x009C 0x02A0 0x0540 0x04 0x00

#define IMX95_PAD_GPIO_IO36__LPSPI4_SOUT                              0x00A0 0x02A4 0x0544 0x04 0x00
#define IMX95_PAD_GPIO_IO36__GPIO5_IO_BIT16                           0x00A0 0x02A4 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO36__LPUART7_TX                               0x00A0 0x02A4 0x0588 0x02 0x00

#define IMX95_PAD_GPIO_IO37__GPIO5_IO_BIT17                           0x00A4 0x02A8 0x0000 0x00 0x00
#define IMX95_PAD_GPIO_IO37__LPUART7_RX                               0x00A4 0x02A8 0x0584 0x02 0x00
#define IMX95_PAD_GPIO_IO37__LPSPI4_SCK                               0x00A4 0x02A8 0x053C 0x04 0x00

#define IMX95_PAD_CCM_CLKO1__CCMSRCGPCMIX_TOP_CLKO_1                  0x00A8 0x02AC 0x0000 0x00 0x00
#define IMX95_PAD_CCM_CLKO1__NETCMIX_TOP_NETC_TMR_1588_TRIG1          0x00A8 0x02AC 0x0434 0x01 0x00
#define IMX95_PAD_CCM_CLKO1__FLEXIO1_FLEXIO_BIT26                     0x00A8 0x02AC 0x0458 0x04 0x00
#define IMX95_PAD_CCM_CLKO1__GPIO3_IO_BIT26                           0x00A8 0x02AC 0x0000 0x05 0x00

#define IMX95_PAD_CCM_CLKO2__GPIO3_IO_BIT27                           0x00AC 0x02B0 0x0000 0x05 0x00
#define IMX95_PAD_CCM_CLKO2__CCMSRCGPCMIX_TOP_CLKO_2                  0x00AC 0x02B0 0x0000 0x00 0x00
#define IMX95_PAD_CCM_CLKO2__NETCMIX_TOP_NETC_TMR_1588_PP1            0x00AC 0x02B0 0x0000 0x01 0x00
#define IMX95_PAD_CCM_CLKO2__FLEXIO1_FLEXIO_BIT27                     0x00AC 0x02B0 0x045C 0x04 0x00

#define IMX95_PAD_CCM_CLKO3__CCMSRCGPCMIX_TOP_CLKO_3                  0x00B0 0x02B4 0x0000 0x00 0x00
#define IMX95_PAD_CCM_CLKO3__NETCMIX_TOP_NETC_TMR_1588_TRIG2          0x00B0 0x02B4 0x0438 0x01 0x00
#define IMX95_PAD_CCM_CLKO3__CAN3_TX                                  0x00B0 0x02B4 0x0000 0x02 0x00
#define IMX95_PAD_CCM_CLKO3__FLEXIO2_FLEXIO_BIT28                     0x00B0 0x02B4 0x0000 0x04 0x00
#define IMX95_PAD_CCM_CLKO3__GPIO4_IO_BIT28                           0x00B0 0x02B4 0x0000 0x05 0x00

#define IMX95_PAD_CCM_CLKO4__CCMSRCGPCMIX_TOP_CLKO_4                  0x00B4 0x02B8 0x0000 0x00 0x00
#define IMX95_PAD_CCM_CLKO4__NETCMIX_TOP_NETC_TMR_1588_PP2            0x00B4 0x02B8 0x0000 0x01 0x00
#define IMX95_PAD_CCM_CLKO4__CAN3_RX                                  0x00B4 0x02B8 0x0448 0x02 0x00
#define IMX95_PAD_CCM_CLKO4__FLEXIO2_FLEXIO_BIT29                     0x00B4 0x02B8 0x0000 0x04 0x00
#define IMX95_PAD_CCM_CLKO4__GPIO4_IO_BIT29                           0x00B4 0x02B8 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_MDC__NETCMIX_TOP_NETC_MDC                     0x00B8 0x02BC 0x0424 0x00 0x00
#define IMX95_PAD_ENET1_MDC__LPUART3_DCD_B                            0x00B8 0x02BC 0x0000 0x01 0x00
#define IMX95_PAD_ENET1_MDC__I3C2_SCL                                 0x00B8 0x02BC 0x04F8 0x02 0x00
#define IMX95_PAD_ENET1_MDC__HSIOMIX_TOP_USB1_OTG_ID                  0x00B8 0x02BC 0x0000 0x03 0x00
#define IMX95_PAD_ENET1_MDC__FLEXIO2_FLEXIO_BIT0                      0x00B8 0x02BC 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_MDC__GPIO4_IO_BIT0                            0x00B8 0x02BC 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_MDIO__NETCMIX_TOP_NETC_MDIO                   0x00BC 0x02C0 0x0428 0x00 0x00
#define IMX95_PAD_ENET1_MDIO__LPUART3_RIN_B                           0x00BC 0x02C0 0x0000 0x01 0x00
#define IMX95_PAD_ENET1_MDIO__I3C2_SDA                                0x00BC 0x02C0 0x04FC 0x02 0x00
#define IMX95_PAD_ENET1_MDIO__HSIOMIX_TOP_USB1_OTG_PWR                0x00BC 0x02C0 0x0000 0x03 0x00
#define IMX95_PAD_ENET1_MDIO__FLEXIO2_FLEXIO_BIT1                     0x00BC 0x02C0 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_MDIO__GPIO4_IO_BIT1                           0x00BC 0x02C0 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_TD3__NETCMIX_TOP_ETH0_RGMII_TD3               0x00C0 0x02C4 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_TD3__CAN2_TX                                  0x00C0 0x02C4 0x0000 0x02 0x00
#define IMX95_PAD_ENET1_TD3__HSIOMIX_TOP_USB2_OTG_ID                  0x00C0 0x02C4 0x0000 0x03 0x00
#define IMX95_PAD_ENET1_TD3__FLEXIO2_FLEXIO_BIT2                      0x00C0 0x02C4 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_TD3__GPIO4_IO_BIT2                            0x00C0 0x02C4 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_TD2__NETCMIX_TOP_ETH0_RGMII_TD2               0x00C4 0x02C8 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_TD2__NETCMIX_TOP_ETH0_RMII_REF50_CLK          0x00C4 0x02C8 0x0000 0x01 0x00
#define IMX95_PAD_ENET1_TD2__CAN2_RX                                  0x00C4 0x02C8 0x0444 0x02 0x01
#define IMX95_PAD_ENET1_TD2__HSIOMIX_TOP_USB2_OTG_OC                  0x00C4 0x02C8 0x0000 0x03 0x00
#define IMX95_PAD_ENET1_TD2__FLEXIO2_FLEXIO_BIT3                      0x00C4 0x02C8 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_TD2__GPIO4_IO_BIT3                            0x00C4 0x02C8 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_TD1__NETCMIX_TOP_ETH0_RGMII_TD1               0x00C8 0x02CC 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_TD1__LPUART3_RTS_B                            0x00C8 0x02CC 0x0000 0x01 0x00
#define IMX95_PAD_ENET1_TD1__I3C2_PUR                                 0x00C8 0x02CC 0x0000 0x02 0x00
#define IMX95_PAD_ENET1_TD1__HSIOMIX_TOP_USB1_OTG_OC                  0x00C8 0x02CC 0x0000 0x03 0x00
#define IMX95_PAD_ENET1_TD1__FLEXIO2_FLEXIO_BIT4                      0x00C8 0x02CC 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_TD1__GPIO4_IO_BIT4                            0x00C8 0x02CC 0x0000 0x05 0x00
#define IMX95_PAD_ENET1_TD1__I3C2_PUR_B                               0x00C8 0x02CC 0x0000 0x06 0x00
#define IMX95_PAD_ENET1_TD1__NETCMIX_TOP_ETH0_RMII_TXD1               0x00C8 0x02CC 0x0000 0x07 0x00

#define IMX95_PAD_ENET1_TD0__NETCMIX_TOP_ETH0_RGMII_TD0               0x00CC 0x02D0 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_TD0__LPUART3_TX                               0x00CC 0x02D0 0x055C 0x01 0x00
#define IMX95_PAD_ENET1_TD0__NETCMIX_TOP_ETH0_RMII_TXD0               0x00CC 0x02D0 0x0000 0x02 0x00
#define IMX95_PAD_ENET1_TD0__FLEXIO2_FLEXIO_BIT5                      0x00CC 0x02D0 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_TD0__GPIO4_IO_BIT5                            0x00CC 0x02D0 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_TX_CTL__NETCMIX_TOP_ETH0_RGMII_TX_CTL         0x00D0 0x02D4 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_TX_CTL__LPUART3_DTR_B                         0x00D0 0x02D4 0x0000 0x01 0x00
#define IMX95_PAD_ENET1_TX_CTL__NETCMIX_TOP_ETH0_RMII_TX_EN           0x00D0 0x02D4 0x0000 0x02 0x00
#define IMX95_PAD_ENET1_TX_CTL__FLEXIO2_FLEXIO_BIT6                   0x00D0 0x02D4 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_TX_CTL__GPIO4_IO_BIT6                         0x00D0 0x02D4 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_TXC__NETCMIX_TOP_ETH0_RGMII_TX_CLK            0x00D4 0x02D8 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_TXC__CCMSRCGPCMIX_TOP_ENET_CLK_ROOT           0x00D4 0x02D8 0x0000 0x01 0x00
#define IMX95_PAD_ENET1_TXC__FLEXIO2_FLEXIO_BIT7                      0x00D4 0x02D8 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_TXC__GPIO4_IO_BIT7                            0x00D4 0x02D8 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_RX_CTL__NETCMIX_TOP_ETH0_RGMII_RX_CTL         0x00D8 0x02DC 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_RX_CTL__LPUART3_DSR_B                         0x00D8 0x02DC 0x0000 0x01 0x00
#define IMX95_PAD_ENET1_RX_CTL__NETCMIX_TOP_ETH0_RMII_CRS_DV          0x00D8 0x02DC 0x0000 0x02 0x00
#define IMX95_PAD_ENET1_RX_CTL__HSIOMIX_TOP_USB2_OTG_PWR              0x00D8 0x02DC 0x0000 0x03 0x00
#define IMX95_PAD_ENET1_RX_CTL__FLEXIO2_FLEXIO_BIT8                   0x00D8 0x02DC 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_RX_CTL__GPIO4_IO_BIT8                         0x00D8 0x02DC 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_RXC__NETCMIX_TOP_ETH0_RGMII_RX_CLK            0x00DC 0x02E0 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_RXC__NETCMIX_TOP_ETH0_RMII_RX_ER              0x00DC 0x02E0 0x042C 0x01 0x00
#define IMX95_PAD_ENET1_RXC__FLEXIO2_FLEXIO_BIT9                      0x00DC 0x02E0 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_RXC__GPIO4_IO_BIT9                            0x00DC 0x02E0 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_RD0__NETCMIX_TOP_ETH0_RGMII_RD0               0x00E0 0x02E4 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_RD0__LPUART3_RX                               0x00E0 0x02E4 0x0558 0x01 0x00
#define IMX95_PAD_ENET1_RD0__NETCMIX_TOP_ETH0_RMII_RXD0               0x00E0 0x02E4 0x0000 0x02 0x00
#define IMX95_PAD_ENET1_RD0__FLEXIO2_FLEXIO_BIT10                     0x00E0 0x02E4 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_RD0__GPIO4_IO_BIT10                           0x00E0 0x02E4 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_RD1__NETCMIX_TOP_ETH0_RGMII_RD1               0x00E4 0x02E8 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_RD1__LPUART3_CTS_B                            0x00E4 0x02E8 0x0554 0x01 0x00
#define IMX95_PAD_ENET1_RD1__NETCMIX_TOP_ETH0_RMII_RXD1               0x00E4 0x02E8 0x0000 0x02 0x00
#define IMX95_PAD_ENET1_RD1__LPTMR2_ALT1                              0x00E4 0x02E8 0x0548 0x03 0x00
#define IMX95_PAD_ENET1_RD1__FLEXIO2_FLEXIO_BIT11                     0x00E4 0x02E8 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_RD1__GPIO4_IO_BIT11                           0x00E4 0x02E8 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_RD2__NETCMIX_TOP_ETH0_RGMII_RD2               0x00E8 0x02EC 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_RD2__NETCMIX_TOP_ETH0_RMII_RX_ER              0x00E8 0x02EC 0x042C 0x02 0x01
#define IMX95_PAD_ENET1_RD2__LPTMR2_ALT2                              0x00E8 0x02EC 0x054C 0x03 0x00
#define IMX95_PAD_ENET1_RD2__FLEXIO2_FLEXIO_BIT12                     0x00E8 0x02EC 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_RD2__GPIO4_IO_BIT12                           0x00E8 0x02EC 0x0000 0x05 0x00

#define IMX95_PAD_ENET1_RD3__NETCMIX_TOP_ETH0_RGMII_RD3               0x00EC 0x02F0 0x0000 0x00 0x00
#define IMX95_PAD_ENET1_RD3__LPTMR2_ALT3                              0x00EC 0x02F0 0x0550 0x03 0x00
#define IMX95_PAD_ENET1_RD3__FLEXIO2_FLEXIO_BIT13                     0x00EC 0x02F0 0x0000 0x04 0x00
#define IMX95_PAD_ENET1_RD3__GPIO4_IO_BIT13                           0x00EC 0x02F0 0x0000 0x05 0x00

#define IMX95_PAD_ENET2_MDC__NETCMIX_TOP_NETC_MDC                     0x00F0 0x02F4 0x0424 0x00 0x01
#define IMX95_PAD_ENET2_MDC__LPUART4_DCD_B                            0x00F0 0x02F4 0x0000 0x01 0x00
#define IMX95_PAD_ENET2_MDC__NETCMIX_TOP_SAI2_RX_SYNC                 0x00F0 0x02F4 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_MDC__FLEXIO2_FLEXIO_BIT14                     0x00F0 0x02F4 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_MDC__GPIO4_IO_BIT14                           0x00F0 0x02F4 0x0000 0x05 0x00

#define IMX95_PAD_ENET2_MDIO__NETCMIX_TOP_NETC_MDIO                   0x00F4 0x02F8 0x0428 0x00 0x01
#define IMX95_PAD_ENET2_MDIO__LPUART4_RIN_B                           0x00F4 0x02F8 0x0000 0x01 0x00
#define IMX95_PAD_ENET2_MDIO__NETCMIX_TOP_SAI2_RX_BCLK                0x00F4 0x02F8 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_MDIO__FLEXIO2_FLEXIO_BIT15                    0x00F4 0x02F8 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_MDIO__GPIO4_IO_BIT15                          0x00F4 0x02F8 0x0000 0x05 0x00

#define IMX95_PAD_ENET2_TD3__NETCMIX_TOP_SAI2_RX_DATA_BIT0            0x00F8 0x02FC 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_TD3__FLEXIO2_FLEXIO_BIT16                     0x00F8 0x02FC 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_TD3__GPIO4_IO_BIT16                           0x00F8 0x02FC 0x0000 0x05 0x00
#define IMX95_PAD_ENET2_TD3__NETCMIX_TOP_ETH1_RGMII_TD3               0x00F8 0x02FC 0x0000 0x00 0x00

#define IMX95_PAD_ENET2_TD2__NETCMIX_TOP_ETH1_RGMII_TD2               0x00FC 0x0300 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_TD2__NETCMIX_TOP_ETH1_RMII_REF50_CLK          0x00FC 0x0300 0x0000 0x01 0x00
#define IMX95_PAD_ENET2_TD2__NETCMIX_TOP_SAI2_RX_DATA_BIT1            0x00FC 0x0300 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_TD2__SAI4_TX_SYNC                             0x00FC 0x0300 0x05A4 0x03 0x00
#define IMX95_PAD_ENET2_TD2__FLEXIO2_FLEXIO_BIT17                     0x00FC 0x0300 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_TD2__GPIO4_IO_BIT17                           0x00FC 0x0300 0x0000 0x05 0x00

#define IMX95_PAD_ENET2_TD1__NETCMIX_TOP_ETH1_RGMII_TD1               0x0100 0x0304 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_TD1__LPUART4_RTS_B                            0x0100 0x0304 0x0000 0x01 0x00
#define IMX95_PAD_ENET2_TD1__NETCMIX_TOP_SAI2_RX_DATA_BIT2            0x0100 0x0304 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_TD1__SAI4_TX_BCLK                             0x0100 0x0304 0x05A0 0x03 0x00
#define IMX95_PAD_ENET2_TD1__FLEXIO2_FLEXIO_BIT18                     0x0100 0x0304 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_TD1__GPIO4_IO_BIT18                           0x0100 0x0304 0x0000 0x05 0x00
#define IMX95_PAD_ENET2_TD1__NETCMIX_TOP_ETH1_RMII_TXD1               0x0100 0x0304 0x0000 0x06 0x00

#define IMX95_PAD_ENET2_TD0__NETCMIX_TOP_ETH1_RGMII_TD0               0x0104 0x0308 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_TD0__LPUART4_TX                               0x0104 0x0308 0x0568 0x01 0x00
#define IMX95_PAD_ENET2_TD0__NETCMIX_TOP_SAI2_RX_DATA_BIT3            0x0104 0x0308 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_TD0__SAI4_TX_DATA_BIT0                        0x0104 0x0308 0x0000 0x03 0x00
#define IMX95_PAD_ENET2_TD0__FLEXIO2_FLEXIO_BIT19                     0x0104 0x0308 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_TD0__GPIO4_IO_BIT19                           0x0104 0x0308 0x0000 0x05 0x00
#define IMX95_PAD_ENET2_TD0__NETCMIX_TOP_ETH1_RMII_TXD0               0x0104 0x0308 0x0000 0x06 0x00

#define IMX95_PAD_ENET2_TX_CTL__NETCMIX_TOP_ETH1_RGMII_TX_CTL         0x0108 0x030C 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_TX_CTL__LPUART4_DTR_B                         0x0108 0x030C 0x0000 0x01 0x00
#define IMX95_PAD_ENET2_TX_CTL__NETCMIX_TOP_SAI2_TX_SYNC              0x0108 0x030C 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_TX_CTL__NETCMIX_TOP_ETH1_RMII_TX_EN           0x0108 0x030C 0x0000 0x03 0x00
#define IMX95_PAD_ENET2_TX_CTL__FLEXIO2_FLEXIO_BIT20                  0x0108 0x030C 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_TX_CTL__GPIO4_IO_BIT20                        0x0108 0x030C 0x0000 0x05 0x00

#define IMX95_PAD_ENET2_TXC__NETCMIX_TOP_ETH1_RGMII_TX_CLK            0x010C 0x0310 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_TXC__CCMSRCGPCMIX_TOP_ENET_CLK_ROOT           0x010C 0x0310 0x0000 0x01 0x00
#define IMX95_PAD_ENET2_TXC__NETCMIX_TOP_SAI2_TX_BCLK                 0x010C 0x0310 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_TXC__FLEXIO2_FLEXIO_BIT21                     0x010C 0x0310 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_TXC__GPIO4_IO_BIT21                           0x010C 0x0310 0x0000 0x05 0x00

#define IMX95_PAD_ENET2_RX_CTL__NETCMIX_TOP_ETH1_RGMII_RX_CTL         0x0110 0x0314 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_RX_CTL__LPUART4_DSR_B                         0x0110 0x0314 0x0000 0x01 0x00
#define IMX95_PAD_ENET2_RX_CTL__NETCMIX_TOP_SAI2_TX_DATA_BIT0         0x0110 0x0314 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_RX_CTL__FLEXIO2_FLEXIO_BIT22                  0x0110 0x0314 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_RX_CTL__GPIO4_IO_BIT22                        0x0110 0x0314 0x0000 0x05 0x00
#define IMX95_PAD_ENET2_RX_CTL__NETCMIX_TOP_ETH1_RMII_CRS_DV          0x0110 0x0314 0x0000 0x06 0x00

#define IMX95_PAD_ENET2_RXC__NETCMIX_TOP_ETH1_RGMII_RX_CLK            0x0114 0x0318 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_RXC__NETCMIX_TOP_ETH1_RMII_RX_ER              0x0114 0x0318 0x0430 0x01 0x00
#define IMX95_PAD_ENET2_RXC__NETCMIX_TOP_SAI2_TX_DATA_BIT1            0x0114 0x0318 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_RXC__SAI4_RX_SYNC                             0x0114 0x0318 0x059C 0x03 0x00
#define IMX95_PAD_ENET2_RXC__FLEXIO2_FLEXIO_BIT23                     0x0114 0x0318 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_RXC__GPIO4_IO_BIT23                           0x0114 0x0318 0x0000 0x05 0x00

#define IMX95_PAD_ENET2_RD0__NETCMIX_TOP_ETH1_RGMII_RD0               0x0118 0x031C 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_RD0__LPUART4_RX                               0x0118 0x031C 0x0564 0x01 0x00
#define IMX95_PAD_ENET2_RD0__NETCMIX_TOP_SAI2_TX_DATA_BIT2            0x0118 0x031C 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_RD0__SAI4_RX_BCLK                             0x0118 0x031C 0x0594 0x03 0x00
#define IMX95_PAD_ENET2_RD0__FLEXIO2_FLEXIO_BIT24                     0x0118 0x031C 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_RD0__GPIO4_IO_BIT24                           0x0118 0x031C 0x0000 0x05 0x00
#define IMX95_PAD_ENET2_RD0__NETCMIX_TOP_ETH1_RMII_RXD0               0x0118 0x031C 0x0000 0x06 0x00

#define IMX95_PAD_ENET2_RD1__NETCMIX_TOP_ETH1_RGMII_RD1               0x011C 0x0320 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_RD1__SPDIF_IN                                 0x011C 0x0320 0x0454 0x01 0x00
#define IMX95_PAD_ENET2_RD1__NETCMIX_TOP_SAI2_TX_DATA_BIT3            0x011C 0x0320 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_RD1__SAI4_RX_DATA_BIT0                        0x011C 0x0320 0x0598 0x03 0x00
#define IMX95_PAD_ENET2_RD1__FLEXIO2_FLEXIO_BIT25                     0x011C 0x0320 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_RD1__GPIO4_IO_BIT25                           0x011C 0x0320 0x0000 0x05 0x00
#define IMX95_PAD_ENET2_RD1__NETCMIX_TOP_ETH1_RMII_RXD1               0x011C 0x0320 0x0000 0x06 0x00

#define IMX95_PAD_ENET2_RD2__NETCMIX_TOP_ETH1_RGMII_RD2               0x0120 0x0324 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_RD2__LPUART4_CTS_B                            0x0120 0x0324 0x0560 0x01 0x00
#define IMX95_PAD_ENET2_RD2__NETCMIX_TOP_SAI2_MCLK                    0x0120 0x0324 0x0000 0x02 0x00
#define IMX95_PAD_ENET2_RD2__NETCMIX_TOP_MQS2_RIGHT                   0x0120 0x0324 0x0000 0x03 0x00
#define IMX95_PAD_ENET2_RD2__FLEXIO2_FLEXIO_BIT26                     0x0120 0x0324 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_RD2__GPIO4_IO_BIT26                           0x0120 0x0324 0x0000 0x05 0x00
#define IMX95_PAD_ENET2_RD2__NETCMIX_TOP_ETH1_RMII_RX_ER              0x0120 0x0324 0x0430 0x06 0x01

#define IMX95_PAD_ENET2_RD3__NETCMIX_TOP_ETH1_RGMII_RD3               0x0124 0x0328 0x0000 0x00 0x00
#define IMX95_PAD_ENET2_RD3__SPDIF_OUT                                0x0124 0x0328 0x0000 0x01 0x00
#define IMX95_PAD_ENET2_RD3__SPDIF_IN                                 0x0124 0x0328 0x0454 0x02 0x01
#define IMX95_PAD_ENET2_RD3__NETCMIX_TOP_MQS2_LEFT                    0x0124 0x0328 0x0000 0x03 0x00
#define IMX95_PAD_ENET2_RD3__FLEXIO2_FLEXIO_BIT27                     0x0124 0x0328 0x0000 0x04 0x00
#define IMX95_PAD_ENET2_RD3__GPIO4_IO_BIT27                           0x0124 0x0328 0x0000 0x05 0x00

#define IMX95_PAD_SD1_CLK__FLEXIO1_FLEXIO_BIT8                        0x0128 0x032C 0x0488 0x04 0x01
#define IMX95_PAD_SD1_CLK__GPIO3_IO_BIT8                              0x0128 0x032C 0x0000 0x05 0x00
#define IMX95_PAD_SD1_CLK__USDHC1_CLK                                 0x0128 0x032C 0x0000 0x00 0x00

#define IMX95_PAD_SD1_CMD__USDHC1_CMD                                 0x012C 0x0330 0x0000 0x00 0x00
#define IMX95_PAD_SD1_CMD__FLEXIO1_FLEXIO_BIT9                        0x012C 0x0330 0x048C 0x04 0x01
#define IMX95_PAD_SD1_CMD__GPIO3_IO_BIT9                              0x012C 0x0330 0x0000 0x05 0x00

#define IMX95_PAD_SD1_DATA0__USDHC1_DATA0                             0x0130 0x0334 0x0000 0x00 0x00
#define IMX95_PAD_SD1_DATA0__FLEXIO1_FLEXIO_BIT10                     0x0130 0x0334 0x0490 0x04 0x01
#define IMX95_PAD_SD1_DATA0__GPIO3_IO_BIT10                           0x0130 0x0334 0x0000 0x05 0x00

#define IMX95_PAD_SD1_DATA1__USDHC1_DATA1                             0x0134 0x0338 0x0000 0x00 0x00
#define IMX95_PAD_SD1_DATA1__FLEXIO1_FLEXIO_BIT11                     0x0134 0x0338 0x0494 0x04 0x01
#define IMX95_PAD_SD1_DATA1__GPIO3_IO_BIT11                           0x0134 0x0338 0x0000 0x05 0x00

#define IMX95_PAD_SD1_DATA2__USDHC1_DATA2                             0x0138 0x033C 0x0000 0x00 0x00
#define IMX95_PAD_SD1_DATA2__FLEXIO1_FLEXIO_BIT12                     0x0138 0x033C 0x0498 0x04 0x01
#define IMX95_PAD_SD1_DATA2__GPIO3_IO_BIT12                           0x0138 0x033C 0x0000 0x05 0x00
#define IMX95_PAD_SD1_DATA2__CCMSRCGPCMIX_TOP_PMIC_READY              0x0138 0x033C 0x0000 0x06 0x00

#define IMX95_PAD_SD1_DATA3__USDHC1_DATA3                             0x013C 0x0340 0x0000 0x00 0x00
#define IMX95_PAD_SD1_DATA3__FLEXSPI1_A_SS1_B                         0x013C 0x0340 0x0000 0x01 0x00
#define IMX95_PAD_SD1_DATA3__FLEXIO1_FLEXIO_BIT13                     0x013C 0x0340 0x049C 0x04 0x01
#define IMX95_PAD_SD1_DATA3__GPIO3_IO_BIT13                           0x013C 0x0340 0x0000 0x05 0x00

#define IMX95_PAD_SD1_DATA4__USDHC1_DATA4                             0x0140 0x0344 0x0000 0x00 0x00
#define IMX95_PAD_SD1_DATA4__FLEXSPI1_A_DATA_BIT4                     0x0140 0x0344 0x04E4 0x01 0x00
#define IMX95_PAD_SD1_DATA4__FLEXIO1_FLEXIO_BIT14                     0x0140 0x0344 0x04A0 0x04 0x01
#define IMX95_PAD_SD1_DATA4__GPIO3_IO_BIT14                           0x0140 0x0344 0x0000 0x05 0x00
#define IMX95_PAD_SD1_DATA4__XSPI_DATA_BIT4                           0x0140 0x0344 0x05FC 0x06 0x00

#define IMX95_PAD_SD1_DATA5__USDHC1_DATA5                             0x0144 0x0348 0x0000 0x00 0x00
#define IMX95_PAD_SD1_DATA5__FLEXSPI1_A_DATA_BIT5                     0x0144 0x0348 0x04E8 0x01 0x00
#define IMX95_PAD_SD1_DATA5__USDHC1_RESET_B                           0x0144 0x0348 0x0000 0x02 0x00
#define IMX95_PAD_SD1_DATA5__FLEXIO1_FLEXIO_BIT15                     0x0144 0x0348 0x04A4 0x04 0x01
#define IMX95_PAD_SD1_DATA5__GPIO3_IO_BIT15                           0x0144 0x0348 0x0000 0x05 0x00
#define IMX95_PAD_SD1_DATA5__XSPI_DATA_BIT5                           0x0144 0x0348 0x0600 0x06 0x00

#define IMX95_PAD_SD1_DATA6__USDHC1_DATA6                             0x0148 0x034C 0x0000 0x00 0x00
#define IMX95_PAD_SD1_DATA6__FLEXSPI1_A_DATA_BIT6                     0x0148 0x034C 0x04EC 0x01 0x00
#define IMX95_PAD_SD1_DATA6__USDHC1_CD_B                              0x0148 0x034C 0x0000 0x02 0x00
#define IMX95_PAD_SD1_DATA6__FLEXIO1_FLEXIO_BIT16                     0x0148 0x034C 0x04A8 0x04 0x01
#define IMX95_PAD_SD1_DATA6__GPIO3_IO_BIT16                           0x0148 0x034C 0x0000 0x05 0x00
#define IMX95_PAD_SD1_DATA6__XSPI_DATA_BIT6                           0x0148 0x034C 0x0604 0x06 0x00

#define IMX95_PAD_SD1_DATA7__USDHC1_DATA7                             0x014C 0x0350 0x0000 0x00 0x00
#define IMX95_PAD_SD1_DATA7__FLEXSPI1_A_DATA_BIT7                     0x014C 0x0350 0x04F0 0x01 0x00
#define IMX95_PAD_SD1_DATA7__USDHC1_WP                                0x014C 0x0350 0x0000 0x02 0x00
#define IMX95_PAD_SD1_DATA7__FLEXIO1_FLEXIO_BIT17                     0x014C 0x0350 0x04AC 0x04 0x01
#define IMX95_PAD_SD1_DATA7__GPIO3_IO_BIT17                           0x014C 0x0350 0x0000 0x05 0x00
#define IMX95_PAD_SD1_DATA7__XSPI_DATA_BIT7                           0x014C 0x0350 0x0608 0x06 0x00

#define IMX95_PAD_SD1_STROBE__USDHC1_STROBE                           0x0150 0x0354 0x0000 0x00 0x00
#define IMX95_PAD_SD1_STROBE__FLEXSPI1_A_DQS                          0x0150 0x0354 0x04D0 0x01 0x00
#define IMX95_PAD_SD1_STROBE__FLEXIO1_FLEXIO_BIT18                    0x0150 0x0354 0x04B0 0x04 0x01
#define IMX95_PAD_SD1_STROBE__GPIO3_IO_BIT18                          0x0150 0x0354 0x0000 0x05 0x00
#define IMX95_PAD_SD1_STROBE__XSPI_DQS                                0x0150 0x0354 0x05E4 0x06 0x00

#define IMX95_PAD_SD2_VSELECT__USDHC2_VSELECT                         0x0154 0x0358 0x0000 0x00 0x00
#define IMX95_PAD_SD2_VSELECT__USDHC2_WP                              0x0154 0x0358 0x0000 0x01 0x00
#define IMX95_PAD_SD2_VSELECT__LPTMR2_ALT3                            0x0154 0x0358 0x0550 0x02 0x01
#define IMX95_PAD_SD2_VSELECT__FLEXIO1_FLEXIO_BIT19                   0x0154 0x0358 0x04B4 0x04 0x01
#define IMX95_PAD_SD2_VSELECT__GPIO3_IO_BIT19                         0x0154 0x0358 0x0000 0x05 0x00
#define IMX95_PAD_SD2_VSELECT__CCMSRCGPCMIX_TOP_EXT_CLK1              0x0154 0x0358 0x0420 0x06 0x01

#define IMX95_PAD_SD3_CLK__USDHC3_CLK                                 0x0158 0x035C 0x05C8 0x00 0x01
#define IMX95_PAD_SD3_CLK__FLEXSPI1_A_SCLK                            0x0158 0x035C 0x04F4 0x01 0x00
#define IMX95_PAD_SD3_CLK__SAI5_TX_DATA_BIT1                          0x0158 0x035C 0x0000 0x02 0x00
#define IMX95_PAD_SD3_CLK__SAI5_RX_DATA_BIT0                          0x0158 0x035C 0x05AC 0x03 0x00
#define IMX95_PAD_SD3_CLK__FLEXIO1_FLEXIO_BIT20                       0x0158 0x035C 0x04B8 0x04 0x01
#define IMX95_PAD_SD3_CLK__GPIO3_IO_BIT20                             0x0158 0x035C 0x0000 0x05 0x00
#define IMX95_PAD_SD3_CLK__XSPI_CLK                                   0x0158 0x035C 0x05E8 0x06 0x00

#define IMX95_PAD_SD3_CMD__USDHC3_CMD                                 0x015C 0x0360 0x05CC 0x00 0x01
#define IMX95_PAD_SD3_CMD__FLEXSPI1_A_SS0_B                           0x015C 0x0360 0x0000 0x01 0x00
#define IMX95_PAD_SD3_CMD__SAI5_TX_DATA_BIT2                          0x015C 0x0360 0x0000 0x02 0x00
#define IMX95_PAD_SD3_CMD__SAI5_RX_SYNC                               0x015C 0x0360 0x05BC 0x03 0x00
#define IMX95_PAD_SD3_CMD__FLEXIO1_FLEXIO_BIT21                       0x015C 0x0360 0x04BC 0x04 0x01
#define IMX95_PAD_SD3_CMD__GPIO3_IO_BIT21                             0x015C 0x0360 0x0000 0x05 0x00
#define IMX95_PAD_SD3_CMD__XSPI_CS                                    0x015C 0x0360 0x05E0 0x06 0x00

#define IMX95_PAD_SD3_DATA0__USDHC3_DATA0                             0x0160 0x0364 0x05D0 0x00 0x01
#define IMX95_PAD_SD3_DATA0__FLEXSPI1_A_DATA_BIT0                     0x0160 0x0364 0x04D4 0x01 0x00
#define IMX95_PAD_SD3_DATA0__SAI5_TX_DATA_BIT3                        0x0160 0x0364 0x0000 0x02 0x00
#define IMX95_PAD_SD3_DATA0__SAI5_RX_BCLK                             0x0160 0x0364 0x05A8 0x03 0x00
#define IMX95_PAD_SD3_DATA0__FLEXIO1_FLEXIO_BIT22                     0x0160 0x0364 0x04C0 0x04 0x01
#define IMX95_PAD_SD3_DATA0__GPIO3_IO_BIT22                           0x0160 0x0364 0x0000 0x05 0x00
#define IMX95_PAD_SD3_DATA0__XSPI_DATA_BIT0                           0x0160 0x0364 0x05EC 0x06 0x00

#define IMX95_PAD_SD3_DATA1__USDHC3_DATA1                             0x0164 0x0368 0x05D4 0x00 0x01
#define IMX95_PAD_SD3_DATA1__FLEXSPI1_A_DATA_BIT1                     0x0164 0x0368 0x04D8 0x01 0x00
#define IMX95_PAD_SD3_DATA1__SAI5_RX_DATA_BIT1                        0x0164 0x0368 0x05B0 0x02 0x00
#define IMX95_PAD_SD3_DATA1__SAI5_TX_DATA_BIT0                        0x0164 0x0368 0x0000 0x03 0x00
#define IMX95_PAD_SD3_DATA1__FLEXIO1_FLEXIO_BIT23                     0x0164 0x0368 0x04C4 0x04 0x01
#define IMX95_PAD_SD3_DATA1__GPIO3_IO_BIT23                           0x0164 0x0368 0x0000 0x05 0x00
#define IMX95_PAD_SD3_DATA1__XSPI_DATA_BIT1                           0x0164 0x0368 0x05F0 0x06 0x00

#define IMX95_PAD_SD3_DATA2__USDHC3_DATA2                             0x0168 0x036C 0x05D8 0x00 0x01
#define IMX95_PAD_SD3_DATA2__FLEXSPI1_A_DATA_BIT2                     0x0168 0x036C 0x04DC 0x01 0x00
#define IMX95_PAD_SD3_DATA2__SAI5_RX_DATA_BIT2                        0x0168 0x036C 0x05B4 0x02 0x00
#define IMX95_PAD_SD3_DATA2__SAI5_TX_SYNC                             0x0168 0x036C 0x05C4 0x03 0x00
#define IMX95_PAD_SD3_DATA2__FLEXIO1_FLEXIO_BIT24                     0x0168 0x036C 0x04C8 0x04 0x01
#define IMX95_PAD_SD3_DATA2__GPIO3_IO_BIT24                           0x0168 0x036C 0x0000 0x05 0x00
#define IMX95_PAD_SD3_DATA2__XSPI_DATA_BIT2                           0x0168 0x036C 0x05F4 0x06 0x00

#define IMX95_PAD_SD3_DATA3__USDHC3_DATA3                             0x016C 0x0370 0x05DC 0x00 0x01
#define IMX95_PAD_SD3_DATA3__FLEXSPI1_A_DATA_BIT3                     0x016C 0x0370 0x04E0 0x01 0x00
#define IMX95_PAD_SD3_DATA3__SAI5_RX_DATA_BIT3                        0x016C 0x0370 0x05B8 0x02 0x00
#define IMX95_PAD_SD3_DATA3__SAI5_TX_BCLK                             0x016C 0x0370 0x05C0 0x03 0x00
#define IMX95_PAD_SD3_DATA3__FLEXIO1_FLEXIO_BIT25                     0x016C 0x0370 0x04CC 0x04 0x01
#define IMX95_PAD_SD3_DATA3__GPIO3_IO_BIT25                           0x016C 0x0370 0x0000 0x05 0x00
#define IMX95_PAD_SD3_DATA3__XSPI_DATA_BIT3                           0x016C 0x0370 0x05F8 0x06 0x00

#define IMX95_PAD_XSPI1_DATA0__FLEXSPI1_A_DATA_BIT0                   0x0170 0x0374 0x04D4 0x00 0x01
#define IMX95_PAD_XSPI1_DATA0__NETCMIX_TOP_SAI2_TX_DATA_BIT4          0x0170 0x0374 0x0000 0x01 0x00
#define IMX95_PAD_XSPI1_DATA0__SAI4_TX_BCLK                           0x0170 0x0374 0x05A0 0x02 0x01
#define IMX95_PAD_XSPI1_DATA0__SAI4_RX_DATA_BIT1                      0x0170 0x0374 0x0000 0x03 0x00
#define IMX95_PAD_XSPI1_DATA0__XSPI_DATA_BIT0                         0x0170 0x0374 0x05EC 0x04 0x01
#define IMX95_PAD_XSPI1_DATA0__GPIO5_IO_BIT0                          0x0170 0x0374 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_DATA1__FLEXSPI1_A_DATA_BIT1                   0x0174 0x0378 0x04D8 0x00 0x01
#define IMX95_PAD_XSPI1_DATA1__NETCMIX_TOP_SAI2_TX_DATA_BIT5          0x0174 0x0378 0x0000 0x01 0x00
#define IMX95_PAD_XSPI1_DATA1__SAI4_TX_SYNC                           0x0174 0x0378 0x05A4 0x02 0x01
#define IMX95_PAD_XSPI1_DATA1__SAI4_TX_DATA_BIT1                      0x0174 0x0378 0x0000 0x03 0x00
#define IMX95_PAD_XSPI1_DATA1__XSPI_DATA_BIT1                         0x0174 0x0378 0x05F0 0x04 0x01
#define IMX95_PAD_XSPI1_DATA1__GPIO5_IO_BIT1                          0x0174 0x0378 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_DATA2__FLEXSPI1_A_DATA_BIT2                   0x0178 0x037C 0x04DC 0x00 0x01
#define IMX95_PAD_XSPI1_DATA2__NETCMIX_TOP_SAI2_TX_DATA_BIT6          0x0178 0x037C 0x0000 0x01 0x00
#define IMX95_PAD_XSPI1_DATA2__SAI4_TX_DATA_BIT0                      0x0178 0x037C 0x0000 0x02 0x00
#define IMX95_PAD_XSPI1_DATA2__XSPI_DATA_BIT2                         0x0178 0x037C 0x05F4 0x04 0x01
#define IMX95_PAD_XSPI1_DATA2__GPIO5_IO_BIT2                          0x0178 0x037C 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_DATA3__FLEXSPI1_A_DATA_BIT3                   0x017C 0x0380 0x04E0 0x00 0x01
#define IMX95_PAD_XSPI1_DATA3__NETCMIX_TOP_SAI2_TX_DATA_BIT7          0x017C 0x0380 0x0000 0x01 0x00
#define IMX95_PAD_XSPI1_DATA3__SAI4_RX_DATA_BIT0                      0x017C 0x0380 0x0598 0x02 0x01
#define IMX95_PAD_XSPI1_DATA3__XSPI_DATA_BIT3                         0x017C 0x0380 0x05F8 0x04 0x01
#define IMX95_PAD_XSPI1_DATA3__GPIO5_IO_BIT3                          0x017C 0x0380 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_DATA4__FLEXSPI1_A_DATA_BIT4                   0x0180 0x0384 0x04E4 0x00 0x01
#define IMX95_PAD_XSPI1_DATA4__SAI5_TX_DATA_BIT0                      0x0180 0x0384 0x0000 0x01 0x00
#define IMX95_PAD_XSPI1_DATA4__SAI5_RX_DATA_BIT1                      0x0180 0x0384 0x05B0 0x02 0x01
#define IMX95_PAD_XSPI1_DATA4__XSPI_DATA_BIT4                         0x0180 0x0384 0x05FC 0x04 0x01
#define IMX95_PAD_XSPI1_DATA4__GPIO5_IO_BIT4                          0x0180 0x0384 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_DATA5__FLEXSPI1_A_DATA_BIT5                   0x0184 0x0388 0x04E8 0x00 0x01
#define IMX95_PAD_XSPI1_DATA5__SAI5_TX_SYNC                           0x0184 0x0388 0x05C4 0x01 0x01
#define IMX95_PAD_XSPI1_DATA5__SAI5_RX_DATA_BIT2                      0x0184 0x0388 0x05B4 0x02 0x01
#define IMX95_PAD_XSPI1_DATA5__NETCMIX_TOP_SAI2_RX_DATA_BIT6          0x0184 0x0388 0x043C 0x03 0x00
#define IMX95_PAD_XSPI1_DATA5__XSPI_DATA_BIT5                         0x0184 0x0388 0x0600 0x04 0x01
#define IMX95_PAD_XSPI1_DATA5__GPIO5_IO_BIT5                          0x0184 0x0388 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_DATA6__FLEXSPI1_A_DATA_BIT6                   0x0188 0x038C 0x04EC 0x00 0x01
#define IMX95_PAD_XSPI1_DATA6__SAI5_TX_BCLK                           0x0188 0x038C 0x05C0 0x01 0x01
#define IMX95_PAD_XSPI1_DATA6__SAI5_RX_DATA_BIT3                      0x0188 0x038C 0x05B8 0x02 0x01
#define IMX95_PAD_XSPI1_DATA6__NETCMIX_TOP_SAI2_RX_DATA_BIT7          0x0188 0x038C 0x0440 0x03 0x00
#define IMX95_PAD_XSPI1_DATA6__XSPI_DATA_BIT6                         0x0188 0x038C 0x0604 0x04 0x01
#define IMX95_PAD_XSPI1_DATA6__GPIO5_IO_BIT6                          0x0188 0x038C 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_DATA7__FLEXSPI1_A_DATA_BIT7                   0x018C 0x0390 0x04F0 0x00 0x01
#define IMX95_PAD_XSPI1_DATA7__SAI5_RX_DATA_BIT0                      0x018C 0x0390 0x05AC 0x01 0x01
#define IMX95_PAD_XSPI1_DATA7__SAI5_TX_DATA_BIT1                      0x018C 0x0390 0x0000 0x02 0x00
#define IMX95_PAD_XSPI1_DATA7__XSPI_DATA_BIT7                         0x018C 0x0390 0x0608 0x04 0x01
#define IMX95_PAD_XSPI1_DATA7__GPIO5_IO_BIT7                          0x018C 0x0390 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_DQS__FLEXSPI1_A_DQS                           0x0190 0x0394 0x04D0 0x00 0x01
#define IMX95_PAD_XSPI1_DQS__SAI5_RX_SYNC                             0x0190 0x0394 0x05BC 0x01 0x01
#define IMX95_PAD_XSPI1_DQS__SAI5_TX_DATA_BIT2                        0x0190 0x0394 0x0000 0x02 0x00
#define IMX95_PAD_XSPI1_DQS__NETCMIX_TOP_SAI2_RX_DATA_BIT6            0x0190 0x0394 0x043C 0x03 0x01
#define IMX95_PAD_XSPI1_DQS__XSPI_DQS                                 0x0190 0x0394 0x05E4 0x04 0x01
#define IMX95_PAD_XSPI1_DQS__GPIO5_IO_BIT8                            0x0190 0x0394 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_SCLK__FLEXSPI1_A_SCLK                         0x0194 0x0398 0x04F4 0x00 0x01
#define IMX95_PAD_XSPI1_SCLK__NETCMIX_TOP_SAI2_RX_DATA_BIT4           0x0194 0x0398 0x0000 0x01 0x00
#define IMX95_PAD_XSPI1_SCLK__SAI4_RX_SYNC                            0x0194 0x0398 0x059C 0x02 0x01
#define IMX95_PAD_XSPI1_SCLK__EARC_DC_HPD_IN                          0x0194 0x0398 0x0000 0x03 0x00
#define IMX95_PAD_XSPI1_SCLK__XSPI_CLK                                0x0194 0x0398 0x05E8 0x04 0x01
#define IMX95_PAD_XSPI1_SCLK__GPIO5_IO_BIT9                           0x0194 0x0398 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_SS0_B__FLEXSPI1_A_SS0_B                       0x0198 0x039C 0x0000 0x00 0x00
#define IMX95_PAD_XSPI1_SS0_B__NETCMIX_TOP_SAI2_RX_DATA_BIT5          0x0198 0x039C 0x0000 0x01 0x00
#define IMX95_PAD_XSPI1_SS0_B__SAI4_RX_BCLK                           0x0198 0x039C 0x0594 0x02 0x01
#define IMX95_PAD_XSPI1_SS0_B__EARC_CEC_OUT                           0x0198 0x039C 0x0000 0x03 0x00
#define IMX95_PAD_XSPI1_SS0_B__XSPI_CS                                0x0198 0x039C 0x05E0 0x04 0x01
#define IMX95_PAD_XSPI1_SS0_B__GPIO5_IO_BIT10                         0x0198 0x039C 0x0000 0x05 0x00

#define IMX95_PAD_XSPI1_SS1_B__FLEXSPI1_A_SS1_B                       0x019C 0x03A0 0x0000 0x00 0x00
#define IMX95_PAD_XSPI1_SS1_B__SAI5_RX_BCLK                           0x019C 0x03A0 0x05A8 0x01 0x01
#define IMX95_PAD_XSPI1_SS1_B__SAI5_TX_DATA_BIT3                      0x019C 0x03A0 0x0000 0x02 0x00
#define IMX95_PAD_XSPI1_SS1_B__NETCMIX_TOP_SAI2_RX_DATA_BIT7          0x019C 0x03A0 0x0440 0x03 0x01
#define IMX95_PAD_XSPI1_SS1_B__GPIO5_IO_BIT11                         0x019C 0x03A0 0x0000 0x05 0x00

#define IMX95_PAD_SD2_CD_B__USDHC2_CD_B                               0x01A0 0x03A4 0x0000 0x00 0x00
#define IMX95_PAD_SD2_CD_B__NETCMIX_TOP_NETC_TMR_1588_TRIG1           0x01A0 0x03A4 0x0434 0x01 0x01
#define IMX95_PAD_SD2_CD_B__I3C2_SCL                                  0x01A0 0x03A4 0x04F8 0x02 0x01
#define IMX95_PAD_SD2_CD_B__FLEXIO1_FLEXIO_BIT0                       0x01A0 0x03A4 0x0468 0x04 0x01
#define IMX95_PAD_SD2_CD_B__GPIO3_IO_BIT0                             0x01A0 0x03A4 0x0000 0x05 0x00

#define IMX95_PAD_SD2_CLK__USDHC2_CLK                                 0x01A4 0x03A8 0x0000 0x00 0x00
#define IMX95_PAD_SD2_CLK__NETCMIX_TOP_NETC_TMR_1588_PP1              0x01A4 0x03A8 0x0000 0x01 0x00
#define IMX95_PAD_SD2_CLK__I3C2_SDA                                   0x01A4 0x03A8 0x04FC 0x02 0x01
#define IMX95_PAD_SD2_CLK__FLEXIO1_FLEXIO_BIT1                        0x01A4 0x03A8 0x046C 0x04 0x01
#define IMX95_PAD_SD2_CLK__GPIO3_IO_BIT1                              0x01A4 0x03A8 0x0000 0x05 0x00
#define IMX95_PAD_SD2_CLK__CCMSRCGPCMIX_TOP_OBSERVE_0                 0x01A4 0x03A8 0x0000 0x06 0x00

#define IMX95_PAD_SD2_CMD__USDHC2_CMD                                 0x01A8 0x03AC 0x0000 0x00 0x00
#define IMX95_PAD_SD2_CMD__NETCMIX_TOP_NETC_TMR_1588_TRIG2            0x01A8 0x03AC 0x0438 0x01 0x01
#define IMX95_PAD_SD2_CMD__I3C2_PUR                                   0x01A8 0x03AC 0x0000 0x02 0x00
#define IMX95_PAD_SD2_CMD__I3C2_PUR_B                                 0x01A8 0x03AC 0x0000 0x03 0x00
#define IMX95_PAD_SD2_CMD__FLEXIO1_FLEXIO_BIT2                        0x01A8 0x03AC 0x0470 0x04 0x01
#define IMX95_PAD_SD2_CMD__GPIO3_IO_BIT2                              0x01A8 0x03AC 0x0000 0x05 0x00
#define IMX95_PAD_SD2_CMD__CCMSRCGPCMIX_TOP_OBSERVE_1                 0x01A8 0x03AC 0x0000 0x06 0x00

#define IMX95_PAD_SD2_DATA0__USDHC2_DATA0                             0x01AC 0x03B0 0x0000 0x00 0x00
#define IMX95_PAD_SD2_DATA0__NETCMIX_TOP_NETC_TMR_1588_PP2            0x01AC 0x03B0 0x0000 0x01 0x00
#define IMX95_PAD_SD2_DATA0__CAN2_TX                                  0x01AC 0x03B0 0x0000 0x02 0x00
#define IMX95_PAD_SD2_DATA0__FLEXIO1_FLEXIO_BIT3                      0x01AC 0x03B0 0x0474 0x04 0x01
#define IMX95_PAD_SD2_DATA0__GPIO3_IO_BIT3                            0x01AC 0x03B0 0x0000 0x05 0x00
#define IMX95_PAD_SD2_DATA0__CCMSRCGPCMIX_TOP_OBSERVE_2               0x01AC 0x03B0 0x0000 0x06 0x00

#define IMX95_PAD_SD2_DATA1__USDHC2_DATA1                             0x01B0 0x03B4 0x0000 0x00 0x00
#define IMX95_PAD_SD2_DATA1__NETCMIX_TOP_NETC_TMR_1588_CLK            0x01B0 0x03B4 0x0000 0x01 0x00
#define IMX95_PAD_SD2_DATA1__CAN2_RX                                  0x01B0 0x03B4 0x0444 0x02 0x03
#define IMX95_PAD_SD2_DATA1__FLEXIO1_FLEXIO_BIT4                      0x01B0 0x03B4 0x0478 0x04 0x01
#define IMX95_PAD_SD2_DATA1__GPIO3_IO_BIT4                            0x01B0 0x03B4 0x0000 0x05 0x00

#define IMX95_PAD_SD2_DATA2__USDHC2_DATA2                             0x01B4 0x03B8 0x0000 0x00 0x00
#define IMX95_PAD_SD2_DATA2__NETCMIX_TOP_NETC_TMR_1588_PP3            0x01B4 0x03B8 0x0000 0x01 0x00
#define IMX95_PAD_SD2_DATA2__NETCMIX_TOP_MQS2_RIGHT                   0x01B4 0x03B8 0x0000 0x02 0x00
#define IMX95_PAD_SD2_DATA2__FLEXIO1_FLEXIO_BIT5                      0x01B4 0x03B8 0x047C 0x04 0x01
#define IMX95_PAD_SD2_DATA2__GPIO3_IO_BIT5                            0x01B4 0x03B8 0x0000 0x05 0x00

#define IMX95_PAD_SD2_DATA3__USDHC2_DATA3                             0x01B8 0x03BC 0x0000 0x00 0x00
#define IMX95_PAD_SD2_DATA3__LPTMR2_ALT1                              0x01B8 0x03BC 0x0548 0x01 0x01
#define IMX95_PAD_SD2_DATA3__NETCMIX_TOP_MQS2_LEFT                    0x01B8 0x03BC 0x0000 0x02 0x00
#define IMX95_PAD_SD2_DATA3__NETCMIX_TOP_NETC_TMR_1588_ALARM1         0x01B8 0x03BC 0x0000 0x03 0x00
#define IMX95_PAD_SD2_DATA3__FLEXIO1_FLEXIO_BIT6                      0x01B8 0x03BC 0x0480 0x04 0x01
#define IMX95_PAD_SD2_DATA3__GPIO3_IO_BIT6                            0x01B8 0x03BC 0x0000 0x05 0x00

#define IMX95_PAD_SD2_RESET_B__USDHC2_RESET_B                         0x01BC 0x03C0 0x0000 0x00 0x00
#define IMX95_PAD_SD2_RESET_B__LPTMR2_ALT2                            0x01BC 0x03C0 0x054C 0x01 0x01
#define IMX95_PAD_SD2_RESET_B__NETCMIX_TOP_NETC_TMR_1588_GCLK         0x01BC 0x03C0 0x0000 0x03 0x00
#define IMX95_PAD_SD2_RESET_B__FLEXIO1_FLEXIO_BIT7                    0x01BC 0x03C0 0x0484 0x04 0x01
#define IMX95_PAD_SD2_RESET_B__GPIO3_IO_BIT7                          0x01BC 0x03C0 0x0000 0x05 0x00

#define IMX95_PAD_I2C1_SCL__AONMIX_TOP_LPI2C1_SCL                     0x01C0 0x03C4 0x0000 0x00 0x00
#define IMX95_PAD_I2C1_SCL__AONMIX_TOP_I3C1_SCL                       0x01C0 0x03C4 0x0000 0x01 0x00
#define IMX95_PAD_I2C1_SCL__AONMIX_TOP_LPUART1_DCD_B                  0x01C0 0x03C4 0x0000 0x02 0x00
#define IMX95_PAD_I2C1_SCL__AONMIX_TOP_TPM2_CH0                       0x01C0 0x03C4 0x0000 0x03 0x00
#define IMX95_PAD_I2C1_SCL__VPUMIX_TOP_UART_RX                        0x01C0 0x03C4 0x0000 0x04 0x00
#define IMX95_PAD_I2C1_SCL__AONMIX_TOP_GPIO1_IO_BIT0                  0x01C0 0x03C4 0x0000 0x05 0x00

#define IMX95_PAD_I2C1_SDA__AONMIX_TOP_LPI2C1_SDA                     0x01C4 0x03C8 0x0000 0x00 0x00
#define IMX95_PAD_I2C1_SDA__AONMIX_TOP_I3C1_SDA                       0x01C4 0x03C8 0x0000 0x01 0x00
#define IMX95_PAD_I2C1_SDA__AONMIX_TOP_LPUART1_RIN_B                  0x01C4 0x03C8 0x0000 0x02 0x00
#define IMX95_PAD_I2C1_SDA__AONMIX_TOP_TPM2_CH1                       0x01C4 0x03C8 0x0000 0x03 0x00
#define IMX95_PAD_I2C1_SDA__VPUMIX_TOP_UART_TX                        0x01C4 0x03C8 0x0000 0x04 0x00
#define IMX95_PAD_I2C1_SDA__AONMIX_TOP_GPIO1_IO_BIT1                  0x01C4 0x03C8 0x0000 0x05 0x00

#define IMX95_PAD_I2C2_SCL__AONMIX_TOP_LPI2C2_SCL                     0x01C8 0x03CC 0x0000 0x00 0x00
#define IMX95_PAD_I2C2_SCL__AONMIX_TOP_I3C1_PUR                       0x01C8 0x03CC 0x0000 0x01 0x00
#define IMX95_PAD_I2C2_SCL__AONMIX_TOP_LPUART2_DCD_B                  0x01C8 0x03CC 0x0000 0x02 0x00
#define IMX95_PAD_I2C2_SCL__AONMIX_TOP_TPM2_CH2                       0x01C8 0x03CC 0x0000 0x03 0x00
#define IMX95_PAD_I2C2_SCL__AONMIX_TOP_SAI1_RX_SYNC                   0x01C8 0x03CC 0x0000 0x04 0x00
#define IMX95_PAD_I2C2_SCL__AONMIX_TOP_GPIO1_IO_BIT2                  0x01C8 0x03CC 0x0000 0x05 0x00
#define IMX95_PAD_I2C2_SCL__AONMIX_TOP_I3C1_PUR_B                     0x01C8 0x03CC 0x0000 0x06 0x00

#define IMX95_PAD_I2C2_SDA__AONMIX_TOP_LPI2C2_SDA                     0x01CC 0x03D0 0x0000 0x00 0x00
#define IMX95_PAD_I2C2_SDA__AONMIX_TOP_LPUART2_RIN_B                  0x01CC 0x03D0 0x0000 0x02 0x00
#define IMX95_PAD_I2C2_SDA__AONMIX_TOP_TPM2_CH3                       0x01CC 0x03D0 0x0000 0x03 0x00
#define IMX95_PAD_I2C2_SDA__AONMIX_TOP_SAI1_RX_BCLK                   0x01CC 0x03D0 0x0000 0x04 0x00
#define IMX95_PAD_I2C2_SDA__AONMIX_TOP_GPIO1_IO_BIT3                  0x01CC 0x03D0 0x0000 0x05 0x00

#define IMX95_PAD_UART1_RXD__AONMIX_TOP_LPUART1_RX                    0x01D0 0x03D4 0x0000 0x00 0x00
#define IMX95_PAD_UART1_RXD__S400_UART_RX                             0x01D0 0x03D4 0x0000 0x01 0x00
#define IMX95_PAD_UART1_RXD__AONMIX_TOP_LPSPI2_SIN                    0x01D0 0x03D4 0x0000 0x02 0x00
#define IMX95_PAD_UART1_RXD__AONMIX_TOP_TPM1_CH0                      0x01D0 0x03D4 0x0000 0x03 0x00
#define IMX95_PAD_UART1_RXD__AONMIX_TOP_GPIO1_IO_BIT4                 0x01D0 0x03D4 0x0000 0x05 0x00

#define IMX95_PAD_UART1_TXD__AONMIX_TOP_LPUART1_TX                    0x01D4 0x03D8 0x0000 0x00 0x00
#define IMX95_PAD_UART1_TXD__S400_UART_TX                             0x01D4 0x03D8 0x0000 0x01 0x00
#define IMX95_PAD_UART1_TXD__AONMIX_TOP_LPSPI2_PCS0                   0x01D4 0x03D8 0x0000 0x02 0x00
#define IMX95_PAD_UART1_TXD__AONMIX_TOP_TPM1_CH1                      0x01D4 0x03D8 0x0000 0x03 0x00
#define IMX95_PAD_UART1_TXD__AONMIX_TOP_GPIO1_IO_BIT5                 0x01D4 0x03D8 0x0000 0x05 0x00

#define IMX95_PAD_UART2_RXD__AONMIX_TOP_LPUART2_RX                    0x01D8 0x03DC 0x0000 0x00 0x00
#define IMX95_PAD_UART2_RXD__AONMIX_TOP_LPUART1_CTS_B                 0x01D8 0x03DC 0x0000 0x01 0x00
#define IMX95_PAD_UART2_RXD__AONMIX_TOP_LPSPI2_SOUT                   0x01D8 0x03DC 0x0000 0x02 0x00
#define IMX95_PAD_UART2_RXD__AONMIX_TOP_TPM1_CH2                      0x01D8 0x03DC 0x0000 0x03 0x00
#define IMX95_PAD_UART2_RXD__AONMIX_TOP_SAI1_MCLK                     0x01D8 0x03DC 0x041C 0x04 0x00
#define IMX95_PAD_UART2_RXD__AONMIX_TOP_GPIO1_IO_BIT6                 0x01D8 0x03DC 0x0000 0x05 0x00

#define IMX95_PAD_UART2_TXD__AONMIX_TOP_LPUART2_TX                    0x01DC 0x03E0 0x0000 0x00 0x00
#define IMX95_PAD_UART2_TXD__AONMIX_TOP_LPUART1_RTS_B                 0x01DC 0x03E0 0x0000 0x01 0x00
#define IMX95_PAD_UART2_TXD__AONMIX_TOP_LPSPI2_SCK                    0x01DC 0x03E0 0x0000 0x02 0x00
#define IMX95_PAD_UART2_TXD__AONMIX_TOP_TPM1_CH3                      0x01DC 0x03E0 0x0000 0x03 0x00
#define IMX95_PAD_UART2_TXD__AONMIX_TOP_GPIO1_IO_BIT7                 0x01DC 0x03E0 0x0000 0x05 0x00

#define IMX95_PAD_PDM_CLK__AONMIX_TOP_PDM_CLK                         0x01E0 0x03E4 0x0000 0x00 0x00
#define IMX95_PAD_PDM_CLK__AONMIX_TOP_MQS1_LEFT                       0x01E0 0x03E4 0x0000 0x01 0x00
#define IMX95_PAD_PDM_CLK__AONMIX_TOP_LPTMR1_ALT1                     0x01E0 0x03E4 0x0000 0x04 0x00
#define IMX95_PAD_PDM_CLK__AONMIX_TOP_GPIO1_IO_BIT8                   0x01E0 0x03E4 0x0000 0x05 0x00
#define IMX95_PAD_PDM_CLK__AONMIX_TOP_CAN1_TX                         0x01E0 0x03E4 0x0000 0x06 0x00

#define IMX95_PAD_PDM_BIT_STREAM0__AONMIX_TOP_PDM_BIT_STREAM_BIT0     0x01E4 0x03E8 0x040C 0x00 0x00
#define IMX95_PAD_PDM_BIT_STREAM0__AONMIX_TOP_MQS1_RIGHT              0x01E4 0x03E8 0x0000 0x01 0x00
#define IMX95_PAD_PDM_BIT_STREAM0__AONMIX_TOP_LPSPI1_PCS1             0x01E4 0x03E8 0x0000 0x02 0x00
#define IMX95_PAD_PDM_BIT_STREAM0__AONMIX_TOP_TPM1_EXTCLK             0x01E4 0x03E8 0x0000 0x03 0x00
#define IMX95_PAD_PDM_BIT_STREAM0__AONMIX_TOP_LPTMR1_ALT2             0x01E4 0x03E8 0x0000 0x04 0x00
#define IMX95_PAD_PDM_BIT_STREAM0__AONMIX_TOP_GPIO1_IO_BIT9           0x01E4 0x03E8 0x0000 0x05 0x00
#define IMX95_PAD_PDM_BIT_STREAM0__AONMIX_TOP_CAN1_RX                 0x01E4 0x03E8 0x0408 0x06 0x00

#define IMX95_PAD_PDM_BIT_STREAM1__AONMIX_TOP_PDM_BIT_STREAM_BIT1     0x01E8 0x03EC 0x0410 0x00 0x00
#define IMX95_PAD_PDM_BIT_STREAM1__NMI_GLUE_NMI                       0x01E8 0x03EC 0x0000 0x01 0x00
#define IMX95_PAD_PDM_BIT_STREAM1__AONMIX_TOP_LPSPI2_PCS1             0x01E8 0x03EC 0x0000 0x02 0x00
#define IMX95_PAD_PDM_BIT_STREAM1__AONMIX_TOP_TPM2_EXTCLK             0x01E8 0x03EC 0x0000 0x03 0x00
#define IMX95_PAD_PDM_BIT_STREAM1__AONMIX_TOP_LPTMR1_ALT3             0x01E8 0x03EC 0x0000 0x04 0x00
#define IMX95_PAD_PDM_BIT_STREAM1__AONMIX_TOP_GPIO1_IO_BIT10          0x01E8 0x03EC 0x0000 0x05 0x00
#define IMX95_PAD_PDM_BIT_STREAM1__CCMSRCGPCMIX_TOP_EXT_CLK1          0x01E8 0x03EC 0x0420 0x06 0x00

#define IMX95_PAD_SAI1_TXFS__AONMIX_TOP_SAI1_TX_SYNC                  0x01EC 0x03F0 0x0000 0x00 0x00
#define IMX95_PAD_SAI1_TXFS__AONMIX_TOP_SAI1_TX_DATA_BIT1             0x01EC 0x03F0 0x0000 0x01 0x00
#define IMX95_PAD_SAI1_TXFS__AONMIX_TOP_LPSPI1_PCS0                   0x01EC 0x03F0 0x0000 0x02 0x00
#define IMX95_PAD_SAI1_TXFS__AONMIX_TOP_LPUART2_DTR_B                 0x01EC 0x03F0 0x0000 0x03 0x00
#define IMX95_PAD_SAI1_TXFS__AONMIX_TOP_MQS1_LEFT                     0x01EC 0x03F0 0x0000 0x04 0x00
#define IMX95_PAD_SAI1_TXFS__AONMIX_TOP_GPIO1_IO_BIT11                0x01EC 0x03F0 0x0000 0x05 0x00

#define IMX95_PAD_SAI1_TXC__AONMIX_TOP_SAI1_TX_BCLK                   0x01F0 0x03F4 0x0000 0x00 0x00
#define IMX95_PAD_SAI1_TXC__AONMIX_TOP_LPUART2_CTS_B                  0x01F0 0x03F4 0x0000 0x01 0x00
#define IMX95_PAD_SAI1_TXC__AONMIX_TOP_LPSPI1_SIN                     0x01F0 0x03F4 0x0000 0x02 0x00
#define IMX95_PAD_SAI1_TXC__AONMIX_TOP_LPUART1_DSR_B                  0x01F0 0x03F4 0x0000 0x03 0x00
#define IMX95_PAD_SAI1_TXC__AONMIX_TOP_CAN1_RX                        0x01F0 0x03F4 0x0408 0x04 0x01
#define IMX95_PAD_SAI1_TXC__AONMIX_TOP_GPIO1_IO_BIT12                 0x01F0 0x03F4 0x0000 0x05 0x00

#define IMX95_PAD_SAI1_TXD0__AONMIX_TOP_SAI1_TX_DATA_BIT0             0x01F4 0x03F8 0x0000 0x00 0x00
#define IMX95_PAD_SAI1_TXD0__AONMIX_TOP_LPUART2_RTS_B                 0x01F4 0x03F8 0x0000 0x01 0x00
#define IMX95_PAD_SAI1_TXD0__AONMIX_TOP_LPSPI1_SCK                    0x01F4 0x03F8 0x0000 0x02 0x00
#define IMX95_PAD_SAI1_TXD0__AONMIX_TOP_LPUART1_DTR_B                 0x01F4 0x03F8 0x0000 0x03 0x00
#define IMX95_PAD_SAI1_TXD0__AONMIX_TOP_CAN1_TX                       0x01F4 0x03F8 0x0000 0x04 0x00
#define IMX95_PAD_SAI1_TXD0__AONMIX_TOP_GPIO1_IO_BIT13                0x01F4 0x03F8 0x0000 0x05 0x00

#define IMX95_PAD_SAI1_RXD0__AONMIX_TOP_SAI1_RX_DATA_BIT0             0x01F8 0x03FC 0x0000 0x00 0x00
#define IMX95_PAD_SAI1_RXD0__AONMIX_TOP_SAI1_MCLK                     0x01F8 0x03FC 0x041C 0x01 0x01
#define IMX95_PAD_SAI1_RXD0__AONMIX_TOP_LPSPI1_SOUT                   0x01F8 0x03FC 0x0000 0x02 0x00
#define IMX95_PAD_SAI1_RXD0__AONMIX_TOP_LPUART2_DSR_B                 0x01F8 0x03FC 0x0000 0x03 0x00
#define IMX95_PAD_SAI1_RXD0__AONMIX_TOP_MQS1_RIGHT                    0x01F8 0x03FC 0x0000 0x04 0x00
#define IMX95_PAD_SAI1_RXD0__AONMIX_TOP_GPIO1_IO_BIT14                0x01F8 0x03FC 0x0000 0x05 0x00

#define IMX95_PAD_WDOG_ANY__AONMIX_TOP_WDOG_ANY                       0x01FC 0x0400 0x0000 0x00 0x00
#define IMX95_PAD_WDOG_ANY__AONMIX_TOP_FCCU_EOUT1                     0x01FC 0x0400 0x0000 0x01 0x00
#define IMX95_PAD_WDOG_ANY__AONMIX_TOP_GPIO1_IO_BIT15                 0x01FC 0x0400 0x0000 0x05 0x00
#endif /* __DTS_IMX95_PINFUNC_H */
