/* $NetBSD: imx23_usbphyreg.h,v 1.2 2026/02/02 06:23:37 skrll Exp $ */

/*
 * Copyright (c) 2013 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Petri Laakso.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX23_USBPHYREG_H_
#define _ARM_IMX_IMX23_USBPHYREG_H_

#include <sys/cdefs.h>

#define HW_USBPHY_BASE	0x8007C000
#define HW_USBPHY_SIZE	0x2000 /* 8 kB */

/*
 * USB PHY Power-Down Register.
 */
#define HW_USBPHY_PWD		0x000
#define HW_USBPHY_PWD_SET	0x004
#define HW_USBPHY_PWD_CLR	0x008
#define HW_USBPHY_PWD_TOG	0x00c

#define HW_USBPHY_PWD_RSVD2	__BITS(31, 21)
#define HW_USBPHY_PWD_RXPWDRX	__BIT(20)
#define HW_USBPHY_PWD_RXPWDDIFF	__BIT(19)
#define HW_USBPHY_PWD_RXPWD1PT1	__BIT(18)
#define HW_USBPHY_PWD_RXPWDENV	__BIT(17)
#define HW_USBPHY_PWD_RSVD1	__BITS(16, 13)
#define HW_USBPHY_PWD_TXPWDV2I	__BIT(12)
#define HW_USBPHY_PWD_TXPWDIBIAS	__BIT(11)
#define HW_USBPHY_PWD_TXPWDFS	__BIT(10)
#define HW_USBPHY_PWD_RSVD0	__BITS(9, 0)

/*
 * USB PHY Transmitter Control Register.
 */
#define HW_USBPHY_TX		0x010
#define HW_USBPHY_TX_SET	0x014
#define HW_USBPHY_TX_CLR	0x018
#define HW_USBPHY_TX_TOG	0x01c

#define HW_USBPHY_TX_RSVD5			__BITS(31, 29)
#define HW_USBPHY_TX_USBPHY_TX_EDGECTRL		__BITS(28, 26)
#define HW_USBPHY_TX_USBPHY_TX_SYNC_INVERT	__BIT(25)
#define HW_USBPHY_TX_USBPHY_TX_SYNC_MUX		__BIT(24)
#define HW_USBPHY_TX_RSVD4		__BITS(23, 22)
#define HW_USBPHY_TX_TXENCAL45DP	__BIT(21)
#define HW_USBPHY_TX_RSVD3		__BIT(20)
#define HW_USBPHY_TX_TXCAL45DP		__BITS(19, 16)
#define HW_USBPHY_TX_RSVD2		__BITS(15, 14)
#define HW_USBPHY_TX_TXENCAL45DN	__BIT(13)
#define HW_USBPHY_TX_RSVD1		__BIT(12)
#define HW_USBPHY_TX_TXCAL45DN		__BITS(11, 8)
#define HW_USBPHY_TX_RSVD0		__BITS(7, 3)
#define HW_USBPHY_TX_D_CAL		__BITS(3, 0)

/*
 * USB PHY Receiver Control Register.
 */
#define HW_USBPHY_RX		0x020
#define HW_USBPHY_RX_SET	0x024
#define HW_USBPHY_RX_CLR	0x028
#define HW_USBPHY_RX_TOG	0x02c

#define HW_USBPHY_RX_RSVD2	__BITS(31, 23)
#define HW_USBPHY_RX_RXDBYPASS	__BIT(22)
#define HW_USBPHY_RX_RSVD1	__BITS(21, 7)
#define HW_USBPHY_RX_DISCONADJ	__BITS(6, 4)
#define HW_USBPHY_RX_RSVD0	__BIT(3)
#define HW_USBPHY_RX_ENVADJ	__BITS(2, 0)

/*
 * USB PHY General Control Register.
 */
#define HW_USBPHY_CTRL		0x030
#define HW_USBPHY_CTRL_SET	0x034
#define HW_USBPHY_CTRL_CLR	0x038
#define HW_USBPHY_CTRL_TOG	0x03c

#define HW_USBPHY_CTRL_SFTRST		__BIT(31)
#define HW_USBPHY_CTRL_CLKGATE		__BIT(30)
#define HW_USBPHY_CTRL_UTMI_SUSPENDM	__BIT(29)
#define HW_USBPHY_CTRL_HOST_FORCE_LS_SE0	__BIT(28)
#define HW_USBPHY_CTRL_RSVD3	_	_BITS(27, 14)
#define HW_USBPHY_CTRL_DATA_ON_LRADC	__BIT(13)
#define HW_USBPHY_CTRL_DEVPLUGIN_IRQ	__BIT(12)
#define HW_USBPHY_CTRL_ENIRQDEVPLUGIN	__BIT(11)
#define HW_USBPHY_CTRL_RESUME_IRQ	__BIT(10)
#define HW_USBPHY_CTRL_ENIRQRESUMEDETECT	__BIT(9)
#define HW_USBPHY_CTRL_RSVD2		__BIT(8)
#define HW_USBPHY_CTRL_ENOTGIDDETECT	__BIT(7)
#define HW_USBPHY_CTRL_RSVD1		__BIT(6)
#define HW_USBPHY_CTRL_DEVPLUGIN_POLARITY	__BIT(5)
#define HW_USBPHY_CTRL_ENDEVPLUGINDETECT	__BIT(4)
#define HW_USBPHY_CTRL_HOSTDISCONDETECT_IRQ	__BIT(3)
#define HW_USBPHY_CTRL_ENIRQHOSTDISCON		__BIT(2)
#define HW_USBPHY_CTRL_ENHOSTDISCONDETECT	__BIT(1)
#define HW_USBPHY_CTRL_RSVD0		__BIT(0)

/*
 * USB PHY Status Register.
 */
#define HW_USBPHY_STATUS	0x040

#define HW_USBPHY_STATUS_RSVD4		__BITS(31, 11)
#define HW_USBPHY_STATUS_RESUME_STATUS	__BIT(10)
#define HW_USBPHY_STATUS_RSVD3		__BIT(9)
#define HW_USBPHY_STATUS_OTGID_STATUS	__BIT(8)
#define HW_USBPHY_STATUS_RSVD2		__BIT(7)
#define HW_USBPHY_STATUS_DEVPLUGIN_STATUS	__BIT(6)
#define HW_USBPHY_STATUS_RSVD1		__BITS(5, 4)
#define HW_USBPHY_STATUS_HOSTDISCONDETECT_STATUS	__BIT(3)
#define HW_USBPHY_STATUS_RSVD0		__BITS(2, 0)

/*
 * USB PHY Debug Register.
 */
#define HW_USBPHY_DEBUG		0x050
#define HW_USBPHY_DEBUG_SET	0x054
#define HW_USBPHY_DEBUG_CLR	0x058
#define HW_USBPHY_DEBUG_TOG	0x05c

#define HW_USBPHY_DEBUG_RSVD3		__BIT(31)
#define HW_USBPHY_DEBUG_CLKGATE		__BIT(30)
#define HW_USBPHY_DEBUG_HOST_RESUME_DEBUG	__BIT(29)
#define HW_USBPHY_DEBUG_SQUELCHRESETLENGTH	__BITS(28, 25)
#define HW_USBPHY_DEBUG_ENSQUELCHRESET		__BIT(24)
#define HW_USBPHY_DEBUG_RSVD2			__BITS(23, 21)
#define HW_USBPHY_DEBUG_SQUELCHRESETCOUNT	__BITS(20, 16)
#define HW_USBPHY_DEBUG_RSVD1			__BITS(15, 13)
#define HW_USBPHY_DEBUG_ENTX2RXCOUNT		__BIT(12)
#define HW_USBPHY_DEBUG_TX2RXCOUNT		__BITS(11, 8)
#define HW_USBPHY_DEBUG_RSVD0			__BITS(7, 6)
#define HW_USBPHY_DEBUG_ENHSTPULLDOWN		__BITS(5, 4)
#define HW_USBPHY_DEBUG_HSTPULLDOWN		__BITS(3, 2)
#define HW_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD	__BIT(1)
#define HW_USBPHY_DEBUG_OTGIDPIOLOCK		__BIT(0)

/*
 * UTMI Debug Status Register 0.
 */
#define HW_USBPHY_DEBUG0_STATUS	0x060

#define HW_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT 		__BITS(31, 26)
#define HW_USBPHY_DEBUG0_STATUS_UTMI_RXERROR_FAIL_COUNT	__BITS(25, 16)
#define HW_USBPHY_DEBUG0_STATUS_LOOP_BACK_FAIL_COUNT	__BITS(15, 0)

/*
 * UTMI Debug Status Register 1.
 */
#define HW_USBPHY_DEBUG1	0x070
#define HW_USBPHY_DEBUG1_SET	0x074
#define HW_USBPHY_DEBUG1_CLR	0x078
#define HW_USBPHY_DEBUG1_TOG	0x07c

#define HW_USBPHY_DEBUG1_RSVD1		__BITS(31, 15)
#define HW_USBPHY_DEBUG1_ENTAILADJVD	__BITS(14, 13)
#define HW_USBPHY_DEBUG1_ENTX2TX	__BIT(12)
#define HW_USBPHY_DEBUG1_RSVD0		__BITS(11, 4)
#define HW_USBPHY_DEBUG1_DBG_ADDRESS	__BITS(3, 0)

/*
 * UTMI RTL Version.
 */
#define HW_USBPHY_VERSION	0x080

#define HW_USBPHY_VERSION_MAJOR	__BITS(31, 24)
#define HW_USBPHY_VERSION_MINOR	__BITS(23, 16)
#define HW_USBPHY_VERSION_STEP	__BITS(15, 0)

/*
 * USB PHY IP Block Register.
 */
#define HW_USBPHY_IP		0x090
#define HW_USBPHY_IP_SET	0x094
#define HW_USBPHY_IP_CLR	0x098
#define HW_USBPHY_IP_TOG	0x09c

#define HW_USBPHY_IP_RSVD1	__BITS(31, 25)
#define HW_USBPHY_IP_DIV_SEL	__BITS(24, 23)
#define HW_USBPHY_IP_LFR_SEL	__BITS(22, 21)
#define HW_USBPHY_IP_CP_SEL	__BITS(20, 19)
#define HW_USBPHY_IP_TSTI_TX_DP	__BIT(18)
#define HW_USBPHY_IP_TSTI_TX_DM	__BIT(17)
#define HW_USBPHY_IP_ANALOG_TESTMODE	__BIT(16)
#define HW_USBPHY_IP_RSVD0		__BITS(15, 3)
#define HW_USBPHY_IP_EN_USB_CLKS	__BIT(2)
#define HW_USBPHY_IP_PLL_LOCKED		__BIT(1)
#define HW_USBPHY_IP_PLL_POWER		__BIT(0)

#endif /* !_ARM_IMX_IMX23_USBPHYREG_H_ */
