/* $NetBSD: imx23_timrotreg.h,v 1.2 2026/02/02 06:23:37 skrll Exp $ */

/*
 * Copyright (c) 2012 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Petri Laakso.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX23_TIMROTREG_H_
#define _ARM_IMX_IMX23_TIMROTREG_H_

#include <sys/cdefs.h>

#define HW_TIMROT_BASE 0x80068000
#define HW_TIMROT_SIZE 0x2000

/*
 * Rotary Decoder Control Register.
 */
#define HW_TIMROT_ROTCTRL	0x000
#define HW_TIMROT_ROTCTRL_SET	0x004
#define HW_TIMROT_ROTCTRL_CLR	0x008
#define HW_TIMROT_ROTCTRL_TOG	0x00C

#define HW_TIMROT_ROTCTRL_SFTRST		__BIT(31)
#define HW_TIMROT_ROTCTRL_CLKGATE		__BIT(30)
#define HW_TIMROT_ROTCTRL_ROTARY_PRESENT	__BIT(29)
#define HW_TIMROT_ROTCTRL_TIM3_PRESENT		__BIT(28)
#define HW_TIMROT_ROTCTRL_TIM2_PRESENT		__BIT(27)
#define HW_TIMROT_ROTCTRL_TIM1_PRESENT		__BIT(26)
#define HW_TIMROT_ROTCTRL_TIM0_PRESENT		__BIT(25)
#define HW_TIMROT_ROTCTRL_STATE			__BITS(24, 22)
#define HW_TIMROT_ROTCTRL_DIVIDER		__BITS(21, 16)
#define HW_TIMROT_ROTCTRL_RSRVD3		__BITS(15, 13)
#define HW_TIMROT_ROTCTRL_RELATIVE		__BIT(12)
#define HW_TIMROT_ROTCTRL_OVERSAMPLE		__BITS(11, 10)
#define HW_TIMROT_ROTCTRL_POLARITY_B		__BIT(9)
#define HW_TIMROT_ROTCTRL_POLARITY_A		__BIT(8)
#define HW_TIMROT_ROTCTRL_RSRVD2		__BIT(7)
#define HW_TIMROT_ROTCTRL_SELECT_B		__BITS(6, 4)
#define HW_TIMROT_ROTCTRL_RSRVD1		__BIT(3)
#define HW_TIMROT_ROTCTRL_SELECT_A		__BITS(2, 0)

/*
 * Rotary Decoder Up/Down Counter Register.
 */
#define HW_TIMROT_ROTCOUNT 0x010

#define HW_TIMROT_ROTCOUNT_RSRVD1	__BITS(31, 16)
#define HW_TIMROT_ROTCOUNT_UPDOWN	__BITS(15, 0)

/*
 * Timer 0 Control and Status Register.
 */
#define HW_TIMROT_TIMCTRL0	0x020
#define HW_TIMROT_TIMCTRL0_SET	0x024
#define HW_TIMROT_TIMCTRL0_CLR	0x028
#define HW_TIMROT_TIMCTRL0_TOG	0x02C

#define HW_TIMROT_TIMCTRL0_RSRVD2	__BITS(31, 16)
#define HW_TIMROT_TIMCTRL0_IRQ		__BIT(15)
#define HW_TIMROT_TIMCTRL0_IRQ_EN	__BIT(14)
#define HW_TIMROT_TIMCTRL0_RSRVD1	__BITS(13, 9)
#define HW_TIMROT_TIMCTRL0_POLARITY	__BIT(8)
#define HW_TIMROT_TIMCTRL0_UPDATE	__BIT(7)
#define HW_TIMROT_TIMCTRL0_RELOAD	__BIT(6)
#define HW_TIMROT_TIMCTRL0_PRESCALE	__BITS(5, 4)
#define HW_TIMROT_TIMCTRL0_SELECT	__BITS(3, 0)

/*
 * Timer 0 Count Register.
 */
#define HW_TIMROT_TIMCOUNT0	0x030

#define HW_TIMROT_TIMCOUNT0_RUNNING_COUNT	__BITS(31, 16)
#define HW_TIMROT_TIMCOUNT0_FIXED_COUNT		__BITS(15, 0)

/*
 * Timer 1 Control and Status Register.
 */
#define HW_TIMROT_TIMCTRL1	0x040
#define HW_TIMROT_TIMCTRL1_SET	0x044
#define HW_TIMROT_TIMCTRL1_CLR	0x048
#define HW_TIMROT_TIMCTRL1_TOG	0x04C

#define HW_TIMROT_TIMCTRL1_RSRVD2	__BITS(31, 16)
#define HW_TIMROT_TIMCTRL1_IRQ		__BIT(15)
#define HW_TIMROT_TIMCTRL1_IRQ_EN	__BIT(14)
#define HW_TIMROT_TIMCTRL1_RSRVD1	__BITS(13, 9)
#define HW_TIMROT_TIMCTRL1_POLARITY	__BIT(8)
#define HW_TIMROT_TIMCTRL1_UPDATE	__BIT(7)
#define HW_TIMROT_TIMCTRL1_RELOAD	__BIT(6)
#define HW_TIMROT_TIMCTRL1_PRESCALE	__BITS(5, 4)
#define HW_TIMROT_TIMCTRL1_SELECT	__BITS(3, 0)

/*
 * Timer 1 Count Register.
 */
#define HW_TIMROT_TIMCOUNT1	0x050

#define HW_TIMROT_TIMCOUNT1_RUNNING_COUNT	__BITS(31, 16)
#define HW_TIMROT_TIMCOUNT1_FIXED_COUNT		__BITS(15, 0)

/*
 * Timer 2 Control and Status Register.
 */
#define HW_TIMROT_TIMCTRL2	0x060
#define HW_TIMROT_TIMCTRL2_SET	0x064
#define HW_TIMROT_TIMCTRL2_CLR	0x068
#define HW_TIMROT_TIMCTRL2_TOG	0x06C

#define HW_TIMROT_TIMCTRL2_RSRVD2	__BITS(31, 16)
#define HW_TIMROT_TIMCTRL2_IRQ		__BIT(15)
#define HW_TIMROT_TIMCTRL2_IRQ_EN	__BIT(14)
#define HW_TIMROT_TIMCTRL2_RSRVD1	__BITS(13, 9)
#define HW_TIMROT_TIMCTRL2_POLARITY	__BIT(8)
#define HW_TIMROT_TIMCTRL2_UPDATE	__BIT(7)
#define HW_TIMROT_TIMCTRL2_RELOAD	__BIT(6)
#define HW_TIMROT_TIMCTRL2_PRESCALE	__BITS(5, 4)
#define HW_TIMROT_TIMCTRL2_SELECT	__BIT(3, 0)

/*
 * Timer 2 Count Register.
 */
#define HW_TIMROT_TIMCOUNT2	0x070

#define HW_TIMROT_TIMCOUNT2_RUNNING_COUNT	__BITS(31, 16)
#define HW_TIMROT_TIMCOUNT2_FIXED_COUNT		__BITS(15, 0)

/*
 * Timer 3 Control and Status Register.
 */
#define HW_TIMROT_TIMCTRL3	0x080
#define HW_TIMROT_TIMCTRL3_SET	0x084
#define HW_TIMROT_TIMCTRL3_CLR	0x088
#define HW_TIMROT_TIMCTRL3_TOG	0x08C

#define HW_TIMROT_TIMCTRL3_RSRVD2	__BITS(31, 20)
#define HW_TIMROT_TIMCTRL3_TEST_SIGNAL	__BITS(19, 16)
#define HW_TIMROT_TIMCTRL3_IRQ		__BIT(15)
#define HW_TIMROT_TIMCTRL3_IRQ_EN	__BIT(14)
#define HW_TIMROT_TIMCTRL3_RSRVD1	__BITS(13, 11)
#define HW_TIMROT_TIMCTRL3_DUTY_VALID	__BIT(10)
#define HW_TIMROT_TIMCTRL3_DUTY_CYCLE	__BIT(9)
#define HW_TIMROT_TIMCTRL3_POLARITY	__BIT(8)
#define HW_TIMROT_TIMCTRL3_UPDATE	__BIT(7)
#define HW_TIMROT_TIMCTRL3_RELOAD	__BIT(6)
#define HW_TIMROT_TIMCTRL3_PRESCALE	__BITS(5, 4)
#define HW_TIMROT_TIMCTRL3_SELECT	__BITS(3, 0)

/*
 * Timer 3 Count Register.
 */
#define HW_TIMROT_TIMCOUNT3	0x090

#define HW_TIMROT_TIMCOUNT3_LOW_RUNNING_COUNT	__BITS(31, 16)
#define HW_TIMROT_TIMCOUNT3IHIGH_FIXED_COUNT	__BITS(15, 0)

/*
 * TIMROT Version Register.
 */
#define HW_TIMROT_VERSION	0x0a0

#define HW_TIMROT_VERSION_MAJOR	__BITS(31, 24)
#define HW_TIMROT_VERSION_MINOR	__BITS(23, 16)
#define HW_TIMROT_VERSION_STEP	__BITS(15, 0)

#endif /* !_ARM_IMX_IMX23_TIMROTREG_H_ */
