/* $NetBSD: imx23_pinctrlreg.h,v 1.3 2026/02/02 06:23:37 skrll Exp $ */

/*
 * Copyright (c) 2012 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Petri Laakso.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX23_PINCTRLREG_H_
#define _ARM_IMX_IMX23_PINCTRLREG_H_

#include <sys/cdefs.h>

#define HW_PINCTRL_BASE 0x80018000
#define HW_PINCTRL_SIZE	0x2000

/*
 * PINCTRL Block Control Register.
 */
#define HW_PINCTRL_CTRL		0x000
#define HW_PINCTRL_CTRL_SET	0x004
#define HW_PINCTRL_CTRL_CLR	0x008
#define HW_PINCTRL_CTRL_TOG	0x00C

#define HW_PINCTRL_CTRL_SFTRST		__BIT(31)
#define HW_PINCTRL_CTRL_CLKGATE		__BIT(30)
#define HW_PINCTRL_CTRL_RSRVD2		__BITS(29, 28)
#define HW_PINCTRL_CTRL_PRESENT3	__BIT(27)
#define HW_PINCTRL_CTRL_PRESENT2	__BIT(26)
#define HW_PINCTRL_CTRL_PRESENT1	__BIT(25)
#define HW_PINCTRL_CTRL_PRESENT0	__BIT(24)
#define HW_PINCTRL_CTRL_RSRVD1		__BIT(23, 3)
#define HW_PINCTRL_CTRL_IRQOUT2		__BITS(2)
#define HW_PINCTRL_CTRL_IRQOUT1		__BIT(1)
#define HW_PINCTRL_CTRL_IRQOUT0		__BIT(0)

/*
 * PINCTRL Pin Mux Select Register 0.
 */
#define HW_PINCTRL_MUXSEL0	0x100
#define HW_PINCTRL_MUXSEL0_SET	0x104
#define HW_PINCTRL_MUXSEL0_CLR	0x108
#define HW_PINCTRL_MUXSEL0_TOG	0x10C

#define HW_PINCTRL_MUXSEL0_BANK0_PIN15	__BITS(31, 30)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN14	__BITS(29, 28)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN13	__BITS(27, 26)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN12	__BITS(25, 24)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN11	__BITS(23, 22)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN10	__BITS(21, 20)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN09	__BITS(19, 18)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN08	__BITS(17, 16)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN07	__BITS(15, 14)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN06	__BITS(13, 12)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN05	__BITS(11, 10)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN04	__BITS(9, 8)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN03	__BITS(7, 6)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN02	__BITS(5, 4)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN01	__BITS(3, 2)
#define HW_PINCTRL_MUXSEL0_BANK0_PIN00	__BITS(1, 0)

/* Pin 59, GPMI_D15 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN15_GPMI_DATA15	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN15_AUART2_TX	0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN15_GPMI_CE3N	0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN15_GPIO		0x03

/* Pin 58, GPMI_D14 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN14_GPMI_DATA14	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN14_AUART2_RX	0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN14_RESERVED		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN14_GPIO		0x03

/* Pin 57, GPMI_D13 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN13_GPMI_DATA13	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN13_LCD_D23		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN13_RESERVED		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN13_GPIO		0x03

/* Pin 56, GPMI_D12 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN12_GPMI_DATA12	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN12_LCD_D22		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN12_RESERVED		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN12_GPIO		0x03

/* Pin 55, GPMI_D11 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN11_GPMI_DATA11	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN11_LCD_D21		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN11_SSP1_D7		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN11_GPIO		0x03

/* Pin 54, GPMI_D10 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN10_GPMI_DATA10	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN10_LCD_D20		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN10_SSP1_D6		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN10_GPIO		0x03

/* Pin 53, GPMI_D09 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN09_GPMI_DATA09	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN09_LCD_D19		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN09_SSP1_D5		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN09_GPIO		0x03

/* Pin 52, GPMI_D08 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN08_GPMI_DATA08	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN08_LCD_D18		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN08_SSP1_D4		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN08_GPIO		0x03

/* Pin 50, GPMI_D07 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN07_GPMI_DATA07	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN07_LCD_D15		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN07_SSP2_D7		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN07_GPIO		0x03

/* Pin 51, GPMI_D06 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN06_GPMI_DATA06	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN06_LCD_D14		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN06_SSP2_D6		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN06_GPIO		0x03

/* Pin 48, GPMI_D05 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN05_GPMI_DATA05	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN05_LCD_D13		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN05_SSP2_D5		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN05_GPIO		0x03

/* Pin 49, GPMI_D04 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN04_GPMI_DATA04	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN04_LCD_D12		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN04_SSP2_D4		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN04_GPIO		0x03

/* Pin 47, GPMI_D03 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN03_GPMI_DATA03	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN03_LCD_D11		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN03_SSP2_D3		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN03_GPIO		0x03

/* Pin 46, GPMI_D02 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN02_GPMI_DATA02	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN02_LCD_D10		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN02_SSP2_D2		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN02_GPIO		0x03

/* Pin 45, GPMI_D01 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN01_GPMI_DATA01	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN01_LCD_D9		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN01_SSP2_D1		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN01_GPIO		0x03

/* Pin 44, GPMI_D00 pin function selection */
#define HW_PINCTRL_MUXSEL0_BANK0_PIN00_GPMI_DATA00	0x00
#define HW_PINCTRL_MUXSEL0_BANK0_PIN00_LCD_D8		0x01
#define HW_PINCTRL_MUXSEL0_BANK0_PIN00_SSP2_D0		0x02
#define HW_PINCTRL_MUXSEL0_BANK0_PIN00_GPIO		0x03

/*
 * PINCTRL Pin Mux Select Register 1.
 */
#define HW_PINCTRL_MUXSEL1	0x110
#define HW_PINCTRL_MUXSEL1_SET	0x114
#define HW_PINCTRL_MUXSEL1_CLR	0x118
#define HW_PINCTRL_MUXSEL1_TOG	0x11C

#define HW_PINCTRL_MUXSEL1_BANK0_PIN31	__BITS(31, 30)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN30	__BITS(29, 28)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN29	__BITS(27, 26)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN28	__BITS(25, 24)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN27	__BITS(23, 22)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN26	__BITS(21, 20)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN25	__BITS(19, 18)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN24	__BITS(17, 16)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN23	__BITS(15, 14)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN22	__BITS(13, 12)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN21	__BITS(11, 10)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN20	__BITS(9, 8)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN19	__BITS(7, 6)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN18	__BITS(5, 4)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN17	__BITS(3, 2)
#define HW_PINCTRL_MUXSEL1_BANK0_PIN16	__BITS(1, 0)

/* Pin 4, I2C_SDA pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN31_I2C_SD		0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN31_GPMI_CE2N	0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN31_AUART1_RX	0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN31_GPIO		0x03

/* Pin 2, I2C_SCL pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN30_I2C_CLK		0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN30_GPMI_READY2	0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN30_AUART1_TX	0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN30_GPIO		0x03

/* Pin 69, AUART1_TX pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN29_AUART1_TX	0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN29_RESERVED		0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN29_SSP1_D7		0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN29_GPIO		0x03

/* Pin 68, AUART1_RX pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN28_AUART1_RX	0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN28_RESERVED		0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN28_SSP1_D6		0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN28_GPIO		0x03

/* Pin 67, AUART1_RTS pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN27_AUART1_RTS	0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN27_RESERVED		0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN27_SSP1_D5		0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN27_GPIO		0x03

/* Pin 66, AUART1_CTS pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN26_AUART1_CTS	0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN26_ESERVED		0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN26_SSP1_D4		0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN26_GPIO		0x03

/* Pin 60, GPMI_RDN pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN25_GPMI_RDN		0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN25_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN25_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN25_GPIO		0x03

/* Pin 65, GPMI_WRN pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN24_GPMI_WRN		0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN24_RESERVED		0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN24_SSP2_SCK		0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN24_GPIO		0x03

/* Pin 64, GPMI_WPN pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN23_GPMI_WPN		0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN23_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN23_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN23_GPIO		0x03

/* Pin 63, GPMI_RDY3 pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN22_GPMI_READY3	0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN22_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN22_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN22_GPIO		0x03

/* Pin 62, GPMI_RDY2 pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN21_GPMI_READY2	0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN21_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN21_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN21_GPIO		0x03

/* Pin 43, GPMI_RDY1 pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN20_GPMI_READY1	0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN20_RESERVED		0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN20_SSP2_CMD		0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN20_GPIO		0x03

/* Pin 61, GPMI_RDY0 pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN19_GPMI_READY0	0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN19_RESERVED		0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN19_SSP2_DETECT	0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN19_GPIO		0x03

/* Pin 42, GPMI_CE2N pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN18_GPMI_CE2N	0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN18_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN18_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN18_GPIO		0x03

/* Pin 41, GPMI_ALE pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN17_GPMI_ALE		0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN17_LCD_D17		0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN17_RESERVED		0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN17_GPIO		0x03

/* Pin 40, GPMI_CLE pin function selection */
#define HW_PINCTRL_MUXSEL1_BANK0_PIN16_GPMI_CLE		0x00
#define HW_PINCTRL_MUXSEL1_BANK0_PIN16_LCD_D16		0x01
#define HW_PINCTRL_MUXSEL1_BANK0_PIN16_RESERVED		0x02
#define HW_PINCTRL_MUXSEL1_BANK0_PIN16_GPIO		0x03

/*
 * PINCTRL Pin Mux Select Register 2.
 */
#define HW_PINCTRL_MUXSEL2	0x120
#define HW_PINCTRL_MUXSEL2_SET	0x124
#define HW_PINCTRL_MUXSEL2_CLR	0x128
#define HW_PINCTRL_MUXSEL2_TOG	0x12C

#define HW_PINCTRL_MUXSEL2_BANK1_PIN15	__BITS(31, 30)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN14	__BITS(29, 28)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN13	__BITS(27, 26)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN12	__BITS(25, 24)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN11	__BITS(23, 22)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN10	__BITS(21, 20)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN09	__BITS(19, 18)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN08	__BITS(17, 16)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN07	__BITS(15, 14)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN06	__BITS(13, 12)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN05	__BITS(11, 10)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN04	__BITS(9, 8)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN03	__BITS(7, 6)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN02	__BITS(5, 4)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN01	__BITS(3, 2)
#define HW_PINCTRL_MUXSEL2_BANK1_PIN00	__BITS(1, 0)

/* Pin 15, LCD_D15 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN15_LCD_D15		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN15_ETM_DA7		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN15_SAIF1_SDATA1	0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN15_GPIO		0x03

/* Pin 17, LCD_D14 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN14_LCD_D14		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN14_ETM_DA6		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN14_SAIF1_SDATA2	0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN14_GPIO		0x03

/* Pin 19, LCD_D13 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN13_LCD_D13		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN13_ETM_DA5		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN13_SAIF2_SDATA2	0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN13_GPIO		0x03

/* Pin 22, LCD_D12 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN12_LCD_D12		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN12_ETM_DA4		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN12_SAIF2_SDATA1	0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN12_GPIO		0x03

/* Pin 24, LCD_D11 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN11_LCD_D11		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN11_ETM_DA3		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN11_SAIF_LRCLK	0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN11_GPIO		0x03

/* Pin 26, LCD_D10 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN10_LCD_D10		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN10_ETM_DA2		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN10_SAIF_BITCLK	0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN10_GPIO		0x03

/* Pin 28, LCD_D09 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN09_LCD_D9		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN09_ETM_DA1		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN09_SAIF1_SDATA0	0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN09_GPIO		0x03

/* Pin 27, LCD_D08 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN08_LCD_D8		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN08_ETM_DA0		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN08_SAIF2_SDATA0	0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN08_GPIO		0x03

/* Pin 25, LCD_D07 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN07_LCD_D7		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN07_ETM_DA15		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN07_RESERVED		0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN07_GPIO		0x03

/* Pin 23, LCD_D06 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN06_LCD_D6		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN06_ETM_DA14		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN06_RESERVED		0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN06_GPIO		0x03

/* Pin 21, LCD_D05 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN05_LCD_D5		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN05_ETM_DA13		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN05_RESERVED		0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN05_GPIO		0x03

/* Pin 18, LCD_D04 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN04_LCD_D4		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN04_ETM_DA12		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN04_RESERVED		0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN04_GPIO		0x03

/* Pin 16, LCD_D03 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN03_LCD_D3		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN03_ETM_DA11		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN03_RESERVED		0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN03_GPIO		0x03

/* Pin 14, LCD_D02 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN02_LCD_D2		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN02_ETM_DA10		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN02_RESERVED		0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN02_GPIO		0x03

/* Pin 12, LCD_D01 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN01_LCD_D1		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN01_ETM_DA9		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN01_RESERVED		0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN01_GPIO		0x03

/* Pin 10, LCD_D00 pin function selection */
#define HW_PINCTRL_MUXSEL2_BANK1_PIN00_LCD_D0		0x00
#define HW_PINCTRL_MUXSEL2_BANK1_PIN00_ETM_DA8		0x01
#define HW_PINCTRL_MUXSEL2_BANK1_PIN00_RESERVED		0x02
#define HW_PINCTRL_MUXSEL2_BANK1_PIN00_GPIO		0x03

/*
 * PINCTRL Pin Mux Select Register 3.
 */
#define HW_PINCTRL_MUXSEL3	0x130
#define HW_PINCTRL_MUXSEL3_SET	0x134
#define HW_PINCTRL_MUXSEL3_CLR	0x138
#define HW_PINCTRL_MUXSEL3_TOG	0x13C

#define HW_PINCTRL_MUXSEL3_RSRVD0	__BITS(31, 30)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN30	__BITS(29, 28)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN29	__BITS(27, 26)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN28	__BITS(25, 24)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN27	__BITS(23, 22)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN26	__BITS(21, 20)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN25	__BITS(19, 18)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN24	__BITS(17, 16)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN23	__BITS(15, 14)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN22	__BITS(13, 12)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN21	__BITS(11, 10)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN20	__BITS(9, 8)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN19	__BITS(7, 6)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN18	__BITS(5, 4)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN17	__BITS(3, 2)
#define HW_PINCTRL_MUXSEL3_BANK1_PIN16	__BITS(1, 0)

/* Always write zeroes to this field */
#define HW_PINCTRL_MUXSEL3_RSRVD0_ZERO			0x00

/* Pin 131, PWM4 pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN30_PWM4		0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN30_ETM_TCLK		0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN30_AUART1_RTS	0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN30_GPIO		0x03

/* Pin 130, PWM3 pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN29_PWM3		0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN29_ETM_TCTL		0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN29_AUART1_CTS	0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN29_GPIO		0x03

/* Pin 129, PWM2 pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN28_PWM2		0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN28_GPMI_READY3	0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN28_RESERVED		0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN28_GPIO		0x03

/* Pin 3, PWM1 pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN27_PWM1		0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN27_TIMROT2		0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN27_DUART_TX		0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN27_GPIO		0x03

/* Pin 1, PWM0 pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN26_PWM0		0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN26_TIMROT1		0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN26_DUART_RX		0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN26_GPIO		0x03

/* Pin 35, LCD_VSYNC pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN25_LCD_VSYNC	0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN25_LCD_BUSY		0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN25_RESERVED		0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN25_GPIO		0x03

/* Pin 34, LCD_HSYNC pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN24_LCD_HSYNC	0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN24_I2C_SD		0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN24_RESERVED		0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN24_GPIO		0x03

/* Pin 30, LCD_ENABLE pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN23_LCD_ENABLE	0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN23_I2C_CLK		0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN23_RESERVED		0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN23_GPIO		0x03

/* Pin 36, LCD_DOTCK pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN22_LCD_DOTCK	0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN22_GPMI_READY3	0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN22_RESERVED		0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN22_GPIO		0x03

/* Pin 29, LCD_CS pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN21_LCD_CS		0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN21_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN21_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN21_GPIO		0x03

/* Pin 32, LCD_WR pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN20_LCD_WR		0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN20_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN20_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN20_GPIO		0x03

/* Pin 33, LCD_RS pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN19_LCD_RS		0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN19_ETM_TCLK		0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN19_RESERVED		0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN19_GPIO		0x03

/* Pin 31, LCD_RESET pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN18_LCD_RESET	0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN18_ETM_TCTL		0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN18_GPMI_CE3N	0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN18_GPIO		0x03

/* Pin 11, LCD_D17 pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN17_LCD_D17		0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN17_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN17_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN17_GPIO		0x03

/* Pin 13, LCD_D16 pin function selection */
#define HW_PINCTRL_MUXSEL3_BANK1_PIN16_LCD_D16		0x00
#define HW_PINCTRL_MUXSEL3_BANK1_PIN16_RESERVED		0x01
#define HW_PINCTRL_MUXSEL3_BANK1_PIN16_SAIF_ALT_BITCLK	0x02
#define HW_PINCTRL_MUXSEL3_BANK1_PIN16_GPIO		0x03

/*
 * PINCTRL Pin Mux Select Register 4.
 */
#define HW_PINCTRL_MUXSEL4	0x140
#define HW_PINCTRL_MUXSEL4_SET	0x144
#define HW_PINCTRL_MUXSEL4_CLR	0x148
#define HW_PINCTRL_MUXSEL4_TOG	0x14C

#define HW_PINCTRL_MUXSEL4_BANK2_PIN15	__BITS(31,30)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN14	__BITS(29,28)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN13	__BITS(27,26)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN12	__BITS(25,24)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN11	__BITS(23,22)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN10	__BITS(21,20)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN09	__BITS(19,18)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN08	__BITS(17,16)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN07	__BITS(15,14)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN06	__BITS(13,12)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN05	__BITS(11,10)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN04	__BITS(9,8)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN03	__BITS(7,6)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN02	__BITS(5,4)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN01	__BITS(3,2)
#define HW_PINCTRL_MUXSEL4_BANK2_PIN00	__BITS(1,0)

/* Pin 108, EMI_A06 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN15_EMI_ADDR06	0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN15_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN15_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN15_GPIO		0x03

/* Pin 107, EMI_A05 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN14_EMI_ADDR05	0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN14_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN14_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN14_GPIO		0x03

/* Pin 109, EMI_A04 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN13_EMI_ADDR04	0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN13_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN13_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN13_GPIO		0x03

/* Pin 110, EMI_A03 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN12_EMI_ADDR03	0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN12_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN12_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN12_GPIO		0x03

/* Pin 111, EMI_A02 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN11_EMI_ADDR02	0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN11_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN11_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN11_GPIO		0x03

/* Pin 112, EMI_A01 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN10_EMI_ADDR01	0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN10_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN10_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN10_GPIO		0x03

/* Pin 113, EMI_A00 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN09_EMI_ADDR00	0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN09_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN09_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN09_GPIO		0x03

/* Pin 38, ROTARYB pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN08_TIMROT2		0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN08_AUART2_CTS	0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN08_GPMI_CE3N	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN08_GPIO		0x03

/* Pin 37, ROTARYA pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN07_TIMROT1		0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN07_AUART2_RTS	0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN07_SPDIF		0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN07_GPIO		0x03

/* Pin 127, SSP1_SCK pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN06_SSP1_SCK		0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN06_RESERVED		0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN06_ALT_JTAG_TRST_N	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN06_GPIO		0x03

/* Pin 125, SSP1_DATA3 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN05_SSP1_D3		0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN05_RESERVED		0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN05_ALT_JTAG_TMS	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN05_GPIO		0x03

/* Pin 124, SSP1_DATA2 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN04_SSP1_D2		0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN04_I2C_SD		0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN04_ALT_JTAG_RTCK	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN04_GPIO		0x03

/* Pin 123, SSP1_DATA1 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN03_SSP1_D1		0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN03_I2C_CLK		0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN03_ALT_JTAG_TCK	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN03_GPIO		0x03

/* Pin 122, SSP1_DATA0 pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN02_SSP1_D0		0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN02_RESERVED		0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN02_ALT_JTAG_TDI	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN02_GPIO		0x03

/* Pin 126, SSP1_DETECT pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN01_SSP1_DETECT	0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN01_GPMI_CE3N	0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN01_USB_ID		0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN01_GPIO		0x03

/* Pin 121, SSP1_CMD pin function selection */
#define HW_PINCTRL_MUXSEL4_BANK2_PIN00_SSP1_CMD		0x00
#define HW_PINCTRL_MUXSEL4_BANK2_PIN00_RESERVED		0x01
#define HW_PINCTRL_MUXSEL4_BANK2_PIN00_ALT_JTAG_TDO	0x02
#define HW_PINCTRL_MUXSEL4_BANK2_PIN00_GPIO		0x03

/*
 * PINCTRL Pin Mux Select Register 5.
 */
#define HW_PINCTRL_MUXSEL5	0x150
#define HW_PINCTRL_MUXSEL5_SET	0x154
#define HW_PINCTRL_MUXSEL5_CLR	0x158
#define HW_PINCTRL_MUXSEL5_TOG	0x15C

#define HW_PINCTRL_MUXSEL5_BANK2_PIN31	__BITS(31,30)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN30	__BITS(29,28)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN29	__BITS(27,26)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN28	__BITS(25,24)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN27	__BITS(23,22)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN26	__BITS(21,20)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN25	__BITS(19,18)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN24	__BITS(17,16)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN23	__BITS(15,14)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN22	__BITS(13,12)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN21	__BITS(11,10)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN20	__BITS(9,8)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN19	__BITS(7,6)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN18	__BITS(5,4)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN17	__BITS(3,2)
#define HW_PINCTRL_MUXSEL5_BANK2_PIN16	__BITS(1,0)

/* Pin 114, EMI_WEN pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN31_EMI_WEN		0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN31_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN31_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN31_GPIO		0x03

/* Pin 98, EMI_RASN pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN30_EMI_RASN		0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN30_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN30_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN30_GPIO		0x03

/* Pin 115, EMI_CKE pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN29_EMI_CKE		0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN29_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN29_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN29_GPIO		0x03

/* Pin 120, GPMI_CE0N pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN28_GPMI_CE0N	0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN28_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN28_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN28_GPIO		0x03

/* Pin 118, GPMI_CE1N pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN27_GPMI_CE1N	0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN27_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN27_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN27_GPIO		0x03

/* Pin 99, EMI_CE1N pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN26_EMI_CE1N		0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN26_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN26_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN26_GPIO		0x03

/* Pin 100, EMI_CE0N pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN25_EMI_CE0N		0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN25_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN25_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN25_GPIO		0x03

/* Pin 97, EMI_CASN pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN24_EMI_CASN		0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN24_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN24_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN24_GPIO		0x03

/* Pin 117, EMI_BA1 pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN23_EMI_BA1		0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN23_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN23_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN23_GPIO		0x03

/* Pin 116, EMI_BA0 pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN22_EMI_BA0		0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN22_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN22_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN22_GPIO		0x03

/* Pin 101, EMI_A12 pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN21_EMI_ADDR12	0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN21_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN21_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN21_GPIO		0x03

/* Pin 102, EMI_A11 pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN20_EMI_ADDR11	0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN20_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN20_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN20_GPIO		0x03

/* Pin 104, EMI_A10 pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN19_EMI_ADDR10	0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN19_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN19_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN19_GPIO		0x03

/* Pin 103, EMI_A09 pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN18_EMI_ADDR09	0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN18_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN18_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN18_GPIO		0x03

/* Pin 106, EMI_A08 pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN17_EMI_ADDR08	0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN17_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN17_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN17_GPIO		0x03

/* Pin 105, EMI_A07 pin function selection */
#define HW_PINCTRL_MUXSEL5_BANK2_PIN16_EMI_ADDR07	0x00
#define HW_PINCTRL_MUXSEL5_BANK2_PIN16_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL5_BANK2_PIN16_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL5_BANK2_PIN16_GPIO		0x03

/*
 * PINCTRL Pin Mux Select Register 6.
 */
#define HW_PINCTRL_MUXSEL6	0x160
#define HW_PINCTRL_MUXSEL6_SET	0x164
#define HW_PINCTRL_MUXSEL6_CLR	0x168
#define HW_PINCTRL_MUXSEL6_TOG	0x16C

#define HW_PINCTRL_MUXSEL6_BANK3_PIN15	__BITS(31,30)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN14	__BITS(29,28)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN13	__BITS(27,26)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN12	__BITS(25,24)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN11	__BITS(23,22)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN10	__BITS(21,20)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN09	__BITS(19,18)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN08	__BITS(17,16)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN07	__BITS(15,14)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN06	__BITS(13,12)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN05	__BITS(11,10)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN04	__BITS(9,8)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN03	__BITS(7,6)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN02	__BITS(5,4)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN01	__BITS(3,2)
#define HW_PINCTRL_MUXSEL6_BANK3_PIN00	__BITS(1,0)

/* Pin 95, EMI_D15 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN15_EMI_DATA15	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN15_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN15_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN15_DISABLED		0x03

/* Pin 96, EMI_D14 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN14_EMI_DATA14	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN14_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN14_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN14_DISABLED		0x03

/* Pin 94, EMI_D13 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN13_EMI_DATA13	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN13_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN13_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN13_DISABLED		0x03

/* Pin 93, EMI_D12 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN12_EMI_DATA12	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN12_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN12_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN12_DISABLED		0x03

/* Pin 91, EMI_D11 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN11_EMI_DATA11	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN11_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN11_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN11_DISABLED		0x03

/* Pin 89, EMI_D10 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN10_EMI_DATA10	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN10_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN10_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN10_DISABLED		0x03

/* Pin 87, EMI_D09 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN09_EMI_DATA09	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN09_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN09_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN09_DISABLED		0x03

/* Pin 86, EMI_D08 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN08_EMI_DATA08	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN08_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN08_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN08_DISABLED		0x03

/* Pin 85, EMI_D07 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN07_EMI_DATA07	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN07_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN07_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN07_DISABLED		0x03

/* Pin 84, EMI_D06 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN06_EMI_DATA06	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN06_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN06_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN06_DISABLED		0x03

/* Pin 83, EMI_D05 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN05_EMI_DATA05	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN05_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN05_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN05_DISABLED		0x03

/* Pin 82, EMI_D04 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN04_EMI_DATA04	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN04_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN04_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN04_DISABLED		0x03

/* Pin 79, EMI_D03 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN03_EMI_DATA03	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN03_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN03_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN03_DISABLED		0x03

/* Pin 77, EMI_D02 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN02_EMI_DATA02	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN02_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN02_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN02_DISABLED		0x03

/* Pin 76, EMI_D01 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN01_EMI_DATA01	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN01_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN01_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN01_DISABLED		0x03

/* Pin 75, EMI_D00 pin function selection */
#define HW_PINCTRL_MUXSEL6_BANK3_PIN00_EMI_DATA00	0x00
#define HW_PINCTRL_MUXSEL6_BANK3_PIN00_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL6_BANK3_PIN00_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL6_BANK3_PIN00_DISABLED		0x03

/*
 * PINCTRL Pin Mux Select Register 7.
 */
#define HW_PINCTRL_MUXSEL7	0x170
#define HW_PINCTRL_MUXSEL7_SET	0x174
#define HW_PINCTRL_MUXSEL7_CLR	0x178
#define HW_PINCTRL_MUXSEL7_TOG	0x17C

#define HW_PINCTRL_MUXSEL7_RSRVD0	__BITS(31,12)
#define HW_PINCTRL_MUXSEL7_BANK3_PIN21	__BITS(11,10)
#define HW_PINCTRL_MUXSEL7_BANK3_PIN20	__BITS(9,8)
#define HW_PINCTRL_MUXSEL7_BANK3_PIN19	__BITS(7,6)
#define HW_PINCTRL_MUXSEL7_BANK3_PIN18	__BITS(5,4)
#define HW_PINCTRL_MUXSEL7_BANK3_PIN17	__BITS(3,2)
#define HW_PINCTRL_MUXSEL7_BANK3_PIN16	__BITS(1,0)

/* Always write zeroes to this field */
#define HW_PINCTRL_MUXSEL7_RSRVD0_ZERO			0x00

/* Pin 72, EMI_CLKN pin function selection */
#define HW_PINCTRL_MUXSEL7_BANK3_PIN21_EMI_CLKN		0x00
#define HW_PINCTRL_MUXSEL7_BANK3_PIN21_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL7_BANK3_PIN21_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL7_BANK3_PIN21_DISABLED		0x03

/* Pin 70, EMI_CLK pin function selection */
#define HW_PINCTRL_MUXSEL7_BANK3_PIN20_EMI_CLK		0x00
#define HW_PINCTRL_MUXSEL7_BANK3_PIN20_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL7_BANK3_PIN20_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL7_BANK3_PIN20_DISABLED		0x03

/* Pin 74, EMI_DQS1 pin function selection */
#define HW_PINCTRL_MUXSEL7_BANK3_PIN19_EMI_DQS1		0x00
#define HW_PINCTRL_MUXSEL7_BANK3_PIN19_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL7_BANK3_PIN19_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL7_BANK3_PIN19_DISABLED		0x03

/* Pin 73, EMI_DQS0 pin function selection */
#define HW_PINCTRL_MUXSEL7_BANK3_PIN18_EMI_DQS0		0x00
#define HW_PINCTRL_MUXSEL7_BANK3_PIN18_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL7_BANK3_PIN18_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL7_BANK3_PIN18_DISABLED		0x03

/* Pin 92, EMI_DQM1 pin function selection */
#define HW_PINCTRL_MUXSEL7_BANK3_PIN17_EMI_DQM1		0x00
#define HW_PINCTRL_MUXSEL7_BANK3_PIN17_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL7_BANK3_PIN17_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL7_BANK3_PIN17_DISABLED		0x03

/* Pin 81, EMI_DQM0 pin function selection */
#define HW_PINCTRL_MUXSEL7_BANK3_PIN16_EMI_DQM0		0x00
#define HW_PINCTRL_MUXSEL7_BANK3_PIN16_RESERVED1	0x01
#define HW_PINCTRL_MUXSEL7_BANK3_PIN16_RESERVED2	0x02
#define HW_PINCTRL_MUXSEL7_BANK3_PIN16_DISABLED		0x03

/*
 * PINCTRL Drive Strength and Voltage Register 0.
 */
#define HW_PINCTRL_DRIVE0       0x200
#define HW_PINCTRL_DRIVE0_SET   0x204
#define HW_PINCTRL_DRIVE0_CLR   0x208
#define HW_PINCTRL_DRIVE0_TOG   0x20C

/*
 * PINCTRL Drive Strength and Voltage Register 2.
 */
#define HW_PINCTRL_DRIVE2	0x220
#define HW_PINCTRL_DRIVE2_SET	0x224
#define HW_PINCTRL_DRIVE2_CLR	0x228
#define HW_PINCTRL_DRIVE2_TOG	0x22C

#define HW_PINCTRL_DRIVE2_RSRVD7		__BITS(31, 30)
#define HW_PINCTRL_DRIVE2_BANK0_PIN23_MA	__BITS(29, 28)
#define HW_PINCTRL_DRIVE2_RSRVD6		__BITS(27, 26)
#define HW_PINCTRL_DRIVE2_BANK0_PIN22_MA	__BITS(25, 24)
#define HW_PINCTRL_DRIVE2_RSRVD5		__BITS(23, 22)
#define HW_PINCTRL_DRIVE2_BANK0_PIN21_MA	__BITS(21, 20)
#define HW_PINCTRL_DRIVE2_RSRVD4		__BITS(19, 18)
#define HW_PINCTRL_DRIVE2_BANK0_PIN20_MA	__BITS(17, 16)
#define HW_PINCTRL_DRIVE2_RSRVD3		__BITS(15, 14)
#define HW_PINCTRL_DRIVE2_BANK0_PIN19_MA	__BITS(13, 12)
#define HW_PINCTRL_DRIVE2_RSRVD2		__BITS(11, 10)
#define HW_PINCTRL_DRIVE2_BANK0_PIN18_MA	__BITS(9, 8)
#define HW_PINCTRL_DRIVE2_RSRVD1		__BITS(7, 6)
#define HW_PINCTRL_DRIVE2_BANK0_PIN17_MA	__BITS(5, 4)
#define HW_PINCTRL_DRIVE2_RSRVD0		__BITS(3, 2)
#define HW_PINCTRL_DRIVE2_BANK0_PIN16_MA	__BITS(1, 0)

/*
 * PINCTRL Drive Strength and Voltage Register 8.
 */
#define HW_PINCTRL_DRIVE8	0x280
#define HW_PINCTRL_DRIVE8_SET	0x284
#define HW_PINCTRL_DRIVE8_CLR	0x288
#define HW_PINCTRL_DRIVE8_TOG	0x28C

#define HW_PINCTRL_DRIVE8_RSRVD7		__BITS(31, 30)
#define HW_PINCTRL_DRIVE8_BANK2_PIN07_MA	__BITS(29, 28)
#define HW_PINCTRL_DRIVE8_RSRVD6		__BITS(27, 26)
#define HW_PINCTRL_DRIVE8_BANK2_PIN06_MA	__BITS(25, 24)
#define HW_PINCTRL_DRIVE8_RSRVD5		__BITS(23, 22)
#define HW_PINCTRL_DRIVE8_BANK2_PIN05_MA	__BITS(21, 20)
#define HW_PINCTRL_DRIVE8_RSRVD4		__BITS(19, 18)
#define HW_PINCTRL_DRIVE8_BANK2_PIN04_MA	__BITS(17, 16)
#define HW_PINCTRL_DRIVE8_RSRVD3		__BITS(15, 14)
#define HW_PINCTRL_DRIVE8_BANK2_PIN03_MA	__BITS(13, 12)
#define HW_PINCTRL_DRIVE8_RSRVD2		__BITS(11, 10)
#define HW_PINCTRL_DRIVE8_BANK2_PIN02_MA	__BITS(9, 8)
#define HW_PINCTRL_DRIVE8_RSRVD1		__BITS(7, 6)
#define HW_PINCTRL_DRIVE8_BANK2_PIN01_MA	__BITS(5, 4)
#define HW_PINCTRL_DRIVE8_RSRVD0		__BITS(3, 2)
#define HW_PINCTRL_DRIVE8_BANK2_PIN00_MA	__BITS(1, 0)

/*
 * PINCTRL Drive Strength and Voltage Register 9.
 */
#define HW_PINCTRL_DRIVE9	0x290
#define HW_PINCTRL_DRIVE9_SET	0x294
#define HW_PINCTRL_DRIVE9_CLR	0x298
#define HW_PINCTRL_DRIVE9_TOG	0x29C

#define HW_PINCTRL_DRIVE9_RSRVD7		__BIT(31)
#define HW_PINCTRL_DRIVE9_BANK2_PIN15_V		__BIT(30)
#define HW_PINCTRL_DRIVE9_BANK2_PIN15_MA	__BITS(29, 28)
#define HW_PINCTRL_DRIVE9_RSRVD6		__BIT(27)
#define HW_PINCTRL_DRIVE9_BANK2_PIN14_V		__BIT(26)
#define HW_PINCTRL_DRIVE9_BANK2_PIN14_MA	__BITS(25, 24)
#define HW_PINCTRL_DRIVE9_RSRVD5		__BIT(23)
#define HW_PINCTRL_DRIVE9_BANK2_PIN13_V		__BIT(22)
#define HW_PINCTRL_DRIVE9_BANK2_PIN13_MA	__BITS(21, 20)
#define HW_PINCTRL_DRIVE9_RSRVD4		__BIT(19)
#define HW_PINCTRL_DRIVE9_BANK2_PIN12_V		__BIT(18)
#define HW_PINCTRL_DRIVE9_BANK2_PIN12_MA	__BITS(17, 16)
#define HW_PINCTRL_DRIVE9_RSRVD3		__BIT(15)
#define HW_PINCTRL_DRIVE9_BANK2_PIN11_V		__BIT(14)
#define HW_PINCTRL_DRIVE9_BANK2_PIN11_MA	__BITS(13, 12)
#define HW_PINCTRL_DRIVE9_RSRVD2		__BIT(11)
#define HW_PINCTRL_DRIVE9_BANK2_PIN10_V		__BIT(10)
#define HW_PINCTRL_DRIVE9_BANK2_PIN10_MA	__BITS(9, 8)
#define HW_PINCTRL_DRIVE9_RSRVD1		__BIT(7)
#define HW_PINCTRL_DRIVE9_BANK2_PIN09_V		__BIT(6)
#define HW_PINCTRL_DRIVE9_BANK2_PIN09_MA	__BITS(5, 4)
#define HW_PINCTRL_DRIVE9_RSRVD0		__BITS(3, 2)
#define HW_PINCTRL_DRIVE9_BANK2_PIN08_MA	__BITS(1, 0)

/*
 * PINCTRL Drive Strength and Voltage Register 10.
 */
#define HW_PINCTRL_DRIVE10	0x2a0
#define HW_PINCTRL_DRIVE10_SET	0x2a4
#define HW_PINCTRL_DRIVE10_CLR	0x2a8
#define HW_PINCTRL_DRIVE10_TOG	0x2ac

#define HW_PINCTRL_DRIVE10_RSRVD7		__BIT(31)
#define HW_PINCTRL_DRIVE10_BANK2_PIN23_V	__BIT(30)
#define HW_PINCTRL_DRIVE10_BANK2_PIN23_MA	__BITS(29, 28)
#define HW_PINCTRL_DRIVE10_RSRVD6		__BIT(27)
#define HW_PINCTRL_DRIVE10_BANK2_PIN22_V	__BIT(26)
#define HW_PINCTRL_DRIVE10_BANK2_PIN22_MA	__BITS(25, 24)
#define HW_PINCTRL_DRIVE10_RSRVD5		__BIT(23)
#define HW_PINCTRL_DRIVE10_BANK2_PIN21_V	__BIT(22)
#define HW_PINCTRL_DRIVE10_BANK2_PIN21_MA	__BITS(21, 20)
#define HW_PINCTRL_DRIVE10_RSRVD4		__BIT(19)
#define HW_PINCTRL_DRIVE10_BANK2_PIN20_V	__BIT(18)
#define HW_PINCTRL_DRIVE10_BANK2_PIN20_MA	__BITS(17, 16)
#define HW_PINCTRL_DRIVE10_RSRVD3		__BIT(15)
#define HW_PINCTRL_DRIVE10_BANK2_PIN19_V	__BIT(14)
#define HW_PINCTRL_DRIVE10_BANK2_PIN19_MA	__BITS(13, 12)
#define HW_PINCTRL_DRIVE10_RSRVD2		__BIT(11)
#define HW_PINCTRL_DRIVE10_BANK2_PIN18_V	__BIT(10)
#define HW_PINCTRL_DRIVE10_BANK2_PIN18_MA	__BITS(9, 8)
#define HW_PINCTRL_DRIVE10_RSRVD1		__BIT(7)
#define HW_PINCTRL_DRIVE10_BANK2_PIN17_V	__BIT(6)
#define HW_PINCTRL_DRIVE10_BANK2_PIN17_MA	__BITS(5, 4)
#define HW_PINCTRL_DRIVE10_RSRVD0		__BIT(3)
#define HW_PINCTRL_DRIVE10_BANK2_PIN16_V	__BIT(2)
#define HW_PINCTRL_DRIVE10_BANK2_PIN16_MA	__BITS(1, 0)

/*
 * PINCTRL Drive Strength and Voltage Register 11.
 */
#define HW_PINCTRL_DRIVE11	0x2b0
#define HW_PINCTRL_DRIVE11_SET	0x2b4
#define HW_PINCTRL_DRIVE11_CLR	0x2b8
#define HW_PINCTRL_DRIVE11_TOG	0x2bC

#define HW_PINCTRL_DRIVE11_RSRVD7		__BIT(31)
#define HW_PINCTRL_DRIVE11_BANK2_PIN31_V	__BIT(30)
#define HW_PINCTRL_DRIVE11_BANK2_PIN31_MA	__BITS(29, 28)
#define HW_PINCTRL_DRIVE11_RSRVD6		__BIT(27)
#define HW_PINCTRL_DRIVE11_BANK2_PIN30_V	__BIT(26)
#define HW_PINCTRL_DRIVE11_BANK2_PIN30_MA	__BITS(25, 24)
#define HW_PINCTRL_DRIVE11_RSRVD5		__BIT(23)
#define HW_PINCTRL_DRIVE11_BANK2_PIN29_V	__BIT(22)
#define HW_PINCTRL_DRIVE11_BANK2_PIN29_MA	__BITS(21, 20)
#define HW_PINCTRL_DRIVE11_RSRVD4		__BITS(19, 18)
#define HW_PINCTRL_DRIVE11_BANK2_PIN28_MA	__BIT(17, 16)
#define HW_PINCTRL_DRIVE11_RSRVD3		__BITS(15, 14)
#define HW_PINCTRL_DRIVE11_BANK2_PIN27_MA	__BITS(13, 12)
#define HW_PINCTRL_DRIVE11_RSRVD2		__BIT(11)
#define HW_PINCTRL_DRIVE11_BANK2_PIN26_V	__BIT(10)
#define HW_PINCTRL_DRIVE11_BANK2_PIN26_MA	__BITS(9, 8)
#define HW_PINCTRL_DRIVE11_RSRVD1		__BIT(7)
#define HW_PINCTRL_DRIVE11_BANK2_PIN25_V	__BIT(6)
#define HW_PINCTRL_DRIVE11_BANK2_PIN25_MA	__BITS(5, 4)
#define HW_PINCTRL_DRIVE11_RSRVD0		__BIT(3)
#define HW_PINCTRL_DRIVE11_BANK2_PIN24_V	__BIT(2)
#define HW_PINCTRL_DRIVE11_BANK2_PIN24_MA	__BITS(1, 0)

/*
 * PINCTRL Drive Strength and Voltage Register 12.
 */
#define HW_PINCTRL_DRIVE12	0x2c0
#define HW_PINCTRL_DRIVE12_SET	0x2c4
#define HW_PINCTRL_DRIVE12_CLR	0x2c8
#define HW_PINCTRL_DRIVE12_TOG	0x2cC

#define HW_PINCTRL_DRIVE12_RSRVD7		__BIT(31)
#define HW_PINCTRL_DRIVE12_BANK3_PIN07_V	__BIT(30)
#define HW_PINCTRL_DRIVE12_BANK3_PIN07_MA	__BITS(29, 28)
#define HW_PINCTRL_DRIVE12_RSRVD6		__BIT(27)
#define HW_PINCTRL_DRIVE12_BANK3_PIN06_V	__BIT(26)
#define HW_PINCTRL_DRIVE12_BANK3_PIN06_MA	__BITS(25, 24)
#define HW_PINCTRL_DRIVE12_RSRVD5		__BIT(23)
#define HW_PINCTRL_DRIVE12_BANK3_PIN05_V	__BIT(22)
#define HW_PINCTRL_DRIVE12_BANK3_PIN05_MA	__BITS(21, 20)
#define HW_PINCTRL_DRIVE12_RSRVD4		__BIT(19)
#define HW_PINCTRL_DRIVE12_BANK3_PIN04_V	__BIT(18)
#define HW_PINCTRL_DRIVE12_BANK3_PIN04_MA	__BITS(17, 15)
#define HW_PINCTRL_DRIVE12_RSRVD3		__BIT(15)
#define HW_PINCTRL_DRIVE12_BANK3_PIN03_V	__BIT(14)
#define HW_PINCTRL_DRIVE12_BANK3_PIN03_MA	__BITS(13, 12)
#define HW_PINCTRL_DRIVE12_RSRVD2		__BIT(11)
#define HW_PINCTRL_DRIVE12_BANK3_PIN02_V	__BIT(10)
#define HW_PINCTRL_DRIVE12_BANK3_PIN02_MA	__BITS(9, 8)
#define HW_PINCTRL_DRIVE12_RSRVD1		__BIT(7)
#define HW_PINCTRL_DRIVE12_BANK3_PIN01_V	__BIT(6)
#define HW_PINCTRL_DRIVE12_BANK3_PIN01_MA	__BITS(5, 4)
#define HW_PINCTRL_DRIVE12_RSRVD0		__BIT(3)
#define HW_PINCTRL_DRIVE12_BANK3_PIN00_V	__BIT(2)
#define HW_PINCTRL_DRIVE12_BANK3_PIN00_MA	__BITS(1, 0)

/*
 * PINCTRL Drive Strength and Voltage Register 13.
 */
#define HW_PINCTRL_DRIVE13	0x2d0
#define HW_PINCTRL_DRIVE13_SET	0x2d4
#define HW_PINCTRL_DRIVE13_CLR	0x2d8
#define HW_PINCTRL_DRIVE13_TOG	0x2dc

#define HW_PINCTRL_DRIVE13_RSRVD7		__BIT(31)
#define HW_PINCTRL_DRIVE13_BANK3_PIN15_V	__BIT(30)
#define HW_PINCTRL_DRIVE13_BANK3_PIN15_MA	__BITS(29, 28)
#define HW_PINCTRL_DRIVE13_RSRVD6		__BIT(27)
#define HW_PINCTRL_DRIVE13_BANK3_PIN14_V	__BIT(26)
#define HW_PINCTRL_DRIVE13_BANK3_PIN14_MA	__BITS(25, 24)
#define HW_PINCTRL_DRIVE13_RSRVD5		__BIT(23)
#define HW_PINCTRL_DRIVE13_BANK3_PIN13_V	__BIT(22)
#define HW_PINCTRL_DRIVE13_BANK3_PIN13_MA	__BITS(21, 20)
#define HW_PINCTRL_DRIVE13_RSRVD4		__BIT(19)
#define HW_PINCTRL_DRIVE13_BANK3_PIN12_V	__BIT(18)
#define HW_PINCTRL_DRIVE13_BANK3_PIN12_MA	__BITS(17, 16)
#define HW_PINCTRL_DRIVE13_RSRVD3		__BIT(15)
#define HW_PINCTRL_DRIVE13_BANK3_PIN11_V	__BIT(14)
#define HW_PINCTRL_DRIVE13_BANK3_PIN11_MA	__BITS(13, 12)
#define HW_PINCTRL_DRIVE13_RSRVD2		__BIT(11)
#define HW_PINCTRL_DRIVE13_BANK3_PIN10_V	__BIT(10)
#define HW_PINCTRL_DRIVE13_BANK3_PIN10_MA	__BITS(9, 8)
#define HW_PINCTRL_DRIVE13_RSRVD1		__BIT(7)
#define HW_PINCTRL_DRIVE13_BANK3_PIN09_V	__BIT(6)
#define HW_PINCTRL_DRIVE13_BANK3_PIN09_MA	__BITS(5, 4)
#define HW_PINCTRL_DRIVE13_RSRVD0		__BIT(3)
#define HW_PINCTRL_DRIVE13_BANK3_PIN08_V	__BIT(2)
#define HW_PINCTRL_DRIVE13_BANK3_PIN08_MA	__BITS(1, 0)

/*
 * PINCTRL Drive Strength and Voltage Register 14.
 */
#define HW_PINCTRL_DRIVE14	0x2e0
#define HW_PINCTRL_DRIVE14_SET	0x2e4
#define HW_PINCTRL_DRIVE14_CLR	0x2e8
#define HW_PINCTRL_DRIVE14_TOG	0x2ec

#define HW_PINCTRL_DRIVE14_RSRVD6		__BITS(31, 24)
#define HW_PINCTRL_DRIVE14_RSRVD5		__BIT(23)
#define HW_PINCTRL_DRIVE14_BANK3_PIN21_V	__BIT(22)
#define HW_PINCTRL_DRIVE14_BANK3_PIN21_MA	__BITS(21, 20)
#define HW_PINCTRL_DRIVE14_RSRVD4		__BIT(19)
#define HW_PINCTRL_DRIVE14_BANK3_PIN20_V	__BIT(18)
#define HW_PINCTRL_DRIVE14_BANK3_PIN20_MA	__BITS(17, 16)
#define HW_PINCTRL_DRIVE14_RSRVD3		__BIT(15)
#define HW_PINCTRL_DRIVE14_BANK3_PIN19_V	__BIT(14)
#define HW_PINCTRL_DRIVE14_BANK3_PIN19_MA	__BITS(13, 12)
#define HW_PINCTRL_DRIVE14_RSRVD2		__BIT(11)
#define HW_PINCTRL_DRIVE14_BANK3_PIN18_V	__BIT(10)
#define HW_PINCTRL_DRIVE14_BANK3_PIN18_MA	__BITS(9, 8)
#define HW_PINCTRL_DRIVE14_RSRVD1		__BIT(7)
#define HW_PINCTRL_DRIVE14_BANK3_PIN17_V	__BIT(6)
#define HW_PINCTRL_DRIVE14_BANK3_PIN17_MA	__BITS(5, 4)
#define HW_PINCTRL_DRIVE14_RSRVD0		__BIT(3)
#define HW_PINCTRL_DRIVE14_BANK3_PIN16_V	__BIT(2)
#define HW_PINCTRL_DRIVE14_BANK3_PIN16_MA	__BITS(1, 0)

/*
 * PINCTRL Bank 0 Pull Up Resistor Enable Register.
 */
#define HW_PINCTRL_PULL0        0x400
#define HW_PINCTRL_PULL0_SET    0x404
#define HW_PINCTRL_PULL0_CLR    0x408
#define HW_PINCTRL_PULL0_TOG    0x40C

/*
 * PINCTRL Bank 2 Pull Up Resistor Enable Register.
 */
#define HW_PINCTRL_PULL2	0x420
#define HW_PINCTRL_PULL2_SET	0x424
#define HW_PINCTRL_PULL2_CLR	0x428
#define HW_PINCTRL_PULL2_TOG	0x42C

#define HW_PINCTRL_PULL2_RSRVD2		__BITS(31, 29)
#define HW_PINCTRL_PULL2_BANK2_PIN28	__BIT(28)
#define HW_PINCTRL_PULL2_BANK2_PIN27	__BIT(27)
#define HW_PINCTRL_PULL2_RSRVD1		__BITS(26, 9)
#define HW_PINCTRL_PULL2_BANK2_PIN08	__BIT(8)
#define HW_PINCTRL_PULL2_RSRVD0		__BITS(7, 6)
#define HW_PINCTRL_PULL2_BANK2_PIN05	__BIT(5)
#define HW_PINCTRL_PULL2_BANK2_PIN04	__BIT(4)
#define HW_PINCTRL_PULL2_BANK2_PIN03	__BIT(3)
#define HW_PINCTRL_PULL2_BANK2_PIN02	__BIT(2)
#define HW_PINCTRL_PULL2_BANK2_PIN01	__BIT(1)
#define HW_PINCTRL_PULL2_BANK2_PIN00	__BIT(0)

/*
 * PINCTRL Bank 3 Pad Keeper Disable Register.
 */
#define HW_PINCTRL_PULL3	0x430
#define HW_PINCTRL_PULL3_SET	0x434
#define HW_PINCTRL_PULL3_CLR	0x438
#define HW_PINCTRL_PULL3_TOG	0x43C

#define HW_PINCTRL_PULL3_RSRVD0		__BITS(31, 18)
#define HW_PINCTRL_PULL3_BANK3_PIN17	__BIT(17)
#define HW_PINCTRL_PULL3_BANK3_PIN16	__BIT(16)
#define HW_PINCTRL_PULL3_BANK3_PIN15	__BIT(15)
#define HW_PINCTRL_PULL3_BANK3_PIN14	__BIT(14)
#define HW_PINCTRL_PULL3_BANK3_PIN13	__BIT(13)
#define HW_PINCTRL_PULL3_BANK3_PIN12	__BIT(12)
#define HW_PINCTRL_PULL3_BANK3_PIN11	__BIT(11)
#define HW_PINCTRL_PULL3_BANK3_PIN10	__BIT(10)
#define HW_PINCTRL_PULL3_BANK3_PIN09	__BIT(9)
#define HW_PINCTRL_PULL3_BANK3_PIN08	__BIT(8)
#define HW_PINCTRL_PULL3_BANK3_PIN07	__BIT(7)
#define HW_PINCTRL_PULL3_BANK3_PIN06	__BIT(6)
#define HW_PINCTRL_PULL3_BANK3_PIN05	__BIT(5)
#define HW_PINCTRL_PULL3_BANK3_PIN04	__BIT(4)
#define HW_PINCTRL_PULL3_BANK3_PIN03	__BIT(3)
#define HW_PINCTRL_PULL3_BANK3_PIN02	__BIT(2)
#define HW_PINCTRL_PULL3_BANK3_PIN01	__BIT(1)
#define HW_PINCTRL_PULL3_BANK3_PIN00	__BIT(0)

/*
 * PINCTRL Bank 0 Data Output Register.
 */
#define HW_PINCTRL_DOUT0	0x500
#define HW_PINCTRL_DOUT0_SET	0x504
#define HW_PINCTRL_DOUT0_CLR	0x508
#define HW_PINCTRL_DOUT0_TOG	0x50C

#define HW_PINCTRL_DOUT0_DOUT	__BITS(31, 0)

/*
 * PINCTRL Bank 1 Data Output Register.
 */
#define HW_PINCTRL_DOUT1	0x510
#define HW_PINCTRL_DOUT1_SET	0x514
#define HW_PINCTRL_DOUT1_CLR	0x518
#define HW_PINCTRL_DOUT1_TOG	0x51C

#define HW_PINCTRL_DOUT1_DOUT	__BITS(31, 0)

/*
 * PINCTRL Bank 0 Data Input Register.
 */
#define HW_PINCTRL_DIN0		0x600
#define HW_PINCTRL_DIN0_SET	0x604
#define HW_PINCTRL_DIN0_CLR	0x608
#define HW_PINCTRL_DIN0_TOG	0x60C

/*
 * PINCTRL Bank 0 Data Output Enable Register.
 */
#define HW_PINCTRL_DOE0		0x700
#define HW_PINCTRL_DOE0_SET	0x704
#define HW_PINCTRL_DOE0_CLR	0x708
#define HW_PINCTRL_DOE0_TOG	0x70C

#define HW_PINCTRL_DOE0_DOE	__BITS(31, 0)

#endif /* !_ARM_IMX_IMX23_PINCTRLREG_H_ */
