/* $NetBSD: imx23_digfiltreg.h,v 1.2 2026/02/02 06:23:37 skrll Exp $ */

/*
 * Copyright (c) 2014 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Petri Laakso.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX23_AUDIOOUTREG_H_
#define _ARM_IMX_IMX23_AUDIOOUTREG_H_

#include <sys/cdefs.h>

#define HW_DIGFILT_BASE		0x80048000
#define HW_DIGFILT_SIZE		0x8000 /* 32 kB */

#define HW_AUDIOOUT_BASE	0x80048000
#define HW_AUDIOOUT_SIZE	0x2000 /* 8 kB */

#define HW_AUDIOIN_BASE		0x8004C000
#define HW_AUDIOIN_SIZE		0x2000 /* 8 kB */

/*
 * AUDIOIN Control Register.
 */
#define HW_AUDIOIN_CTRL		0x000
#define HW_AUDIOIN_CTRL_SET	0x004
#define HW_AUDIOIN_CTRL_CLR	0x008
#define HW_AUDIOIN_CTRL_TOG	0x00C

#define HW_AUDIOIN_CTRL_SFTRST			__BIT(31)
#define HW_AUDIOIN_CTRL_CLKGATE			__BIT(30)
#define HW_AUDIOIN_CTRL_RSRVD3			__BITS(29, 21)
#define HW_AUDIOIN_CTRL_DMAWAIT_COUNT		__BITS(20, 16)
#define HW_AUDIOIN_CTRL_RSRVD1			__BITS(15, 11)
#define HW_AUDIOIN_CTRL_LR_SWAP			__BIT(10)
#define HW_AUDIOIN_CTRL_EDGE_SYNC		__BIT(9)
#define HW_AUDIOIN_CTRL_INVERT_1BIT		__BIT(8)
#define HW_AUDIOIN_CTRL_OFFSET_ENABLE		__BIT(7)
#define HW_AUDIOIN_CTRL_HPF_ENABLE		__BIT(6)
#define HW_AUDIOIN_CTRL_WORD_LENGTH		__BIT(5)
#define HW_AUDIOIN_CTRL_LOOPBACK		__BIT(4)
#define HW_AUDIOIN_CTRL_FIFO_UNDERFLOW_IRQ	__BIT(3)
#define HW_AUDIOIN_CTRL_FIFO_OVERFLOW_IRQ	__BIT(2)
#define HW_AUDIOIN_CTRL_FIFO_ERROR_IRQ_EN	__BIT(1)
#define HW_AUDIOIN_CTRL_RUN			__BIT(0)

/*
 * AUDIOOUT Control Register.
 */
#define HW_AUDIOOUT_CTRL	0x000
#define HW_AUDIOOUT_CTRL_SET	0x004
#define HW_AUDIOOUT_CTRL_CLR	0x008

#define HW_AUDIOOUT_CTRL_SFTRST			__BIT(31)
#define HW_AUDIOOUT_CTRL_CLKGATE		__BIT(30)
#define HW_AUDIOOUT_CTRL_RSRVD4			__BITS(29, 21)
#define HW_AUDIOOUT_CTRL_DMAWAIT_COUNT		__BITS(20, 16)
#define HW_AUDIOOUT_CTRL_RSRVD3			__BIT(15)
#define HW_AUDIOOUT_CTRL_LR_SWAP		__BIT(14)
#define HW_AUDIOOUT_CTRL_EDGE_SYNC		__BIT(13)
#define HW_AUDIOOUT_CTRL_INVERT_1BIT		__BIT(12)
#define HW_AUDIOOUT_CTRL_RSRVD2			__BITS(11, 10)
#define HW_AUDIOOUT_CTRL_SS3D_EFFECT		__BITS(9, 8)
#define HW_AUDIOOUT_CTRL_RSRVD1			__BIT(7)
#define HW_AUDIOOUT_CTRL_WORD_LENGTH		__BIT(6)
#define HW_AUDIOOUT_CTRL_DAC_ZERO_ENABLE	__BIT(5)
#define HW_AUDIOOUT_CTRL_LOOPBACK		__BIT(4)
#define HW_AUDIOOUT_CTRL_FIFO_UNDERFLOW_IRQ	__BIT(3)
#define HW_AUDIOOUT_CTRL_FIFO_OVERFLOW_IRQ	__BIT(2)
#define HW_AUDIOOUT_CTRL_FIFO_ERROR_IRQ_EN	__BIT(1)
#define HW_AUDIOOUT_CTRL_RUN			__BIT(0)

/*
 * AUDIOOUT Status Register.
 */
#define HW_AUDIOOUT_STAT	0x010
#define HW_AUDIOOUT_STAT_SET	0x014
#define HW_AUDIOOUT_STAT_CLR	0x018
#define HW_AUDIOOUT_STAT_TOG	0x01C

#define HW_AUDIOOUT_STAT_DAC_PRESENT	__BIT(31)
#define HW_AUDIOOUT_STAT_RSRVD1		__BITS(30, 0)

/*
 * AUDIOOUT Sample Rate Register.
 */
#define HW_AUDIOOUT_DACSRR	0x020
#define HW_AUDIOOUT_DACSRR_SET	0x024
#define HW_AUDIOOUT_DACSRR_CLR	0x028
#define HW_AUDIOOUT_DACSRR_TOG	0x02C

#define HW_AUDIOOUT_DACSRR_OSR		__BIT(31)
#define HW_AUDIOOUT_DACSRR_BASEMULT	__BITS(30, 28)
#define HW_AUDIOOUT_DACSRR_RSRVD2	__BIT(27)
#define HW_AUDIOOUT_DACSRR_SRC_HOLD	__BITS(26, 24)
#define HW_AUDIOOUT_DACSRR_RSRVD1	__BITS(23, 21)
#define HW_AUDIOOUT_DACSRR_SRC_INT	__BITS(20, 16)
#define HW_AUDIOOUT_DACSRR_RSRVD0	__BITS(15, 13)
#define HW_AUDIOOUT_DACSRR_SRC_FRAC	__BITS(12, 0)

/*
 * AUDIOOUT Volume Register.
 */
#define HW_AUDIOOUT_DACVOLUME		0x030
#define HW_AUDIOOUT_DACVOLUME_SET	0x034
#define HW_AUDIOOUT_DACVOLUME_CLR	0x038
#define HW_AUDIOOUT_DACVOLUME_TOG	0x03C

#define HW_AUDIOOUT_DACVOLUME_RSRVD4			__BITS(31, 29)
#define HW_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_LEFT	__BIT(28)
#define HW_AUDIOOUT_DACVOLUME_RSRVD3			__BITS(27, 26)
#define HW_AUDIOOUT_DACVOLUME_EN_ZCD			__BIT(25)
#define HW_AUDIOOUT_DACVOLUME_MUTE_LEFT			__BIT(24)
#define HW_AUDIOOUT_DACVOLUME_VOLUME_LEFT		__BITS(23, 16)
#define HW_AUDIOOUT_DACVOLUME_RSRVD2			__BITS(15, 13)
#define HW_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_RIGHT	__BIT(12)
#define HW_AUDIOOUT_DACVOLUME_RSRVD1			__BITS(11, 9)
#define HW_AUDIOOUT_DACVOLUME_MUTE_RIGHT		__BIT(8)
#define HW_AUDIOOUT_DACVOLUME_VOLUME_RIGHT		__BITS(7, 0)

/*
 * AUDIOOUT Debug Register.
 */
#define HW_AUDIOOUT_DACDEBUG	0x040
#define HW_AUDIOOUT_DACDEBUG_SET	0x044
#define HW_AUDIOOUT_DACDEBUG_CLR	0x048
#define HW_AUDIOOUT_DACDEBUG_TOG	0x04C

#define HW_AUDIOOUT_DACDEBUG_ENABLE_DACDMA		__BIT(31)
#define HW_AUDIOOUT_DACDEBUG_RSRVD2			__BITS(30, 12)
#define HW_AUDIOOUT_DACDEBUG_RAM_SS			__BITS(11, 8)
#define HW_AUDIOOUT_DACDEBUG_RSRVD1			__BITS(7, 6)
#define HW_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_CLK_CROSS	__BIT(5)
#define HW_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_CLK_CROSS	__BIT(4)
#define HW_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_HAND_SHAKE	__BIT(3)
#define HW_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_HAND_SHAKE	__BIT(2)
#define HW_AUDIOOUT_DACDEBUG_DMA_PREQ			__BIT(1)
#define HW_AUDIOOUT_DACDEBUG_FIFO_STATUS		__BIT(0)

/*
 * Headphone Volume and Select Control Register.
 */
#define HW_AUDIOOUT_HPVOL	0x050
#define HW_AUDIOOUT_HPVOL_SET	0x054
#define HW_AUDIOOUT_HPVOL_CLR		0x058
#define HW_AUDIOOUT_HPVOL_TOG		0x05C

#define HW_AUDIOOUT_HPVOL_RSRVD5		__BITS(31, 29)
#define HW_AUDIOOUT_HPVOL_VOLUME_UPDATE_PENDING	__BIT(28)
#define HW_AUDIOOUT_HPVOL_RSRVD4		__BITS(27, 26)
#define HW_AUDIOOUT_HPVOL_EN_MSTR_ZCD		__BIT(25)
#define HW_AUDIOOUT_HPVOL_MUTE			__BIT(24)
#define HW_AUDIOOUT_HPVOL_RSRVD3		__BITS(23, 17)
#define HW_AUDIOOUT_HPVOL_SELECT		__BIT(16)
#define HW_AUDIOOUT_HPVOL_RSRVD2		__BIT(15)
#define HW_AUDIOOUT_HPVOL_VOL_LEFT		__BITS(14, 8)
#define HW_AUDIOOUT_HPVOL_RSRVD1		__BIT(7)
#define HW_AUDIOOUT_HPVOL_VOL_RIGHT		__BITS(6, 0)

/*
 * Reserved Register.
 */
#define HW_AUDIOOUT_RESERVED	0x060
#define HW_AUDIOOUT_RESERVED_SET	0x064
#define HW_AUDIOOUT_RESERVED_CLR	0x068
#define HW_AUDIOOUT_RESERVED_TOG	0x06C

#define HW_AUDIOOUT_RESERVED_RSRVD1	__BITS(31, 0)

/*
 * Audio Power-Down Control Register.
 */
#define HW_AUDIOOUT_PWRDN	0x070
#define HW_AUDIOOUT_PWRDN_SET	0x074
#define HW_AUDIOOUT_PWRDN_CLR	0x078
#define HW_AUDIOOUT_PWRDN_TOG	0x07C

#define HW_AUDIOOUT_PWRDN_RSRVD7	__BITS(31, 25)
#define HW_AUDIOOUT_PWRDN_SPEAKER	__BIT(24)
#define HW_AUDIOOUT_PWRDN_RSRVD6	__BITS(23, 21)
#define HW_AUDIOOUT_PWRDN_SELFBIAS	__BIT(20)
#define HW_AUDIOOUT_PWRDN_RSRVD5	__BITS(19, 17)
#define HW_AUDIOOUT_PWRDN_RIGHT_ADC	__BIT(16)
#define HW_AUDIOOUT_PWRDN_RSRVD4	__BITS(15, 13)
#define HW_AUDIOOUT_PWRDN_DAC		__BIT(12)
#define HW_AUDIOOUT_PWRDN_RSRVD3	__BITS(11, 9)
#define HW_AUDIOOUT_PWRDN_ADC		__BIT(8)
#define HW_AUDIOOUT_PWRDN_RSRVD2	__BITS(7, 5)
#define HW_AUDIOOUT_PWRDN_CAPLESS	__BIT(4)
#define HW_AUDIOOUT_PWRDN_RSRVD1	__BITS(3, 1)
#define HW_AUDIOOUT_PWRDN_HEADPHONE	__BIT(0)

/*
 * AUDIOOUT Reference Control Register.
 */
#define HW_AUDIOOUT_REFCTRL	0x080
#define HW_AUDIOOUT_REFCTRL_SET	0x084
#define HW_AUDIOOUT_REFCTRL_CLR	0x088
#define HW_AUDIOOUT_REFCTRL_TOG	0x08C

#define HW_AUDIOOUT_REFCTRL_RSRVD4		__BITS(31, 27)
#define HW_AUDIOOUT_REFCTRL_FASTSETTLING	__BIT(26)
#define HW_AUDIOOUT_REFCTRL_RAISE_REF		__BIT(25)
#define HW_AUDIOOUT_REFCTRL_XTAL_BGR_BIAS	__BIT(24)
#define HW_AUDIOOUT_REFCTRL_RSRVD3		__BIT(23)
#define HW_AUDIOOUT_REFCTRL_VBG_ADJ		__BITS(22, 20)
#define HW_AUDIOOUT_REFCTRL_LOW_PWR		__BIT(19)
#define HW_AUDIOOUT_REFCTRL_LW_REF		__BIT(18)
#define HW_AUDIOOUT_REFCTRL_BIAS_CTRL		__BITS(17, 16)
#define HW_AUDIOOUT_REFCTRL_RSRVD2		__BIT(15)
#define HW_AUDIOOUT_REFCTRL_VDDXTAL_TO_VDDD	__BIT(14)
#define HW_AUDIOOUT_REFCTRL_ADJ_ADC		__BIT(13)
#define HW_AUDIOOUT_REFCTRL_ADJ_VAG		__BIT(12)
#define HW_AUDIOOUT_REFCTRL_ADC_REFVAL		__BITS(11, 8)
#define HW_AUDIOOUT_REFCTRL_VAG_VAL		__BITS(7, 4)
#define HW_AUDIOOUT_REFCTRL_RSRVD1		__BIT(3)
#define HW_AUDIOOUT_REFCTRL_DAC_ADJ		__BIT(2, 0)

/*
 * Miscellaneous Audio Controls Register.
 */
#define HW_AUDIOOUT_ANACTRL	0x090
#define HW_AUDIOOUT_ANACTRL_SET	0x094
#define HW_AUDIOOUT_ANACTRL_CLR	0x098
#define HW_AUDIOOUT_ANACTRL_TOG	0x09C

#define HW_AUDIOOUT_ANACTRL_RSRVD8		__BITS(31, 29)
#define HW_AUDIOOUT_ANACTRL_SHORT_CM_STS	__BIT(28)
#define HW_AUDIOOUT_ANACTRL_RSRVD7		__BITS(27, 25)
#define HW_AUDIOOUT_ANACTRL_SHORT_LR_STS	__BIT(24)
#define HW_AUDIOOUT_ANACTRL_RSRVD6		__BITS(23, 22)
#define HW_AUDIOOUT_ANACTRL_SHORTMODE_CM	__BIT(21, 20)
#define HW_AUDIOOUT_ANACTRL_RSRVD5		__BIT(19)
#define HW_AUDIOOUT_ANACTRL_SHORTMODE_LR	__BITS(18, 17)
#define HW_AUDIOOUT_ANACTRL_RSRVD4		__BITS(16, 15)
#define HW_AUDIOOUT_ANACTRL_SHORT_LVLADJL	__BITS(14, 12)
#define HW_AUDIOOUT_ANACTRL_RSRVD3		__BIT(11)
#define HW_AUDIOOUT_ANACTRL_SHORT_LVLADJR	__BITS(10, 8)
#define HW_AUDIOOUT_ANACTRL_RSRVD2		__BITS(7, 6)
#define HW_AUDIOOUT_ANACTRL_HP_HOLD_GND		__BIT(5)
#define HW_AUDIOOUT_ANACTRL_HP_CLASSAB		__BIT(4)
#define HW_AUDIOOUT_ANACTRL_RSRVD1		__BITS(3, 0)

/*
 * Miscellaneous Test Audio Controls Register.
 */
#define HW_AUDIOOUT_TEST	0x0a0
#define HW_AUDIOOUT_TEST_SET	0x0a4
#define HW_AUDIOOUT_TEST_CLR	0x0a8
#define HW_AUDIOOUT_TEST_TOG	0x0aC

#define HW_AUDIOOUT_TEST_RSRVD4		__BIT(31)
#define HW_AUDIOOUT_TEST_HP_ANTIPOP	__BITS(30, 28)
#define HW_AUDIOOUT_TEST_RSRVD3		__BIT(27)
#define HW_AUDIOOUT_TEST_TM_ADCIN_TOHP	__BIT(26)
#define HW_AUDIOOUT_TEST_TM_LOOP	__BIT(25)
#define HW_AUDIOOUT_TEST_TM_HPCOMMON	__BIT(24)
#define HW_AUDIOOUT_TEST_HP_I1_ADJ	__BITS(23, 22)
#define HW_AUDIOOUT_TEST_HP_IALL_ADJ	__BITS(21, 20)
#define HW_AUDIOOUT_TEST_RSRVD2		__BITS(19, 14)
#define HW_AUDIOOUT_TEST_VAG_CLASSA	__BIT(13)
#define HW_AUDIOOUT_TEST_VAG_DOUBLE_I	__BIT(12)
#define HW_AUDIOOUT_TEST_RSRVD1		__BITS(11, 4)
#define HW_AUDIOOUT_TEST_ADCTODAC_LOOP	__BIT(3)
#define HW_AUDIOOUT_TEST_DAC_CLASSA	__BIT(2)
#define HW_AUDIOOUT_TEST_DAC_DOUBLE_I	__BIT(1)
#define HW_AUDIOOUT_TEST_DAC_DIS_RTZ	__BIT(0)

/*
 * BIST Control and Status Register.
 */
#define HW_AUDIOOUT_BISTCTRL	0x0b0
#define HW_AUDIOOUT_BISTCTRL_SET	0x0b4
#define HW_AUDIOOUT_BISTCTRL_CLR	0x0b8
#define HW_AUDIOOUT_BISTCTRL_TOG	0x0bC

#define HW_AUDIOOUT_BISTCTRL_RSVD0	__BITS(31, 4)
#define HW_AUDIOOUT_BISTCTRL_FAIL	__BIT(3)
#define HW_AUDIOOUT_BISTCTRL_PASS	__BIT(2)
#define HW_AUDIOOUT_BISTCTRL_DONE	__BIT(1)
#define HW_AUDIOOUT_BISTCTRL_START	__BIT(0)

/*
 * Hardware BIST Status 0 Register.
 */
#define HW_AUDIOOUT_BISTSTAT0	0x0c0
#define HW_AUDIOOUT_BISTSTAT0_SET	0x0c4
#define HW_AUDIOOUT_BISTSTAT0_CLR	0x0c8
#define HW_AUDIOOUT_BISTSTAT0_TOG	0x0cC

#define HW_AUDIOOUT_BISTSTAT0_RSVD0	__BITS(31, 24)
#define HW_AUDIOOUT_BISTSTAT0_DATA	__BITS(23, 0)

/*
 * Hardware AUDIOUT BIST Status 1 Register.
 */
#define HW_AUDIOOUT_BISTSTAT1	0x0d0
#define HW_AUDIOOUT_BISTSTAT1_SET	0x0d4
#define HW_AUDIOOUT_BISTSTAT1_CLR	0x0d8
#define HW_AUDIOOUT_BISTSTAT1_TOG	0x0dC

#define HW_AUDIOOUT_BISTSTAT1_RSVD1	__BITS(31, 29)
#define HW_AUDIOOUT_BISTSTAT1_STATE	__BITS(28, 24)
#define HW_AUDIOOUT_BISTSTAT1_RSVD0	__BITS(23, 8)
#define HW_AUDIOOUT_BISTSTAT1_ADDR	__BITS(7, 0)

/*
 * Analog Clock Control Register.
 */
#define HW_AUDIOOUT_ANACLKCTRL	0x0e0
#define HW_AUDIOOUT_ANACLKCTRL_SET	0x0e4
#define HW_AUDIOOUT_ANACLKCTRL_CLR	0x0e8
#define HW_AUDIOOUT_ANACLKCTRL_TOG	0x0eC

#define HW_AUDIOOUT_ANACLKCTRL_CLKGATE		__BIT(31)
#define HW_AUDIOOUT_ANACLKCTRL_RSRVD3		__BITS(30, 5)
#define HW_AUDIOOUT_ANACLKCTRL_INVERT_DACCLK	__BIT(4)
#define HW_AUDIOOUT_ANACLKCTRL_RSRVD2		__BIT(3)
#define HW_AUDIOOUT_ANACLKCTRL_DACDIV		__BITS(2, 0)

/*
 * AUDIOOUT Write Data Register.
 */
#define HW_AUDIOOUT_DATA	0x0f0
#define HW_AUDIOOUT_DATA_SET	0x0f4
#define HW_AUDIOOUT_DATA_CLR	0x0f8
#define HW_AUDIOOUT_DATA_TOG	0x0fC

#define HW_AUDIOOUT_DATA_HIGH	__BITS(31, 16)
#define HW_AUDIOOUT_DATA_LOW	__BITS(15, 0)

/*
 * AUDIOOUT Speaker Control Register.
 */
#define HW_AUDIOOUT_SPEAKERCTRL	0x100
#define HW_AUDIOOUT_SPEAKERCTRL_SET	0x104
#define HW_AUDIOOUT_SPEAKERCTRL_CLR	0x108
#define HW_AUDIOOUT_SPEAKERCTRL_TOG	0x10C

#define HW_AUDIOOUT_SPEAKERCTRL_RSRVD2		__BITS(31, 25)
#define HW_AUDIOOUT_SPEAKERCTRL_MUTE		__BIT(24)
#define HW_AUDIOOUT_SPEAKERCTRL_I1_ADJ		__BITS(23, 22)
#define HW_AUDIOOUT_SPEAKERCTRL_IALL_ADJ	__BITS(21, 20)
#define HW_AUDIOOUT_SPEAKERCTRL_RSRVD1		__BITS(19, 16)
#define HW_AUDIOOUT_SPEAKERCTRL_POSDRIVER	__BITS(15, 14)
#define HW_AUDIOOUT_SPEAKERCTRL_NEGDRIVER	__BITS(13, 12)
#define HW_AUDIOOUT_SPEAKERCTRL_RSRVD0		__BITS(11, 0)

/*
 * AUDIOOUT Version Register.
 */
#define HW_AUDIOOUT_VERSION	0x200

#define HW_AUDIOOUT_VERSION_MAJOR	__BITS(31, 24)
#define HW_AUDIOOUT_VERSION_MINOR	__BITS(23, 16)
#define HW_AUDIOOUT_VERSION_STEP	__BITS(15, 0)

#endif /* !_ARM_IMX_IMX23_AUDIOOUTREG_H_ */
